/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceDOMParser;
import org.eclipse.pde.internal.core.XMLErrorHandler;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.isite.ISiteModelFactory;
import org.eclipse.pde.internal.core.site.Site;
import org.eclipse.pde.internal.core.site.SiteModelFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractSiteModel
extends AbstractModel
implements ISiteModel {
    protected transient Site site;
    private transient ISiteModelFactory factory;
    private boolean enabled = true;
    private ISiteBuildModel siteBuildModel;

    public ISite getSite() {
        if (this.site == null) {
            Site s = new Site();
            s.model = this;
            this.site = s;
        }
        return this.site;
    }

    public ISiteBuildModel getBuildModel() {
        return this.siteBuildModel;
    }

    public void setBuildModel(ISiteBuildModel buildModel) {
        this.siteBuildModel = buildModel;
    }

    public ISiteModelFactory getFactory() {
        if (this.factory == null) {
            this.factory = new SiteModelFactory(this);
        }
        return this.factory;
    }

    public String getInstallLocation() {
        return null;
    }

    public boolean isEditable() {
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isValid() {
        if (!this.isLoaded() || this.site == null) {
            return false;
        }
        return this.site.isValid();
    }

    public void load(InputStream stream, boolean outOfSync) throws CoreException {
        SourceDOMParser parser = new SourceDOMParser();
        XMLErrorHandler errorHandler = new XMLErrorHandler();
        parser.setErrorHandler(errorHandler);
        try {
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        }
        catch (SAXException sAXException) {}
        try {
            InputSource source = new InputSource(stream);
            URL dtdLocation = PDECore.getDefault().getDescriptor().getInstallURL();
            source.setSystemId(dtdLocation.toString());
            parser.parse(source);
            if (errorHandler.getErrorCount() > 0 || errorHandler.getFatalErrorCount() > 0) {
                this.throwParseErrorsException();
            }
            this.processDocument(parser.getDocument(), parser.getLineTable());
            this.loaded = true;
            if (!outOfSync) {
                this.updateTimeStamp();
            }
        }
        catch (SAXException sAXException) {
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    private void processDocument(Document doc, Hashtable lineTable) {
        Element rootNode = doc.getDocumentElement();
        if (this.site == null) {
            this.site = new Site();
            this.site.model = this;
        } else {
            this.site.reset();
        }
        this.site.parse(rootNode, lineTable);
    }

    public void reload(InputStream stream, boolean outOfSync) throws CoreException {
        if (this.site != null) {
            this.site.reset();
        }
        this.load(stream, outOfSync);
        this.fireModelChanged(new ModelChangedEvent(99, new Object[]{this.site}, null));
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

