/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.search.IPluginSearchResultCollector;
import org.eclipse.pde.internal.core.search.PluginSearchInput;
import org.eclipse.pde.internal.core.util.StringMatcher;

public class PluginSearchOperation {
    protected PluginSearchInput input;
    private IPluginSearchResultCollector collector;
    private StringMatcher stringMatcher;
    private String taskName;

    public PluginSearchOperation(PluginSearchInput input, IPluginSearchResultCollector collector) {
        this.input = input;
        this.collector = collector;
        collector.setOperation(this);
        this.stringMatcher = new StringMatcher(input.getSearchString(), !input.isCaseSensitive(), false);
    }

    public void execute(IProgressMonitor monitor) {
        IPluginModelBase[] entries = this.input.getSearchScope().getMatchingModels();
        this.collector.searchStarted();
        this.collector.setProgressMonitor(monitor);
        monitor.beginTask("", entries.length);
        try {
            int i = 0;
            while (i < entries.length) {
                IPluginModelBase candidate = entries[i];
                this.visit(candidate);
                monitor.worked(1);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            this.collector.done();
            throw throwable;
        }
        Object var5_7 = null;
        monitor.done();
        this.collector.done();
    }

    private void visit(IPluginModelBase model) {
        ArrayList matches = this.findMatch(model);
        int i = 0;
        while (i < matches.size()) {
            this.collector.accept((IPluginObject)matches.get(i));
            ++i;
        }
    }

    private ArrayList findMatch(IPluginModelBase model) {
        ArrayList result = new ArrayList();
        int searchLimit = this.input.getSearchLimit();
        switch (this.input.getSearchElement()) {
            case 1: {
                if (searchLimit != 2) {
                    this.findPluginDeclaration(model, result);
                }
                if (searchLimit == 1) break;
                this.findPluginReferences(model, result);
                break;
            }
            case 2: {
                this.findFragmentDeclaration(model, result);
                break;
            }
            case 3: {
                if (searchLimit != 2) {
                    this.findExtensionPointDeclarations(model, result);
                }
                if (searchLimit == 1) break;
                this.findExtensionPointReferences(model, result);
            }
        }
        return result;
    }

    private void findFragmentDeclaration(IPluginModelBase model, ArrayList result) {
        IPluginBase pluginBase = model.getPluginBase();
        if (pluginBase instanceof IFragment && this.stringMatcher.match(pluginBase.getId())) {
            result.add(pluginBase);
        }
    }

    private void findPluginDeclaration(IPluginModelBase model, ArrayList result) {
        IPluginBase pluginBase = model.getPluginBase();
        if (pluginBase instanceof IPlugin && this.stringMatcher.match(pluginBase.getId())) {
            result.add(pluginBase);
        }
    }

    private void findPluginReferences(IPluginModelBase model, ArrayList result) {
        IPluginBase pluginBase = model.getPluginBase();
        if (pluginBase instanceof IFragment && this.stringMatcher.match(((IFragment)pluginBase).getPluginId())) {
            result.add(pluginBase);
        }
        IPluginImport[] imports = pluginBase.getImports();
        int i = 0;
        while (i < imports.length) {
            if (this.stringMatcher.match(imports[i].getId())) {
                result.add(imports[i]);
            }
            ++i;
        }
    }

    private void findExtensionPointDeclarations(IPluginModelBase model, ArrayList result) {
        IPluginExtensionPoint[] extensionPoints = model.getPluginBase().getExtensionPoints();
        int i = 0;
        while (i < extensionPoints.length) {
            if (this.stringMatcher.match(extensionPoints[i].getFullId())) {
                result.add(extensionPoints[i]);
            }
            ++i;
        }
    }

    private void findExtensionPointReferences(IPluginModelBase model, ArrayList result) {
        IPluginExtension[] extensions = model.getPluginBase().getExtensions();
        int i = 0;
        while (i < extensions.length) {
            if (this.stringMatcher.match(extensions[i].getPoint())) {
                result.add(extensions[i]);
            }
            ++i;
        }
    }
}

