/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLEntityScanner;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.parsers.DOMBuilderImpl;
import org.apache.xerces.parsers.XMLParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.internal.core.plugin.IDocumentModelFactory;
import org.eclipse.pde.internal.core.plugin.IDocumentNode;
import org.eclipse.pde.internal.core.plugin.IProblemRequestor;
import org.eclipse.pde.internal.core.plugin.ISourceRange;
import org.eclipse.pde.internal.core.plugin.SourceRange;
import org.eclipse.pde.internal.core.plugin.XEDocumentScanner;
import org.eclipse.pde.internal.core.plugin.XEErrorHandler;
import org.eclipse.pde.internal.core.plugin.XEParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLDocumentModelBuilder
extends DOMBuilderImpl {
    private Hashtable fLines = new Hashtable();
    private XMLLocator fLocator;
    private XMLLocator fOldLocator;
    private int fLastLine;
    private int fLastColumn;
    private List fChildren = new ArrayList();
    private List fChildIndices = new ArrayList();
    private IDocumentModelFactory fModelFactory;
    private Map fRecoveredAttributes;
    private String fRecoveredRawname;
    private Set fIds = new TreeSet();

    public XMLDocumentModelBuilder(XMLParserConfiguration config, boolean validate) {
        super(config);
        this.initialize(validate);
    }

    protected void initialize(boolean validate) {
        this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        this.setFeature("http://xml.org/sax/features/validation", validate);
        this.setFeature("validate-against-dtd", validate);
        this.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", true);
    }

    public void setProblemRequestor(IProblemRequestor requestor) {
        XEErrorHandler handler = null;
        if (requestor != null) {
            handler = new XEErrorHandler(requestor);
        }
        ((XMLParser)this).fConfiguration.setErrorHandler(handler);
    }

    public void setErrorHandler(XMLErrorHandler handler) {
        ((XMLParser)this).fConfiguration.setErrorHandler(handler);
    }

    public void setDocumentModelFactory(IDocumentModelFactory factory) {
        this.fModelFactory = factory;
    }

    public void parse(IDocument document) throws IOException {
        this.parse(new XMLInputSource(null, null, null, (Reader)new StringReader(document.get()), null));
    }

    public Object getProperty(String propertyId) throws XMLConfigurationException {
        return ((XMLParser)this).fConfiguration.getProperty(propertyId);
    }

    private void startRange(Node node) {
        this.startRange(node, 0);
    }

    private void startRange(Node node, int columnOffset) {
        Assert.isTrue((!((AbstractDOMParser)this).fInDTDExternalSubset ? 1 : 0) != 0);
        Assert.isTrue((node != null ? 1 : 0) != 0);
        if (!this.fLines.containsKey(node)) {
            SourceRange sourceRange = new SourceRange();
            sourceRange.setStartLine(this.fLastLine);
            sourceRange.setStartColumn(this.fLastColumn);
            this.fLines.put(node, sourceRange);
            this.startSubtree();
        } else {
            Assert.isTrue((boolean)true);
        }
        this.updateLastPosition(columnOffset);
    }

    private void endRange(Node node) {
        this.endRange(node, 0);
    }

    private void endRange(Node node, int columnOffset) {
        Assert.isTrue((!((AbstractDOMParser)this).fInDTDExternalSubset ? 1 : 0) != 0);
        Assert.isTrue((node != null ? 1 : 0) != 0);
        ISourceRange sourceRange = (ISourceRange)this.fLines.get(node);
        Assert.isTrue((sourceRange != null ? 1 : 0) != 0);
        boolean firstPass = sourceRange.getEndLine() == -1;
        sourceRange.setEndLine(this.fLocator.getLineNumber());
        sourceRange.setEndColumn(this.fLocator.getColumnNumber() + columnOffset);
        if (firstPass) {
            this.endSubtree(node);
        }
        this.updateLastPosition(columnOffset);
    }

    private void updateLastPosition() {
        this.updateLastPosition(0);
    }

    private void updateLastPosition(int columnOffset) {
        Assert.isTrue((!((AbstractDOMParser)this).fInDTDExternalSubset ? 1 : 0) != 0);
        this.fLastLine = this.fLocator.getLineNumber();
        this.fLastColumn = this.fLocator.getColumnNumber() + columnOffset;
    }

    public Hashtable getLineTable() {
        return this.fLines;
    }

    public IDocumentNode getModelRoot() {
        if (this.fChildren.size() == 1) {
            Assert.isTrue((this.fChildIndices.size() == 0 ? 1 : 0) != 0);
            return (IDocumentNode)this.fChildren.get(0);
        }
        if (this.fChildren.size() > 1) {
            Assert.isTrue((boolean)false);
        }
        return null;
    }

    private String extract(XMLString text) {
        return new String(text.ch, text.offset, text.length);
    }

    private void recoverFromFatalError(Exception ex) {
        this.repairXMLTree();
        this.recoverTagAttributes(ex);
    }

    private void recoverTagAttributes(Exception ex) {
        Object obj;
        if (ex instanceof XEParseException && (obj = ((XMLParser)this).fConfiguration.getProperty("http://apache.org/xml/properties/internal/document-scanner")) instanceof XEDocumentScanner) {
            XEDocumentScanner documentScanner = (XEDocumentScanner)((Object)obj);
            this.fRecoveredRawname = documentScanner.getRawname();
            XMLAttributes attributes = documentScanner.getAttributes();
            if (attributes != null) {
                String element;
                int index;
                if (this.fRecoveredRawname != null && (index = (element = this.fRecoveredRawname).indexOf(58)) > 0) {
                    element = element.substring(index + 1);
                }
                this.fRecoveredAttributes = new HashMap(attributes.getLength());
                int i = 0;
                while (i < attributes.getLength()) {
                    Attr attr = ((AbstractDOMParser)this).fDocument.createAttributeNS(attributes.getURI(i), attributes.getQName(i));
                    attr.setValue(attributes.getValue(i));
                    this.fRecoveredAttributes.put(attributes.getLocalName(i), attr);
                    ++i;
                }
            }
        }
    }

    private void repairXMLTree() {
        if (this.fChildIndices.size() > 0 && ((AbstractDOMParser)this).fCurrentNode != null) {
            Node parent;
            Node node = ((AbstractDOMParser)this).fCurrentNode.getLastChild();
            if (node == null) {
                node = ((AbstractDOMParser)this).fCurrentNode;
            }
            ISourceRange sourceRange = (ISourceRange)this.fLines.get(node);
            while (sourceRange.getEndLine() != -1) {
                parent = node.getParentNode();
                Assert.isTrue((node != parent && parent != null ? 1 : 0) != 0);
                node = parent;
                sourceRange = (ISourceRange)this.fLines.get(node);
            }
            parent = node.getParentNode();
            while (node != parent) {
                this.endRange(node);
                node = parent;
                Node node2 = parent = node == null ? null : node.getParentNode();
            }
        }
    }

    private void startSubtree() {
        this.fChildIndices.add(new Integer(this.fChildren.size()));
    }

    private void endSubtree(Node domNode) {
        int firstChild = (Integer)this.fChildIndices.remove(this.fChildIndices.size() - 1);
        int nOfChildren = this.fChildren.size() - firstChild;
        IDocumentNode[] children = null;
        if (nOfChildren > 0) {
            children = new IDocumentNode[nOfChildren];
            int i = nOfChildren - 1;
            while (i >= 0) {
                children[i] = (IDocumentNode)this.fChildren.remove(firstChild + i);
                --i;
            }
        }
        IDocumentNode currentNode = this.fModelFactory.createXMLNode(children, domNode);
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                children[i].setParent(currentNode);
                ++i;
            }
        }
        if (currentNode != null) {
            this.fChildren.add(currentNode);
            this.fLines.put(currentNode, this.fLines.get(domNode));
        }
    }

    public void reset() throws XNIException {
        super.reset();
        this.fChildIndices.clear();
        this.fChildren.clear();
        this.fLastColumn = 0;
        this.fLastLine = 0;
        this.fLines.clear();
        this.fLocator = null;
        this.fOldLocator = null;
        this.fRecoveredAttributes = null;
        this.fRecoveredRawname = null;
        this.fIds.clear();
    }

    public void startDocument(XMLLocator locator, String encoding, Augmentations augs) throws XNIException {
        super.startDocument(locator, encoding, augs);
        this.fLocator = locator;
        this.startRange(((AbstractDOMParser)this).fCurrentNode);
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        super.xmlDecl(version, encoding, standalone, augs);
        Element element = ((AbstractDOMParser)this).fDocument.createElement("XML");
        element.setAttribute("version", version);
        element.setAttribute("encoding", encoding);
        element.setAttribute("standalone", standalone);
        ((AbstractDOMParser)this).fCurrentNode.appendChild(element);
        this.startRange(element);
        this.endRange(element);
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        super.doctypeDecl(rootElement, publicId, systemId, augs);
        try {
            XMLEntityManager entityManager = (XMLEntityManager)((XMLParser)this).fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-manager");
            XMLEntityScanner entityScanner = entityManager.getEntityScanner();
            if ((char)entityScanner.peekChar() == '>') {
                Node node = ((AbstractDOMParser)this).fCurrentNode.getLastChild();
                this.startRange(node, 1);
                this.endRange(node, 1);
                return;
            }
        }
        catch (IOException iOException) {}
        Node node = ((AbstractDOMParser)this).fCurrentNode.getLastChild();
        this.startRange(node);
        this.endRange(node);
    }

    public void comment(XMLString text, Augmentations augmentations) throws XNIException {
        if (!((AbstractDOMParser)this).fInDTDExternalSubset) {
            super.comment(text, augmentations);
            Node node = ((AbstractDOMParser)this).fCurrentNode.getLastChild();
            this.startRange(node);
            this.endRange(node);
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augmentations) throws XNIException {
        super.processingInstruction(target, data, augmentations);
        if (((AbstractDOMParser)this).fInDTDExternalSubset) {
            Assert.isTrue((boolean)true);
        } else {
            Node node = ((AbstractDOMParser)this).fCurrentNode.getLastChild();
            this.startRange(node);
            this.endRange(node);
        }
    }

    public void startElement(QName element, XMLAttributes atts, Augmentations augs) throws XNIException {
        int i = 0;
        while (i < atts.getLength()) {
            String value = atts.getValue(i);
            if (atts.getType(i).equals("ID") && value.length() > 0) {
                this.fIds.add(value);
            }
            ++i;
        }
        super.startElement(element, atts, augs);
        this.startRange(((AbstractDOMParser)this).fCurrentNode);
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        super.characters(text, augs);
        Node node = ((AbstractDOMParser)this).fCurrentNode.getLastChild();
        this.startRange(node);
        this.endRange(node);
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        super.ignorableWhitespace(text, augs);
        Node node = ((AbstractDOMParser)this).fCurrentNode.getLastChild();
        this.startRange(node);
        this.endRange(node);
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        super.endElement(element, augs);
        this.endRange(((AbstractDOMParser)this).fCurrentNode.getLastChild());
    }

    public void endDocument(Augmentations augs) throws XNIException {
        if (this.fLocator.getLineNumber() > this.fLastLine || this.fLocator.getColumnNumber() > this.fLastColumn) {
            Text textNode = ((AbstractDOMParser)this).fDocument.createTextNode("#unknown text#");
            ((AbstractDOMParser)this).fCurrentNode.appendChild(textNode);
            this.startRange(textNode);
            this.endRange(textNode);
        }
        Node node = ((AbstractDOMParser)this).fCurrentNode;
        super.endDocument(augs);
        this.endRange(node);
    }

    public void startDTD(XMLLocator locator, Augmentations augmentations) throws XNIException {
        super.startDTD(locator, augmentations);
        this.fOldLocator = this.fLocator;
        this.fLocator = locator;
    }

    public void externalEntityDecl(String name, XMLResourceIdentifier identifier, Augmentations augmentations) throws XNIException {
        super.externalEntityDecl(name, identifier, augmentations);
        if (!((AbstractDOMParser)this).fInDTDExternalSubset) {
            this.updateLastPosition();
        }
    }

    public void endDTD(Augmentations augmentations) throws XNIException {
        super.endDTD(augmentations);
        this.fLocator = this.fOldLocator;
    }

    public boolean canSetFeature(String name, boolean state) {
        if (name.equals("validate-against-dtd")) {
            return true;
        }
        return super.canSetFeature(name, state);
    }

    public void parse(XMLInputSource inputSource) throws XNIException, IOException {
        block9: {
            XEErrorHandler errorHandler = null;
            XMLErrorHandler handler = ((XMLParser)this).fConfiguration.getErrorHandler();
            if (handler instanceof XEErrorHandler) {
                errorHandler = (XEErrorHandler)handler;
            }
            if (errorHandler != null) {
                errorHandler.beginReporting();
            }
            try {
                try {
                    super.parse(inputSource);
                }
                catch (XNIException ex) {
                    this.recoverFromFatalError((Exception)((Object)ex));
                    throw ex;
                }
                catch (IOException ex) {
                    this.recoverFromFatalError(ex);
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (errorHandler != null) {
                    errorHandler.endReporting();
                }
                throw throwable;
            }
            Object var5_8 = null;
            if (errorHandler == null) break block9;
            errorHandler.endReporting();
        }
    }

    public String getRecoveredRawname() {
        return this.fRecoveredRawname;
    }

    public Map getRecoveredAttributes() {
        return this.fRecoveredAttributes;
    }

    public Set getIds() {
        return this.fIds;
    }
}

