/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.eclipse.pde.internal.core.plugin.IProblem;
import org.eclipse.pde.internal.core.plugin.IProblemRequestor;
import org.eclipse.pde.internal.core.plugin.SourceRange;
import org.eclipse.pde.internal.core.plugin.XEParseException;

public class XEErrorHandler
implements XMLErrorHandler {
    private IProblemRequestor fProblemRequestor;
    private static final int SEVERTITY_WARNING = 0;
    private static final int SEVERTITY_ERROR = 1;
    private static final int SEVERTITY_FATAL_ERROR = 2;
    private int errorCount;
    private int fatalErrorCount;
    private int warningCount;

    public XEErrorHandler(IProblemRequestor problemRequestor) {
        this.fProblemRequestor = problemRequestor;
    }

    public void beginReporting() {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.beginReporting();
        }
    }

    public void endReporting() {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.endReporting();
        }
    }

    protected IProblem createProblem(String domain, String key, XMLParseException exception, int severity) {
        int line = exception.getLineNumber();
        int column = exception.getColumnNumber();
        return new XMLProblem(key, exception.getMessage(), severity, line, column, line, column);
    }

    public void notifyProblemRequestor(String domain, String key, XMLParseException exception, int severity) {
        if (this.fProblemRequestor != null) {
            IProblem problem = this.createProblem(domain, key, exception, severity);
            this.fProblemRequestor.acceptProblem(problem);
        }
    }

    public void warning(String domain, String key, XMLParseException exception) throws XNIException {
        ++this.warningCount;
        this.notifyProblemRequestor(domain, key, exception, 0);
    }

    public void error(String domain, String key, XMLParseException exception) throws XNIException {
        ++this.errorCount;
        this.notifyProblemRequestor(domain, key, exception, 1);
    }

    public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
        ++this.fatalErrorCount;
        this.notifyProblemRequestor(domain, key, exception, 2);
        SimpleLocator locator = new SimpleLocator(null, null, exception.getLineNumber(), exception.getColumnNumber());
        throw new XEParseException((XMLLocator)locator, exception.getMessage(), key);
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getFatalErrorCount() {
        return this.fatalErrorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void reset() {
        this.errorCount = 0;
        this.fatalErrorCount = 0;
        this.warningCount = 0;
    }

    protected class XMLProblem
    extends SourceRange
    implements IProblem {
        private String fCode;
        private String fMessage;
        private int fSeverity;

        public XMLProblem(String code, String message, int severity, int startLine, int startColumn, int endLine, int endColumn) {
            super(startLine, startColumn, endLine, endColumn);
            this.fCode = code;
            this.fMessage = message;
            this.fSeverity = severity;
        }

        public String getCode() {
            return this.fCode;
        }

        public String getMessage() {
            return this.fMessage;
        }

        public boolean isError() {
            return this.fSeverity == 1 || this.fSeverity == 2;
        }

        public boolean isWarning() {
            return this.fSeverity == 0;
        }
    }
}

