/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.util.HashMap;
import java.util.Map;

public class TicketManager {
    private Map fTickets = new HashMap();
    private int fLatestUsedTicket = -1;
    private int fLatestNewTicket = 0;

    public synchronized void buyTicket() {
        this.fTickets.put(Thread.currentThread(), new Integer(++this.fLatestNewTicket));
    }

    public synchronized boolean tryUseTicket() {
        return this.tryUseTicket(Thread.currentThread());
    }

    public synchronized boolean tryUseTicket(Thread client) {
        Integer ticket;
        boolean result = this.isTicketValid(client);
        if (result && (ticket = this.removeTicket(client)) != null) {
            this.fLatestUsedTicket = ticket;
        }
        return result;
    }

    public synchronized boolean isTicketValid() {
        return this.isTicketValid(Thread.currentThread());
    }

    public synchronized boolean isTicketValid(Thread client) {
        Integer ticket = (Integer)this.fTickets.get(client);
        boolean result = ticket == null ? true : ticket == this.fLatestNewTicket;
        return result;
    }

    public synchronized Integer removeTicket() {
        return this.removeTicket(Thread.currentThread());
    }

    public synchronized Integer removeTicket(Thread client) {
        return (Integer)this.fTickets.remove(client);
    }

    public synchronized boolean isAllTicketsUsed() {
        return this.fLatestUsedTicket == this.fLatestNewTicket;
    }
}

