/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.internal.core.plugin.ISourceRange;

public class SourceRange
implements ISourceRange {
    private int fStartLine = -1;
    private int fStartColumn = -1;
    private int fEndLine = -1;
    private int fEndColumn = -1;

    public SourceRange() {
    }

    public SourceRange(int startLine, int startColumn, int endLine, int endColumn) {
        this.fStartLine = startLine;
        this.fStartColumn = startColumn;
        this.fEndLine = endLine;
        this.fEndColumn = endColumn;
    }

    public static int getOffset(IDocument document, int line, int column) throws BadLocationException {
        return document.getLineOffset(line - 1) + column - 1;
    }

    public int getStartOffset(IDocument document) throws BadLocationException {
        return SourceRange.getOffset(document, this.fStartLine, this.fStartColumn);
    }

    public int getEndOffset(IDocument document) throws BadLocationException {
        return SourceRange.getOffset(document, this.fEndLine, this.fEndColumn);
    }

    public int getEndColumn() {
        return this.fEndColumn;
    }

    public int getEndLine() {
        return this.fEndLine;
    }

    public int getStartColumn() {
        return this.fStartColumn;
    }

    public int getStartLine() {
        return this.fStartLine;
    }

    public void setEndColumn(int fEndColumn) {
        this.fEndColumn = fEndColumn;
    }

    public void setEndLine(int fEndLine) {
        this.fEndLine = fEndLine;
    }

    public void setStartColumn(int fStartColumn) {
        this.fStartColumn = fStartColumn;
    }

    public void setStartLine(int fStartLine) {
        this.fStartLine = fStartLine;
    }
}

