/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.plugin.ISourceRange;
import org.w3c.dom.Comment;
import org.w3c.dom.Node;

public abstract class PluginObject
extends PlatformObject
implements IPluginObject,
ISourceObject,
Serializable {
    protected String name;
    private String translatedName;
    private transient IPluginObject parent;
    private transient IPluginModelBase model;
    private Vector comments;
    protected int[] range;
    private boolean inTheModel;

    public boolean isValid() {
        return true;
    }

    protected void ensureModelEditable() throws CoreException {
        if (!this.model.isEditable()) {
            this.throwCoreException(PDECore.getResourceString("PluginObject.readOnlyChange"));
        }
    }

    void setInTheModel(boolean value) {
        this.inTheModel = value;
    }

    public boolean isInTheModel() {
        return this.inTheModel;
    }

    protected void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this.firePropertyChanged(this, property, oldValue, newValue);
    }

    protected void firePropertyChanged(IPluginObject object, String property, Object oldValue, Object newValue) {
        if (this.model.isEditable() && this.model instanceof IModelChangeProvider) {
            IModelChangeProvider provider = this.model;
            provider.fireModelObjectChanged(object, property, oldValue, newValue);
        }
    }

    protected void fireStructureChanged(IPluginObject child, int changeType) {
        IPluginModelBase model = this.getModel();
        if (model.isEditable() && model instanceof IModelChangeProvider) {
            ModelChangedEvent e = new ModelChangedEvent(changeType, new Object[]{child}, null);
            this.fireModelChanged(e);
        }
    }

    protected void fireModelChanged(IModelChangedEvent e) {
        IPluginModelBase model = this.getModel();
        if (model.isEditable() && model instanceof IModelChangeProvider) {
            IModelChangeProvider provider = model;
            provider.fireModelChanged(e);
        }
    }

    private String getAttribute(Node node, String name) {
        Node attribute = node.getAttributes().getNamedItem(name);
        if (attribute != null) {
            return attribute.getNodeValue();
        }
        return null;
    }

    public IPluginModelBase getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public String getTranslatedName() {
        if (this.translatedName != null && !this.model.isEditable()) {
            return this.translatedName;
        }
        if (this.translatedName == null && this.name != null && this.model != null) {
            this.translatedName = this.model.getResourceString(this.name);
        }
        return this.translatedName;
    }

    String getNodeAttribute(Node node, String name) {
        Node attribute = node.getAttributes().getNamedItem(name);
        if (attribute != null) {
            return attribute.getNodeValue();
        }
        return null;
    }

    public IPluginObject getParent() {
        return this.parent;
    }

    public IPluginBase getPluginBase() {
        return this.model != null ? this.model.getPluginBase() : null;
    }

    public String getResourceString(String key) {
        return this.model.getResourceString(key);
    }

    static boolean isNotEmpty(String text) {
        int i = 0;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    abstract void load(Node var1, Hashtable var2);

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("name")) {
            this.setName(newValue != null ? newValue.toString() : null);
        }
    }

    public void setModel(IPluginModelBase model) {
        this.model = model;
        this.translatedName = null;
    }

    public void setName(String name) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChanged("name", oldValue, name);
    }

    public void setParent(IPluginObject parent) {
        this.parent = parent;
    }

    protected void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, PDECore.getPluginId(), 0, message, null);
        CoreException ce = new CoreException((IStatus)status);
        ce.fillInStackTrace();
        throw ce;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    public void addComments(Node node) {
        this.comments = this.addComments(node, this.comments);
    }

    public Vector addComments(Node node, Vector result) {
        Node prev = node.getPreviousSibling();
        while (prev != null) {
            if (prev.getNodeType() != 3) {
                if (!(prev instanceof Comment)) break;
                String comment = prev.getNodeValue();
                if (result == null) {
                    result = new Vector<String>();
                }
                result.add(comment);
            }
            prev = prev.getPreviousSibling();
        }
        return result;
    }

    void writeComments(PrintWriter writer) {
        this.writeComments(writer, this.comments);
    }

    void writeComments(PrintWriter writer, Vector source) {
        if (source == null) {
            return;
        }
        int i = 0;
        while (i < source.size()) {
            String comment = (String)source.elementAt(i);
            writer.println("<!--" + comment + "-->");
            ++i;
        }
    }

    protected boolean stringEqualWithNull(String a, String b) {
        return a == null && b == null || a != null && b != null && a.equals(b);
    }

    public String getWritableString(String source) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    void bindSourceLocation(Node node, Map lineTable) {
        this.bindSourceLocationNew(node, lineTable);
    }

    private void bindSourceLocationNew(Node node, Map lineTable) {
        ISourceRange lines = (ISourceRange)lineTable.get(node);
        if (lines != null) {
            this.range = new int[2];
            this.range[0] = lines.getStartLine();
            this.range[1] = lines.getEndLine();
        }
    }

    private void bindSourceLocationOrig(Node node, Map lineTable) {
        Integer[] lines = (Integer[])lineTable.get(node);
        if (lines != null) {
            this.range = new int[2];
            this.range[0] = lines[0];
            this.range[1] = lines[1];
        }
    }

    public int getStartLine() {
        if (this.range == null) {
            return -1;
        }
        return this.range[0];
    }

    public int getStopLine() {
        if (this.range == null) {
            return -1;
        }
        return this.range[1];
    }

    public abstract void write(String var1, PrintWriter var2);
}

