/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.model.ConfigurationElementModel;
import org.eclipse.core.runtime.model.ExtensionModel;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.plugin.PluginElement;
import org.eclipse.pde.internal.core.plugin.PluginParent;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginExtension
extends PluginParent
implements IPluginExtension {
    private String point;
    private transient ISchema schema;

    public String getPoint() {
        return this.point;
    }

    public boolean isValid() {
        return this.point != null;
    }

    public ISchema getSchema() {
        if (this.schema == null) {
            SchemaRegistry registry = PDECore.getDefault().getSchemaRegistry();
            this.schema = registry.getSchema(this.point);
        } else if (this.schema.isDisposed()) {
            this.schema = null;
        }
        return this.schema;
    }

    void load(ExtensionModel extensionModel) {
        this.id = extensionModel.getId();
        this.name = extensionModel.getName();
        this.point = extensionModel.getExtensionPoint();
        ConfigurationElementModel[] childModels = extensionModel.getSubElements();
        if (childModels != null) {
            int i = 0;
            while (i < childModels.length) {
                ConfigurationElementModel childModel = childModels[i];
                PluginElement childElement = new PluginElement();
                childElement.setModel(this.getModel());
                childElement.setParent(this);
                this.children.add(childElement);
                childElement.load(childModel);
                ++i;
            }
        }
        int line = extensionModel.getStartLine();
        this.range = new int[]{line, line};
    }

    void load(Node node, Hashtable lineTable) {
        this.id = this.getNodeAttribute(node, "id");
        this.name = this.getNodeAttribute(node, "name");
        this.point = this.getNodeAttribute(node, "point");
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                PluginElement childElement = new PluginElement();
                childElement.setModel(this.getModel());
                childElement.setInTheModel(true);
                childElement.setParent(this);
                this.children.add(childElement);
                childElement.load(child, lineTable);
            }
            ++i;
        }
        this.addComments(node);
        this.bindSourceLocation(node, lineTable);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IPluginExtension) {
            IPluginExtension target = (IPluginExtension)obj;
            if (target.getModel().equals(this.getModel())) {
                return false;
            }
            if (!this.stringEqualWithNull(target.getId(), this.getId())) {
                return false;
            }
            if (!this.stringEqualWithNull(target.getName(), this.getName())) {
                return false;
            }
            if (!this.stringEqualWithNull(target.getPoint(), this.getPoint())) {
                return false;
            }
            return super.equals(obj);
        }
        return false;
    }

    public void setPoint(String point) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.point;
        this.point = point;
        this.firePropertyChanged("point", oldValue, point);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("point")) {
            this.setPoint(newValue != null ? newValue.toString() : null);
            return;
        }
        super.restoreProperty(name, oldValue, newValue);
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return this.getPoint();
    }

    public void write(String indent, PrintWriter writer) {
        this.writeComments(writer);
        writer.print(indent);
        writer.print("<extension");
        String attIndent = String.valueOf(indent) + "      ";
        if (this.getId() != null) {
            writer.println();
            writer.print(String.valueOf(attIndent) + "id=\"" + this.getId() + "\"");
        }
        if (this.getName() != null) {
            writer.println();
            writer.print(String.valueOf(attIndent) + "name=\"" + this.getWritableString(this.getName()) + "\"");
        }
        if (this.getPoint() != null) {
            writer.println();
            writer.print(String.valueOf(attIndent) + "point=\"" + this.getPoint() + "\"");
        }
        writer.println(">");
        IPluginObject[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            IPluginElement child = (IPluginElement)children[i];
            child.write(String.valueOf(indent) + "   ", writer);
            ++i;
        }
        writer.println(String.valueOf(indent) + "</extension>");
    }
}

