/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.model.ExtensionModel;
import org.eclipse.core.runtime.model.ExtensionPointModel;
import org.eclipse.core.runtime.model.LibraryModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.plugin.IdentifiablePluginObject;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.eclipse.pde.internal.core.plugin.PluginImport;
import org.eclipse.pde.internal.core.plugin.PluginLibrary;
import org.eclipse.pde.internal.core.plugin.PluginObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class PluginBase
extends IdentifiablePluginObject
implements IPluginBase {
    private Vector extensions = new Vector();
    private Vector extensionPoints = new Vector();
    private Vector libraries = new Vector();
    private Vector imports = new Vector();
    protected Vector requiresComments;
    private String providerName;
    private String version;
    private boolean valid;

    public void add(IPluginExtension extension) throws CoreException {
        this.ensureModelEditable();
        this.extensions.addElement(extension);
        ((PluginExtension)extension).setInTheModel(true);
        ((PluginExtension)extension).setParent(this);
        this.fireStructureChanged(extension, 1);
    }

    public void add(IPluginExtensionPoint extensionPoint) throws CoreException {
        this.ensureModelEditable();
        this.extensionPoints.addElement(extensionPoint);
        ((PluginExtensionPoint)extensionPoint).setInTheModel(true);
        ((PluginExtensionPoint)extensionPoint).setParent(this);
        this.fireStructureChanged(extensionPoint, 1);
    }

    public void add(IPluginLibrary library) throws CoreException {
        this.ensureModelEditable();
        this.libraries.addElement(library);
        ((PluginLibrary)library).setInTheModel(true);
        ((PluginLibrary)library).setParent(this);
        this.fireStructureChanged(library, 1);
    }

    public void add(IPluginImport iimport) throws CoreException {
        this.ensureModelEditable();
        ((PluginImport)iimport).setInTheModel(true);
        ((PluginImport)iimport).setParent(this);
        this.imports.addElement(iimport);
        this.fireStructureChanged(iimport, 1);
    }

    public IPluginExtensionPoint[] getExtensionPoints() {
        Object[] result = new IPluginExtensionPoint[this.extensionPoints.size()];
        this.extensionPoints.copyInto(result);
        return result;
    }

    public IPluginExtension[] getExtensions() {
        Object[] result = new IPluginExtension[this.extensions.size()];
        this.extensions.copyInto(result);
        return result;
    }

    public IPluginLibrary[] getLibraries() {
        Object[] result = new IPluginLibrary[this.libraries.size()];
        this.libraries.copyInto(result);
        return result;
    }

    public IPluginImport[] getImports() {
        Object[] result = new IPluginImport[this.imports.size()];
        this.imports.copyInto(result);
        return result;
    }

    public IPluginBase getPluginBase() {
        return this;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getVersion() {
        return this.version;
    }

    void load(PluginModel pd) {
        this.id = pd.getId();
        this.name = pd.getName();
        this.providerName = pd.getProviderName();
        this.version = pd.getVersion();
        this.loadRuntime(pd.getRuntime());
        this.loadExtensions(pd.getDeclaredExtensions());
        this.loadExtensionPoints(pd.getDeclaredExtensionPoints());
        this.loadImports(pd.getRequires());
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("version")) {
            this.setVersion(newValue != null ? newValue.toString() : null);
            return;
        }
        if (name.equals("provider")) {
            this.setProviderName(newValue != null ? newValue.toString() : null);
            return;
        }
        if (name.equals("library_order")) {
            this.swap((IPluginLibrary)oldValue, (IPluginLibrary)newValue);
            return;
        }
        super.restoreProperty(name, oldValue, newValue);
    }

    void load(PluginBase srcPluginBase) {
        this.range = srcPluginBase.range;
        this.id = srcPluginBase.id;
        this.name = srcPluginBase.name;
        this.providerName = srcPluginBase.providerName;
        this.version = srcPluginBase.version;
        this.addArrayToVector(this.extensions, srcPluginBase.getExtensions());
        this.addArrayToVector(this.extensionPoints, srcPluginBase.getExtensionPoints());
        this.addArrayToVector(this.imports, srcPluginBase.getImports());
        this.addArrayToVector(this.libraries, srcPluginBase.getLibraries());
        this.valid = this.hasRequiredAttributes();
    }

    private void addArrayToVector(Vector vector, Object[] array) {
        int i = 0;
        while (i < array.length) {
            Object obj = array[i];
            if (obj instanceof PluginObject) {
                ((PluginObject)obj).setParent(this);
            }
            vector.add(obj);
            ++i;
        }
    }

    void load(Node node, Hashtable lineTable) {
        this.bindSourceLocation(node, lineTable);
        this.id = this.getNodeAttribute(node, "id");
        this.name = this.getNodeAttribute(node, "name");
        this.providerName = this.getNodeAttribute(node, "provider-name");
        if (this.providerName == null) {
            this.providerName = this.getNodeAttribute(node, "vendor");
        }
        this.version = this.getNodeAttribute(node, "version");
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.processChild(child, lineTable);
            }
            ++i;
        }
        this.valid = this.hasRequiredAttributes();
    }

    void loadExtensionPoints(ExtensionPointModel[] extensionPointModels) {
        if (extensionPointModels == null) {
            return;
        }
        int i = 0;
        while (i < extensionPointModels.length) {
            ExtensionPointModel extensionPointModel = extensionPointModels[i];
            PluginModel parent = extensionPointModel.getParent();
            if (!(parent instanceof PluginFragmentModel)) {
                PluginExtensionPoint extensionPoint = new PluginExtensionPoint();
                extensionPoint.setModel(this.getModel());
                extensionPoint.setInTheModel(true);
                extensionPoint.setParent(this);
                this.extensionPoints.add(extensionPoint);
                extensionPoint.load(extensionPointModel);
            }
            ++i;
        }
    }

    void loadExtensions(ExtensionModel[] extensionModels) {
        if (extensionModels == null) {
            return;
        }
        int i = 0;
        while (i < extensionModels.length) {
            ExtensionModel extensionModel = extensionModels[i];
            PluginModel parent = extensionModel.getParent();
            if (!(parent instanceof PluginFragmentModel)) {
                PluginExtension extension = new PluginExtension();
                extension.setModel(this.getModel());
                extension.setInTheModel(true);
                extension.setParent(this);
                this.extensions.add(extension);
                extension.load(extensionModel);
            }
            ++i;
        }
    }

    void loadRuntime(LibraryModel[] libraryModels) {
        if (libraryModels == null) {
            return;
        }
        int i = 0;
        while (i < libraryModels.length) {
            PluginLibrary library = new PluginLibrary();
            library.setModel(this.getModel());
            library.setInTheModel(true);
            library.setParent(this);
            this.libraries.add(library);
            library.load(libraryModels[i]);
            ++i;
        }
    }

    void loadRuntime(Node node, Hashtable lineTable) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().toLowerCase().equals("library")) {
                PluginLibrary library = new PluginLibrary();
                library.setModel(this.getModel());
                library.setInTheModel(true);
                library.setParent(this);
                this.libraries.add(library);
                library.load(child, lineTable);
            }
            ++i;
        }
    }

    void loadImports(PluginPrerequisiteModel[] importModels) {
        if (importModels == null) {
            return;
        }
        int i = 0;
        while (i < importModels.length) {
            PluginPrerequisiteModel importModel = importModels[i];
            PluginImport importElement = new PluginImport();
            importElement.setModel(this.getModel());
            importElement.setInTheModel(true);
            importElement.setParent(this);
            this.imports.add(importElement);
            importElement.load(importModel);
            ++i;
        }
    }

    void loadImports(Node node, Hashtable lineTable) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().toLowerCase().equals("import")) {
                PluginImport importElement = new PluginImport();
                importElement.setModel(this.getModel());
                importElement.setInTheModel(true);
                importElement.setParent(this);
                this.imports.add(importElement);
                importElement.load(child, lineTable);
            }
            ++i;
        }
    }

    protected void processChild(Node child, Hashtable lineTable) {
        String name = child.getNodeName().toLowerCase();
        if (name.equals("extension")) {
            PluginExtension extension = new PluginExtension();
            extension.setModel(this.getModel());
            extension.setParent(this);
            this.extensions.add(extension);
            extension.setInTheModel(true);
            extension.load(child, lineTable);
        } else if (name.equals("extension-point")) {
            PluginExtensionPoint point = new PluginExtensionPoint();
            point.setModel(this.getModel());
            point.setParent(this);
            point.setInTheModel(true);
            this.extensionPoints.add(point);
            point.load(child, lineTable);
        } else if (name.equals("runtime")) {
            this.loadRuntime(child, lineTable);
            this.addComments(child);
        } else if (name.equals("requires")) {
            this.loadImports(child, lineTable);
            this.requiresComments = this.addComments(child, this.requiresComments);
        }
    }

    public void remove(IPluginExtension extension) throws CoreException {
        this.ensureModelEditable();
        this.extensions.removeElement(extension);
        ((PluginExtension)extension).setInTheModel(false);
        this.fireStructureChanged(extension, 2);
    }

    public void remove(IPluginExtensionPoint extensionPoint) throws CoreException {
        this.ensureModelEditable();
        this.extensionPoints.removeElement(extensionPoint);
        ((PluginExtensionPoint)extensionPoint).setInTheModel(false);
        this.fireStructureChanged(extensionPoint, 2);
    }

    public void remove(IPluginLibrary library) throws CoreException {
        this.ensureModelEditable();
        this.libraries.removeElement(library);
        ((PluginLibrary)library).setInTheModel(false);
        this.fireStructureChanged(library, 2);
    }

    public void remove(IPluginImport iimport) throws CoreException {
        this.ensureModelEditable();
        this.imports.removeElement(iimport);
        ((PluginImport)iimport).setInTheModel(false);
        this.fireStructureChanged(iimport, 2);
    }

    public void reset() {
        this.extensions = new Vector();
        this.extensionPoints = new Vector();
        this.libraries = new Vector();
        this.imports = new Vector();
        this.requiresComments = null;
        this.providerName = null;
        this.version = "";
        this.name = "";
        this.id = "";
        if (this.getModel() != null && this.getModel().getUnderlyingResource() != null) {
            this.name = this.id = this.getModel().getUnderlyingResource().getProject().getName();
            this.version = "0.0.0";
        }
        this.valid = false;
    }

    public void setProviderName(String providerName) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.providerName;
        this.providerName = providerName;
        this.firePropertyChanged("provider", oldValue, providerName);
    }

    public void setVersion(String newVersion) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.version;
        this.version = newVersion;
        this.firePropertyChanged("version", oldValue, this.version);
    }

    public void internalSetVersion(String newVersion) {
        this.version = newVersion;
    }

    public void swap(IPluginLibrary l1, IPluginLibrary l2) throws CoreException {
        this.ensureModelEditable();
        int index1 = this.libraries.indexOf(l1);
        int index2 = this.libraries.indexOf(l2);
        if (index1 == -1 || index2 == -1) {
            this.throwCoreException("Libraries not in the model");
        }
        this.libraries.setElementAt(l1, index2);
        this.libraries.setElementAt(l2, index1);
        this.firePropertyChanged(this, "library_order", l1, l2);
    }

    public int getExtensionCount() {
        return this.extensions.size();
    }

    public int getIndexOf(IPluginExtension e) {
        return this.extensions.indexOf(e);
    }

    public void swap(IPluginExtension e1, IPluginExtension e2) throws CoreException {
        this.ensureModelEditable();
        int index1 = this.extensions.indexOf(e1);
        int index2 = this.extensions.indexOf(e2);
        if (index1 == -1 || index2 == -1) {
            this.throwCoreException("Extensions not in the model");
        }
        this.extensions.setElementAt(e1, index2);
        this.extensions.setElementAt(e2, index1);
        this.firePropertyChanged(this, "extension_order", e1, e2);
    }

    void writeChildren(String indent, String tag, Object[] children, PrintWriter writer) {
        if (tag.equals("runtime")) {
            this.writeComments(writer);
        }
        writer.println(String.valueOf(indent) + "<" + tag + ">");
        int i = 0;
        while (i < children.length) {
            IPluginObject obj = (IPluginObject)children[i];
            obj.write(String.valueOf(indent) + "   ", writer);
            ++i;
        }
        writer.println(String.valueOf(indent) + "</" + tag + ">");
    }

    public boolean isValid() {
        return this.valid;
    }

    protected boolean hasRequiredAttributes() {
        if (this.name == null) {
            return false;
        }
        if (this.id == null) {
            return false;
        }
        if (this.version == null) {
            return false;
        }
        int i = 0;
        while (i < this.libraries.size()) {
            IPluginLibrary library = (IPluginLibrary)this.libraries.get(i);
            if (!library.isValid()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.imports.size()) {
            IPluginImport iimport = (IPluginImport)this.imports.get(i);
            if (!iimport.isValid()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.extensions.size()) {
            IPluginExtension extension = (IPluginExtension)this.extensions.get(i);
            if (!extension.isValid()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.extensionPoints.size()) {
            IPluginExtensionPoint expoint = (IPluginExtensionPoint)this.extensionPoints.get(i);
            if (!expoint.isValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

