/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.PrintWriter;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IMatchRules;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.w3c.dom.Node;

public class Fragment
extends PluginBase
implements IFragment {
    private String pluginId = "";
    private String pluginVersion = "";
    private int rule = 0;

    public String getPluginId() {
        return this.pluginId;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public int getRule() {
        return this.rule;
    }

    protected boolean hasRequiredAttributes() {
        if (this.pluginId == null || this.pluginVersion == null) {
            return false;
        }
        return super.hasRequiredAttributes();
    }

    void load(PluginModel pm) {
        PluginFragmentModel pfm = (PluginFragmentModel)pm;
        this.pluginId = pfm.getPluginId();
        this.pluginVersion = pfm.getPluginVersion();
        switch (pfm.getMatch()) {
            case 3: {
                this.rule = 2;
                break;
            }
            case 2: {
                this.rule = 1;
                break;
            }
            case 1: {
                this.rule = 3;
                break;
            }
            case 4: {
                this.rule = 4;
            }
        }
        super.load(pm);
    }

    void load(PluginBase srcPluginBase) {
        this.pluginId = ((Fragment)srcPluginBase).pluginId;
        this.pluginVersion = ((Fragment)srcPluginBase).pluginVersion;
        this.rule = ((Fragment)srcPluginBase).rule;
        super.load(srcPluginBase);
    }

    void load(Node node, Hashtable lineTable) {
        this.pluginId = this.getNodeAttribute(node, "plugin-id");
        this.pluginVersion = this.getNodeAttribute(node, "plugin-version");
        String match = this.getNodeAttribute(node, "match");
        if (match != null) {
            String[] table = IMatchRules.RULE_NAME_TABLE;
            int i = 0;
            while (i < table.length) {
                if (match.equalsIgnoreCase(table[i])) {
                    this.rule = i;
                    break;
                }
                ++i;
            }
        }
        super.load(node, lineTable);
    }

    public void reset() {
        this.pluginId = "";
        this.pluginVersion = "";
        this.rule = 0;
        super.reset();
    }

    public void setPluginId(String newPluginId) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.pluginId;
        this.pluginId = newPluginId;
        this.firePropertyChanged("plugin-id", oldValue, this.pluginId);
    }

    public void setPluginVersion(String newPluginVersion) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.pluginVersion;
        this.pluginVersion = newPluginVersion;
        this.firePropertyChanged("plugin-version", oldValue, this.pluginVersion);
    }

    public void setRule(int rule) throws CoreException {
        this.ensureModelEditable();
        Integer oldValue = new Integer(this.rule);
        this.rule = rule;
        this.firePropertyChanged("rule", oldValue, new Integer(rule));
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("plugin-id")) {
            this.setPluginId(newValue != null ? newValue.toString() : null);
            return;
        }
        if (name.equals("plugin-version")) {
            this.setPluginVersion(newValue != null ? newValue.toString() : null);
            return;
        }
        if (name.equals("rule")) {
            this.setRule((Integer)newValue);
            return;
        }
        super.restoreProperty(name, oldValue, newValue);
    }

    public void write(String indent, PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.print("<fragment");
        if (this.getId() != null) {
            writer.println();
            writer.print("   id=\"" + this.getId() + "\"");
        }
        if (this.getName() != null) {
            writer.println();
            writer.print("   name=\"" + this.getWritableString(this.getName()) + "\"");
        }
        if (this.getVersion() != null) {
            writer.println();
            writer.print("   version=\"" + this.getVersion() + "\"");
        }
        if (this.getProviderName() != null) {
            writer.println();
            writer.print("   provider-name=\"" + this.getWritableString(this.getProviderName()) + "\"");
        }
        if (this.getPluginId() != null) {
            writer.println();
            writer.print("   plugin-id=\"" + this.getPluginId() + "\"");
        }
        if (this.getPluginVersion() != null) {
            writer.println();
            writer.print("   plugin-version=\"" + this.getPluginVersion() + "\"");
        }
        if (this.getRule() != 0) {
            writer.println();
            writer.print("   match=\"" + IMatchRules.RULE_NAME_TABLE[this.getRule()] + "\"");
        }
        writer.println(">");
        writer.println();
        String firstIndent = "   ";
        Object[] children = this.getLibraries();
        this.writeChildren(firstIndent, "runtime", children, writer);
        writer.println();
        children = this.getImports();
        if (children.length > 0) {
            this.writeComments(writer, this.requiresComments);
            this.writeChildren(firstIndent, "requires", children, writer);
            writer.println();
        }
        children = this.getExtensionPoints();
        int i = 0;
        while (i < children.length) {
            ((IPluginExtensionPoint)children[i]).write(firstIndent, writer);
            ++i;
        }
        writer.println();
        children = this.getExtensions();
        i = 0;
        while (i < children.length) {
            ((IPluginExtension)children[i]).write(firstIndent, writer);
            ++i;
        }
        writer.println("</fragment>");
    }
}

