/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceDOMParser;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.XMLErrorHandler;
import org.eclipse.pde.internal.core.plugin.DocumentModel;
import org.eclipse.pde.internal.core.plugin.PluginAttribute;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.eclipse.pde.internal.core.plugin.PluginElement;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.eclipse.pde.internal.core.plugin.PluginImport;
import org.eclipse.pde.internal.core.plugin.PluginLibrary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractPluginModelBase
extends AbstractModel
implements IPluginModelBase,
IPluginModelFactory {
    protected PluginBase pluginBase;
    private boolean enabled;
    private static transient SourceDOMParser parser;
    private static transient XMLErrorHandler errorHandler;
    private DocumentModel documentModel;

    public abstract IPluginBase createPluginBase();

    public IPluginModelFactory getFactory() {
        return this;
    }

    public DocumentModel getDocumentModel() {
        if (this.documentModel == null) {
            this.documentModel = new DocumentModel(this);
        }
        return this.documentModel;
    }

    public IPluginBase getPluginBase() {
        return this.getPluginBase(true);
    }

    public IPluginBase getPluginBase(boolean createIfMissing) {
        if (this.pluginBase == null && createIfMissing) {
            this.pluginBase = (PluginBase)this.createPluginBase();
            this.loaded = true;
        }
        return this.pluginBase;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isFragmentModel() {
        return false;
    }

    public abstract URL getNLLookupLocation();

    protected URL[] getNLLookupLocations() {
        if (this.isFragmentModel()) {
            return new URL[]{this.getNLLookupLocation()};
        }
        URL[] fragmentLocations = this.getFragmentLocations();
        URL[] locations = new URL[1 + fragmentLocations.length];
        locations[0] = this.getNLLookupLocation();
        int i = 1;
        while (i < locations.length) {
            locations[i] = fragmentLocations[i - 1];
            ++i;
        }
        return locations;
    }

    protected URL[] getFragmentLocations() {
        Vector result = new Vector();
        if (this.pluginBase != null) {
            String id = this.pluginBase.getId();
            String version = this.pluginBase.getVersion();
            ExternalModelManager emng = PDECore.getDefault().getExternalModelManager();
            if (emng.hasEnabledModels()) {
                IFragmentModel[] models = emng.getFragmentModels();
                this.addMatchingFragments(id, version, models, result);
            }
            WorkspaceModelManager wmng = PDECore.getDefault().getWorkspaceModelManager();
            IFragmentModel[] models = wmng.getWorkspaceFragmentModels();
            this.addMatchingFragments(id, version, models, result);
        }
        Object[] locations = new URL[result.size()];
        result.copyInto(locations);
        return locations;
    }

    private void addMatchingFragments(String id, String version, IFragmentModel[] models, Vector result) {
        int i = 0;
        while (i < models.length) {
            int refmatch;
            String refversion;
            IFragment fragment;
            String refid;
            IFragmentModel model = models[i];
            if (model.isEnabled() && PDECore.compare(refid = (fragment = model.getFragment()).getPluginId(), refversion = fragment.getPluginVersion(), id, version, refmatch = fragment.getRule())) {
                URL location = ((AbstractPluginModelBase)((Object)model)).getNLLookupLocation();
                result.add(location);
                IPluginLibrary[] libraries = fragment.getLibraries();
                int j = 0;
                while (j < libraries.length) {
                    IPluginLibrary library = libraries[j];
                    try {
                        URL libLocation = new URL(location, library.getName());
                        result.add(libLocation);
                    }
                    catch (MalformedURLException malformedURLException) {}
                    ++j;
                }
            }
            ++i;
        }
    }

    private static void initializeParser() {
        parser = new SourceDOMParser();
        errorHandler = new XMLErrorHandler();
        parser.setErrorHandler(errorHandler);
    }

    public synchronized void load(InputStream stream, boolean outOfSync) throws CoreException {
        this.getDocumentModel().load(stream, outOfSync);
    }

    private synchronized void loadOrig(InputStream stream, boolean outOfSync) throws CoreException {
        if (this.pluginBase == null) {
            this.pluginBase = (PluginBase)this.createPluginBase();
            this.pluginBase.setModel(this);
        }
        this.pluginBase.reset();
        this.loaded = false;
        try {
            InputSource source = new InputSource(stream);
            errorHandler.reset();
            parser.parse(source);
            if (errorHandler.getErrorCount() > 0 || errorHandler.getFatalErrorCount() > 0) {
                this.throwParseErrorsException();
            }
            this.processDocument(parser.getDocument(), parser.getLineTable());
            this.loaded = true;
            if (!outOfSync) {
                this.updateTimeStamp();
            }
        }
        catch (SAXException sAXException) {
            this.throwParseErrorsException();
        }
        catch (IOException iOException) {
            this.throwParseErrorsException();
        }
    }

    private void processDocument(Document doc, Hashtable lineTable) {
        Element pluginNode = doc.getDocumentElement();
        this.pluginBase.load(pluginNode, lineTable);
    }

    public void reload(InputStream stream, boolean outOfSync) throws CoreException {
        this.getDocumentModel().reload(stream, outOfSync);
    }

    private void reloadOrig(InputStream stream, boolean outOfSync) throws CoreException {
        this.load(stream, outOfSync);
        this.fireModelChanged(new ModelChangedEvent(99, new Object[]{this.pluginBase}, null));
    }

    public void setEnabled(boolean newEnabled) {
        this.enabled = newEnabled;
    }

    public String toString() {
        IPluginBase pluginBase = this.getPluginBase();
        if (pluginBase != null) {
            return pluginBase.getTranslatedName();
        }
        return super.toString();
    }

    protected abstract void updateTimeStamp();

    public IPluginAttribute createAttribute(IPluginElement element) {
        PluginAttribute attribute = new PluginAttribute();
        attribute.setModel(this);
        attribute.setParent(element);
        return attribute;
    }

    public IPluginElement createElement(IPluginObject parent) {
        PluginElement element = new PluginElement();
        element.setModel(this);
        element.setParent(parent);
        return element;
    }

    public IPluginExtension createExtension() {
        PluginExtension extension = new PluginExtension();
        extension.setParent(this.getPluginBase());
        extension.setModel(this);
        return extension;
    }

    public IPluginExtensionPoint createExtensionPoint() {
        PluginExtensionPoint extensionPoint = new PluginExtensionPoint();
        extensionPoint.setModel(this);
        extensionPoint.setParent(this.getPluginBase());
        return extensionPoint;
    }

    public IPluginImport createImport() {
        PluginImport iimport = new PluginImport();
        iimport.setModel(this);
        iimport.setParent(this.getPluginBase());
        return iimport;
    }

    public IPluginLibrary createLibrary() {
        PluginLibrary library = new PluginLibrary();
        library.setModel(this);
        library.setParent(this.getPluginBase());
        return library;
    }

    public boolean isValid() {
        if (!this.isLoaded()) {
            return false;
        }
        if (this.pluginBase == null) {
            return false;
        }
        return this.pluginBase.isValid();
    }

    public abstract IBuildModel getBuildModel();

    public abstract String getInstallLocation();
}

