/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.FeatureData;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.w3c.dom.Node;

public class FeaturePlugin
extends FeatureData
implements IFeaturePlugin {
    private IPluginBase pluginBase;
    private boolean fragment;
    private String version;

    protected void reset() {
        super.reset();
        this.version = null;
        this.fragment = false;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public IPluginBase getPluginBase() {
        return this.pluginBase;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.version;
        this.version = version;
        this.firePropertyChanged(this, "version", oldValue, version);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("version")) {
            this.setVersion(newValue != null ? newValue.toString() : null);
        } else {
            super.restoreProperty(name, oldValue, newValue);
        }
    }

    public void setFragment(boolean fragment) throws CoreException {
        this.ensureModelEditable();
        this.fragment = fragment;
    }

    protected void parse(Node node, Hashtable lineTable) {
        super.parse(node, lineTable);
        this.version = this.getNodeAttribute(node, "version");
        String f = this.getNodeAttribute(node, "fragment");
        if (f != null && f.equalsIgnoreCase("true")) {
            this.fragment = true;
        }
        if (this.id != null && this.version != null) {
            this.hookWithWorkspace();
        }
    }

    public void hookWithWorkspace() {
        if (this.fragment) {
            IFragmentModel[] fragments = PDECore.getDefault().getWorkspaceModelManager().getWorkspaceFragmentModels();
            int i = 0;
            while (i < fragments.length) {
                IFragment fragment = fragments[i].getFragment();
                if (fragment.getId().equals(this.id) && (this.version == null || fragment.getVersion().equals(this.version))) {
                    this.pluginBase = fragment;
                    break;
                }
                ++i;
            }
        } else {
            this.pluginBase = PDECore.getDefault().findPlugin(this.id, this.version, 0);
        }
    }

    public void loadFrom(IPluginBase plugin) {
        this.id = plugin.getId();
        this.label = plugin.getTranslatedName();
        this.version = plugin.getVersion();
        this.fragment = plugin instanceof IFragment;
        this.pluginBase = plugin;
    }

    public void write(String indent, PrintWriter writer) {
        writer.print(String.valueOf(indent) + "<plugin");
        String indent2 = String.valueOf(indent) + "   " + "   ";
        this.writeAttributes(indent2, writer);
        if (this.getVersion() != null) {
            writer.println();
            writer.print(String.valueOf(indent2) + "version=\"" + this.getVersion() + "\"");
        }
        if (this.isFragment()) {
            writer.println();
            writer.print(String.valueOf(indent2) + "fragment=\"true\"");
        }
        writer.println("/>");
    }

    public String getLabel() {
        if (this.pluginBase != null) {
            return this.pluginBase.getTranslatedName();
        }
        String name = super.getLabel();
        if (name == null) {
            name = this.getId();
        }
        return name;
    }

    public String toString() {
        return this.getLabel();
    }
}

