/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.w3c.dom.Node;

public abstract class FeatureObject
extends PlatformObject
implements IFeatureObject,
ISourceObject {
    transient IFeatureModel model;
    transient IFeatureObject parent;
    protected String label;
    boolean inTheModel;
    protected int[] range;

    void setInTheModel(boolean value) {
        this.inTheModel = value;
    }

    public boolean isInTheModel() {
        return this.inTheModel;
    }

    protected void ensureModelEditable() throws CoreException {
        if (!this.model.isEditable()) {
            this.throwCoreException(PDECore.getResourceString("FeatureObject.readOnlyChange"));
        }
    }

    protected void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this.firePropertyChanged(this, property, oldValue, newValue);
    }

    protected void firePropertyChanged(IFeatureObject object, String property, Object oldValue, Object newValue) {
        if (this.model.isEditable() && this.model instanceof IModelChangeProvider) {
            IModelChangeProvider provider = this.model;
            provider.fireModelObjectChanged(object, property, oldValue, newValue);
        }
    }

    protected void fireStructureChanged(IFeatureObject child, int changeType) {
        this.fireStructureChanged(new IFeatureObject[]{child}, changeType);
    }

    protected void fireStructureChanged(IFeatureObject[] children, int changeType) {
        IFeatureModel model = this.getModel();
        if (model.isEditable() && model instanceof IModelChangeProvider) {
            IModelChangeProvider provider = model;
            provider.fireModelChanged(new ModelChangedEvent(changeType, children, null));
        }
    }

    public IFeature getFeature() {
        return this.model.getFeature();
    }

    public String getLabel() {
        return this.label;
    }

    public String getTranslatableLabel() {
        if (this.label == null) {
            return "";
        }
        return this.model.getResourceString(this.label);
    }

    public IFeatureModel getModel() {
        return this.model;
    }

    String getNodeAttribute(Node node, String name) {
        Node attribute = node.getAttributes().getNamedItem(name);
        if (attribute != null) {
            return attribute.getNodeValue();
        }
        return null;
    }

    int getIntegerAttribute(Node node, String name) {
        String value = this.getNodeAttribute(node, name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    boolean getBooleanAttribute(Node node, String name) {
        String value = this.getNodeAttribute(node, name);
        if (value != null) {
            return value.equalsIgnoreCase("true");
        }
        return false;
    }

    protected String getNormalizedText(String source) {
        String result = source.replace('\t', ' ');
        result = result.trim();
        return result;
    }

    public IFeatureObject getParent() {
        return this.parent;
    }

    protected void parse(Node node, Hashtable lineTable) {
        this.label = this.getNodeAttribute(node, "label");
    }

    protected void reset() {
        this.label = null;
    }

    public void setLabel(String newLabel) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.label;
        this.label = newLabel;
        this.firePropertyChanged("label", oldValue, newLabel);
    }

    protected void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, PDECore.getPluginId(), 0, message, null);
        CoreException ce = new CoreException((IStatus)status);
        ce.fillInStackTrace();
        throw ce;
    }

    public static String getWritableString(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("label")) {
            this.setLabel(newValue != null ? newValue.toString() : null);
        }
    }

    public void write(String indent, PrintWriter writer) {
    }

    public void setModel(IFeatureModel model) {
        this.model = model;
    }

    public void setParent(IFeatureObject parent) {
        this.parent = parent;
    }

    void bindSourceLocation(Node node, Map lineTable) {
        Integer[] lines = (Integer[])lineTable.get(node);
        if (lines != null) {
            this.range = new int[2];
            this.range[0] = lines[0];
            this.range[1] = lines[1];
        }
    }

    public int getStartLine() {
        if (this.range == null) {
            return -1;
        }
        return this.range[0];
    }

    public int getStopLine() {
        if (this.range == null) {
            return -1;
        }
        return this.range[1];
    }
}

