/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.build;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.build.IBuildModelFactory;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.Build;
import org.eclipse.pde.internal.core.build.BuildModelFactory;

public abstract class BuildModel
extends AbstractModel
implements IBuildModel {
    protected Build build;
    private BuildModelFactory factory;
    public boolean fragment;

    public IBuild getBuild() {
        if (!this.isLoaded()) {
            this.load();
        }
        return this.build;
    }

    public IBuild getBuild(boolean createIfMissing) {
        if (this.build == null && createIfMissing) {
            this.build = new Build();
            this.build.setModel(this);
            this.loaded = true;
        }
        return this.getBuild();
    }

    public IBuildModelFactory getFactory() {
        if (this.factory == null) {
            this.factory = new BuildModelFactory(this);
        }
        return this.factory;
    }

    public String getInstallLocation() {
        return null;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public abstract void load();

    public void load(InputStream source, boolean outOfSync) {
        Properties properties = new Properties();
        try {
            properties.load(source);
            if (!outOfSync) {
                this.updateTimeStamp();
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
            return;
        }
        this.build = new Build();
        this.build.setModel(this);
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            this.build.processEntry(name, (String)((Hashtable)properties).get(name));
        }
        this.loaded = true;
    }

    public void reload(InputStream source, boolean outOfSync) {
        if (this.build != null) {
            this.build.reset();
        } else {
            this.build = new Build();
            this.build.setModel(this);
        }
        this.load(source, outOfSync);
        this.fireModelChanged(new ModelChangedEvent(99, new Object[0], null));
    }

    public void setFragment(boolean value) {
        this.fragment = value;
    }
}

