/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.build;

import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.build.BuildObject;

public class BuildEntry
extends BuildObject
implements IBuildEntry {
    private Vector tokens = new Vector();
    private String name;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public BuildEntry(String name) {
        this.name = name;
    }

    public void addToken(String token) throws CoreException {
        this.ensureModelEditable();
        this.tokens.add(token);
        this.getModel().fireModelChanged(new ModelChangedEvent(1, new Object[]{token}, null));
    }

    public String getName() {
        return this.name;
    }

    public String[] getTokens() {
        Object[] result = new String[this.tokens.size()];
        this.tokens.copyInto(result);
        return result;
    }

    public boolean contains(String token) {
        return this.tokens.contains(token);
    }

    void processEntry(String value) {
        StringTokenizer stok = new StringTokenizer(value, ",");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            token = token.trim();
            this.tokens.add(token);
        }
    }

    public void removeToken(String token) throws CoreException {
        this.ensureModelEditable();
        this.tokens.remove(token);
        this.getModel().fireModelChanged(new ModelChangedEvent(2, new Object[]{token}, null));
    }

    public void renameToken(String oldName, String newName) throws CoreException {
        this.ensureModelEditable();
        int i = 0;
        while (i < this.tokens.size()) {
            if (this.tokens.elementAt(i).toString().equals(oldName)) {
                this.tokens.setElementAt(newName, i);
                break;
            }
            ++i;
        }
        this.getModel().fireModelChanged(new ModelChangedEvent(3, new Object[]{oldName}, null));
    }

    public void setName(String name) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.name;
        this.name = name;
        this.getModel().fireModelObjectChanged(this, "name", oldValue, name);
    }

    public String toString() {
        return this.name;
    }

    private String createWritableName(String source) {
        if (source.indexOf(32) == -1) {
            return source;
        }
        StringBuffer writableName = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (c == ' ') {
                writableName.append("\\ ");
            } else {
                writableName.append(c);
            }
            ++i;
        }
        return writableName.toString();
    }

    private String createEscapedValue(String value) {
        StringBuffer buf = new StringBuffer(value.length() * 2);
        int i = 0;
        while (i < value.length()) {
            char character = value.charAt(i);
            if (character == '\\' || character == '\t' || character == '\r' || character == '\n' || character == '\f') {
                buf.append('\\');
                buf.append(character);
            } else if (character < ' ' || character > '~') {
                buf.append('\\');
                buf.append('u');
                buf.append(HEX[character >> 12 & 0xF]);
                buf.append(HEX[character >> 8 & 0xF]);
                buf.append(HEX[character >> 4 & 0xF]);
                buf.append(HEX[character & 0xF]);
            } else {
                buf.append(character);
            }
            ++i;
        }
        return buf.toString();
    }

    public void write(String indent, PrintWriter writer) {
        String writableName = this.createWritableName(this.name);
        writer.print(String.valueOf(writableName) + " = ");
        if (this.tokens.size() == 0) {
            writer.println();
            return;
        }
        int indentLength = this.name.length() + 3;
        int i = 0;
        while (i < this.tokens.size()) {
            String token = this.tokens.elementAt(i).toString();
            writer.print(this.createEscapedValue(token));
            if (i < this.tokens.size() - 1) {
                writer.println(",\\");
                int j = 0;
                while (j < indentLength) {
                    writer.print(" ");
                    ++j;
                }
            } else {
                writer.println("");
            }
            ++i;
        }
    }
}

