/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;

public class WorkspaceResourceHelper
extends NLResourceHelper
implements IResourceChangeListener {
    private IFile file;
    private IModelChangeProvider changeProvider;

    public WorkspaceResourceHelper(String name, URL[] locations) {
        super(name, locations);
        PDECore.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        PDECore.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void setFile(IFile file) {
        this.file = file;
    }

    public IFile getFile() {
        return this.file;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        return WorkspaceResourceHelper.this.visit(delta);
                    }
                });
            }
        }
        catch (CoreException coreException) {}
    }

    private boolean visit(IResourceDelta delta) {
        return true;
    }

    public void setModelChangeProvider(IModelChangeProvider changeProvider) {
        this.changeProvider = changeProvider;
    }
}

