/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.BinaryRepositoryProvider;
import org.eclipse.pde.internal.core.IModelProvider;
import org.eclipse.pde.internal.core.IModelProviderListener;
import org.eclipse.pde.internal.core.ModelProviderEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.plugin.WorkspaceFragmentModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteBuildModel;
import org.eclipse.pde.internal.core.site.WorkspaceSiteModel;
import org.eclipse.team.core.RepositoryProvider;

public class WorkspaceModelManager
implements IModelProvider,
IResourceChangeListener,
IResourceDeltaVisitor {
    private static final String KEY_MISSING_NATURE_TITLE = "MissingPDENature.title";
    private static final String KEY_MISSING_NATURE_MESSAGE = "MissingPDENature.message";
    private Hashtable models = new Hashtable();
    private Vector listeners = new Vector();
    private Vector workspaceModels = null;
    private Vector workspaceFragmentModels = null;
    private Vector workspaceFeatureModels = null;
    private Vector modelChanges = null;
    private boolean startup = true;
    private static final boolean DEBUG = false;
    private boolean initialized;

    public void addModelProviderListener(IModelProviderListener listener) {
        this.listeners.add(listener);
    }

    private void addWorkspaceModel(IModel model) {
        if (this.workspaceModels == null) {
            this.initializeWorkspacePluginModels();
        }
        if (model instanceof IFragmentModel) {
            this.workspaceFragmentModels.add(model);
        } else if (model instanceof IFeatureModel) {
            this.workspaceFeatureModels.add(model);
        } else {
            this.workspaceModels.add(model);
        }
        PDECore.getDefault().getTracingOptionsManager().reset();
        if (this.modelChanges != null) {
            this.modelChanges.add(new ModelChange(model, true));
        }
    }

    private void checkTracing(IFile file) {
        if (file.getName().equals(".options")) {
            PDECore.getDefault().getTracingOptionsManager().reset();
        }
    }

    public void connect(Object element, Object consumer) {
        this.connect(element, consumer, true);
    }

    public void connect(Object element, Object consumer, boolean editable) {
        ModelInfo info = (ModelInfo)this.models.get(element);
        if (info == null) {
            info = new ModelInfo();
            info.count = 0;
            this.models.put(element, info);
        }
        ++info.count;
        if (info.model != null && info.consumer != null && info.consumer != consumer) {
            this.verifyConsumer(info);
        }
        if (info.model == null && editable) {
            info.model = this.createModel(element);
            info.consumer = consumer;
        } else {
            info.readOnlyModel = this.createModel(element, false);
        }
    }

    protected IModel createModel(Object element) {
        return this.createModel(element, true);
    }

    protected IModel createModel(Object element, boolean editable) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            String name = file.getName().toLowerCase();
            if (name.equals("plugin.xml")) {
                WorkspacePluginModel model = new WorkspacePluginModel(file);
                model.setEditable(editable && model.isEditable());
                return model;
            }
            if (name.equals("fragment.xml")) {
                WorkspaceFragmentModel model = new WorkspaceFragmentModel(file);
                model.setEditable(editable && model.isEditable());
                return model;
            }
            if (name.equals("build.properties")) {
                WorkspaceBuildModel model = new WorkspaceBuildModel(file);
                model.setEditable(editable && model.isEditable());
                return model;
            }
            if (name.equals("feature.xml")) {
                WorkspaceFeatureModel model = new WorkspaceFeatureModel(file);
                model.setEditable(editable && model.isEditable());
                return model;
            }
            if (name.equals("site.xml")) {
                WorkspaceSiteModel model = new WorkspaceSiteModel(file);
                model.setEditable(editable && model.isEditable());
                return model;
            }
            if (name.equals("sitebuild.xml")) {
                WorkspaceSiteBuildModel model = new WorkspaceSiteBuildModel(file);
                model.setEditable(editable && model.isEditable());
                return model;
            }
        }
        return null;
    }

    private IPluginModelBase createWorkspacePluginModel(IFile pluginFile) {
        if (!pluginFile.exists()) {
            return null;
        }
        this.connect(pluginFile, null, false);
        IPluginModelBase model = (IPluginModelBase)this.getModel(pluginFile, null);
        this.loadWorkspaceModel(model);
        return model;
    }

    private IModel createWorkspacePluginModel(IProject project) {
        IPath pluginPath = project.getFullPath().append("plugin.xml");
        IFile pluginFile = project.getWorkspace().getRoot().getFile(pluginPath);
        if (!pluginFile.exists()) {
            pluginPath = project.getFullPath().append("fragment.xml");
            pluginFile = project.getWorkspace().getRoot().getFile(pluginPath);
        }
        if (pluginFile.exists()) {
            return this.createWorkspacePluginModel(pluginFile);
        }
        return this.createWorkspaceFeatureModel(project);
    }

    private IFeatureModel createWorkspaceFeatureModel(IFile featureFile) {
        if (!featureFile.exists()) {
            return null;
        }
        this.connect(featureFile, null, false);
        IFeatureModel model = (IFeatureModel)this.getModel(featureFile, null);
        this.loadFeatureModel(model);
        return model;
    }

    private IFeatureModel createWorkspaceFeatureModel(IProject project) {
        IFile featureFile = project.getFile("feature.xml");
        if (featureFile.exists()) {
            return this.createWorkspaceFeatureModel(featureFile);
        }
        return null;
    }

    public void disconnect(Object element, Object consumer) {
        ModelInfo info = (ModelInfo)this.models.get(element);
        if (info != null) {
            --info.count;
            if (info.consumer != null && info.consumer.equals(consumer)) {
                info.model.dispose();
                info.model = null;
            }
            if (info.count == 0) {
                if (info.model != null) {
                    info.model.dispose();
                }
                info.readOnlyModel = null;
                this.models.remove(element);
            }
        }
    }

    private void fireModelProviderEvent(ModelProviderEvent event) {
        Iterator iter = ((AbstractList)this.listeners).iterator();
        while (iter.hasNext()) {
            ((IModelProviderListener)iter.next()).modelsChanged(event);
        }
    }

    public void fireModelsChanged(IModel[] models) {
        ModelProviderEvent event = new ModelProviderEvent(this, 4, null, null, models);
        this.fireModelProviderEvent(event);
    }

    public boolean getAllEditableModelsUnused(Class modelClass) {
        Enumeration enumeration = this.models.elements();
        while (enumeration.hasMoreElements()) {
            ModelInfo info = (ModelInfo)enumeration.nextElement();
            if (info.model == null || !info.model.getClass().isInstance(modelClass)) continue;
            return false;
        }
        return true;
    }

    public IFragment[] getFragmentsFor(String pluginId, String version) {
        Vector<IFragment> result = new Vector<IFragment>();
        if (this.workspaceFragmentModels == null) {
            this.initializeWorkspacePluginModels();
        }
        this.validate(this.workspaceFragmentModels);
        int i = 0;
        while (i < this.workspaceFragmentModels.size()) {
            IFragmentModel model = (IFragmentModel)this.workspaceFragmentModels.elementAt(i);
            IFragment fragment = model.getFragment();
            if (PDECore.compare(fragment.getPluginId(), fragment.getPluginVersion(), pluginId, version, fragment.getRule())) {
                result.add(fragment);
            }
            ++i;
        }
        Object[] array = new IFragment[result.size()];
        result.copyInto(array);
        return array;
    }

    public IModel getModel(Object element, Object consumer) {
        ModelInfo info = (ModelInfo)this.models.get(element);
        if (info != null) {
            if (info.consumer != null && info.consumer.equals(consumer)) {
                return info.model;
            }
            return info.readOnlyModel;
        }
        return null;
    }

    public IFragmentModel[] getWorkspaceFragmentModels() {
        if (this.workspaceFragmentModels == null) {
            this.initializeWorkspacePluginModels();
        }
        this.validate(this.workspaceFragmentModels);
        Object[] result = new IFragmentModel[this.workspaceFragmentModels.size()];
        this.workspaceFragmentModels.copyInto(result);
        return result;
    }

    public IFeatureModel[] getWorkspaceFeatureModels() {
        if (this.workspaceFeatureModels == null) {
            this.initializeWorkspacePluginModels();
        }
        this.validate(this.workspaceFeatureModels);
        Object[] result = new IFeatureModel[this.workspaceFeatureModels.size()];
        this.workspaceFeatureModels.copyInto(result);
        return result;
    }

    private IModel getWorkspaceModel(IFile file) {
        return this.getWorkspaceModel(file, true);
    }

    private IModel getWorkspaceModel(IFile file, boolean validate) {
        String name = file.getName().toLowerCase();
        Vector models = null;
        if (validate) {
            this.validate();
        }
        if (name.equals("plugin.xml")) {
            models = this.workspaceModels;
        } else if (name.equals("fragment.xml")) {
            models = this.workspaceFragmentModels;
        } else if (name.equals("feature.xml")) {
            models = this.workspaceFeatureModels;
        }
        return this.getWorkspaceModel(file.getProject(), models);
    }

    public IModel getWorkspaceModel(IProject project) {
        this.validate();
        IPath filePath = project.getFullPath().append("plugin.xml");
        IFile file = project.getWorkspace().getRoot().getFile(filePath);
        if (file.exists()) {
            return this.getWorkspaceModel(project, this.workspaceModels);
        }
        filePath = project.getFullPath().append("fragment.xml");
        file = project.getWorkspace().getRoot().getFile(filePath);
        if (file.exists()) {
            return this.getWorkspaceModel(project, this.workspaceFragmentModels);
        }
        file = project.getFile("feature.xml");
        if (file.exists()) {
            return this.getWorkspaceModel(project, this.workspaceFeatureModels);
        }
        return null;
    }

    private IModel getWorkspaceModel(IProject project, Vector models) {
        if (models == null) {
            return null;
        }
        int i = 0;
        while (i < models.size()) {
            IModel model = (IModel)models.elementAt(i);
            IFile file = (IFile)model.getUnderlyingResource();
            if (file.getProject().equals((Object)project)) {
                return model;
            }
            ++i;
        }
        return null;
    }

    public IPluginModel[] getWorkspacePluginModels() {
        if (this.workspaceModels == null) {
            this.initializeWorkspacePluginModels();
        }
        this.validate(this.workspaceModels);
        Object[] result = new IPluginModel[this.workspaceModels.size()];
        this.workspaceModels.copyInto(result);
        return result;
    }

    public IPluginModelBase[] getAllModels() {
        if (this.workspaceModels == null) {
            this.initializeWorkspacePluginModels();
        }
        this.validate();
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < this.workspaceModels.size()) {
            result.add(this.workspaceModels.get(i));
            ++i;
        }
        i = 0;
        while (i < this.workspaceFragmentModels.size()) {
            result.add(this.workspaceFragmentModels.get(i));
            ++i;
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    private void handleFileDelta(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        this.checkTracing(file);
        if (!this.isSupportedFile(file)) {
            return;
        }
        if (delta.getKind() == 1) {
            IModel model = this.getWorkspaceModel(file);
            if (model == null) {
                model = file.getName().equalsIgnoreCase("feature.xml") ? this.createWorkspaceFeatureModel(file) : this.createWorkspacePluginModel(file);
                this.addWorkspaceModel(model);
            } else if (model instanceof IFeatureModel) {
                this.reloadFeatureModel((IFeatureModel)model);
            } else {
                this.reloadWorkspaceModel((IPluginModelBase)model);
            }
        } else if (delta.getKind() == 2) {
            IModel model = this.getWorkspaceModel(file, false);
            if (model != null) {
                this.removeWorkspaceModel(model);
            }
        } else if (delta.getKind() == 4) {
            IModel model = this.getWorkspaceModel(file);
            if (model == null) {
                return;
            }
            if ((0x100 & delta.getFlags()) != 0) {
                if (model instanceof IFeatureModel) {
                    this.reloadFeatureModel((IFeatureModel)model);
                } else {
                    this.reloadWorkspaceModel((IPluginModelBase)model);
                }
            }
        }
    }

    private void handleProjectClosing(IProject project) {
        this.handleProjectToBeDeleted(project);
    }

    private void handleProjectDelta(IResourceDelta delta) {
        IProject project = (IProject)delta.getResource();
        int kind = delta.getKind();
        if (!project.isOpen()) {
            return;
        }
        if (kind == 4 && (delta.getFlags() | 0x80000) != 0) {
            if (WorkspaceModelManager.isPluginProject(project)) {
                this.ensureModelExists(project);
                this.validateBinaryStatus(project);
            } else if (WorkspaceModelManager.isFeatureProject(project)) {
                this.ensureModelExists(project);
            }
        }
    }

    private void validateBinaryStatus(IProject project) {
        boolean shared = false;
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
        if (provider != null && !(provider instanceof BinaryRepositoryProvider)) {
            shared = true;
        }
        if (shared) {
            try {
                String binary = project.getPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY);
                if (binary != null) {
                    project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, null);
                }
            }
            catch (CoreException e) {
                PDECore.logException(e);
            }
        }
    }

    private void handleProjectToBeDeleted(IProject project) {
        if (!WorkspaceModelManager.isPluginProject(project) && !WorkspaceModelManager.isFeatureProject(project)) {
            return;
        }
        IModel model = this.getWorkspaceModel(project);
        if (model != null) {
            this.removeWorkspaceModel(model);
        }
    }

    private void handleResourceDelta(IResourceDelta delta) {
        try {
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
    }

    private void initializeWorkspacePluginModels() {
        System.currentTimeMillis();
        this.workspaceModels = new Vector();
        this.workspaceFragmentModels = new Vector();
        this.workspaceFeatureModels = new Vector();
        IWorkspace workspace = PDECore.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.isOpen()) {
                IModel model;
                if (WorkspaceModelManager.isPluginProject(project)) {
                    model = this.createWorkspacePluginModel(project);
                    if (model != null) {
                        if (model instanceof IFragmentModel) {
                            this.workspaceFragmentModels.add(model);
                        } else {
                            this.workspaceModels.add(model);
                        }
                    }
                } else if (WorkspaceModelManager.isFeatureProject(project)) {
                    model = this.createWorkspaceFeatureModel(project);
                    this.workspaceFeatureModels.add(model);
                }
            }
            ++i;
        }
        workspace.addResourceChangeListener((IResourceChangeListener)this, 14);
        this.initialized = true;
        System.currentTimeMillis();
    }

    public static boolean isPluginProject(IProject project) {
        if (!project.isOpen()) {
            return false;
        }
        return project.exists((IPath)new Path("plugin.xml")) || project.exists((IPath)new Path("fragment.xml"));
    }

    public static boolean isFeatureProject(IProject project) {
        if (!project.isOpen()) {
            return false;
        }
        return project.exists((IPath)new Path("feature.xml"));
    }

    public static boolean isJavaPluginProject(IProject project) {
        if (!WorkspaceModelManager.isPluginProject(project)) {
            return false;
        }
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                return false;
            }
        }
        catch (CoreException e) {
            PDECore.logException(e);
            return false;
        }
        return true;
    }

    public static boolean isJavaPluginProjectWithSource(IProject project) {
        if (!WorkspaceModelManager.isJavaPluginProject(project)) {
            return false;
        }
        try {
            IJavaProject jProject = JavaCore.create((IProject)project);
            IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (roots[i].getKind() == 1) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public static boolean isBinaryPluginProject(IProject project) {
        if (!WorkspaceModelManager.isPluginProject(project)) {
            return false;
        }
        try {
            String binary = project.getPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY);
            if (binary != null) {
                RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                return provider == null || provider instanceof BinaryRepositoryProvider;
            }
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
        return false;
    }

    public static boolean isBinaryFeatureProject(IProject project) {
        if (!WorkspaceModelManager.isFeatureProject(project)) {
            return false;
        }
        try {
            String binary = project.getPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY);
            if (binary != null) {
                RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                return provider == null || provider instanceof BinaryRepositoryProvider;
            }
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
        return false;
    }

    private void ensureModelExists(IProject pluginProject) {
        if (!this.initialized) {
            return;
        }
        IModel model = this.getWorkspaceModel(pluginProject);
        if (model == null && (model = this.createWorkspacePluginModel(pluginProject)) != null) {
            this.addWorkspaceModel(model);
        }
    }

    private boolean isSupportedFile(IFile file) {
        String name = file.getName().toLowerCase();
        if (!(name.equals("plugin.xml") || name.equals("fragment.xml") || name.equals("feature.xml"))) {
            return false;
        }
        IPath expectedPath = file.getProject().getFullPath().append(name);
        return expectedPath.equals((Object)file.getFullPath());
    }

    private void loadWorkspaceModel(IPluginModelBase model) {
        IFile file = (IFile)model.getUnderlyingResource();
        InputStream stream = null;
        boolean outOfSync = false;
        try {
            stream = file.getContents(false);
        }
        catch (CoreException coreException) {
            outOfSync = true;
        }
        if (outOfSync) {
            try {
                stream = file.getContents(true);
            }
            catch (CoreException e) {
                IPluginBase base = model.getPluginBase(true);
                try {
                    base.setId(file.getProject().getName());
                    base.setName(base.getId());
                    base.setVersion("0.0.0");
                    PDECore.log(e);
                }
                catch (CoreException ex) {
                    PDECore.logException(ex);
                }
                return;
            }
        }
        try {
            model.load(stream, outOfSync);
            stream.close();
        }
        catch (CoreException coreException) {
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    private void loadFeatureModel(IFeatureModel model) {
        IFile file = (IFile)model.getUnderlyingResource();
        InputStream stream = null;
        boolean outOfSync = false;
        try {
            stream = file.getContents(false);
        }
        catch (CoreException coreException) {
            outOfSync = true;
        }
        if (outOfSync) {
            try {
                stream = file.getContents(true);
            }
            catch (CoreException coreException) {
                return;
            }
        }
        try {
            model.load(stream, outOfSync);
            stream.close();
        }
        catch (CoreException coreException) {
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    private void reloadWorkspaceModel(IPluginModelBase model) {
        this.loadWorkspaceModel(model);
        this.fireModelsChanged(new IModel[]{model});
        PDECore.getDefault().getTracingOptionsManager().reset();
    }

    private void reloadFeatureModel(IFeatureModel model) {
        this.loadFeatureModel(model);
        this.fireModelsChanged(new IModel[]{model});
    }

    public void removeModelProviderListener(IModelProviderListener listener) {
        this.listeners.remove(listener);
    }

    private void removeWorkspaceModel(IModel model) {
        if (model instanceof IFragmentModel && this.workspaceFragmentModels != null) {
            this.workspaceFragmentModels.remove(model);
        }
        if (model instanceof IFeatureModel) {
            if (this.workspaceFeatureModels != null) {
                this.workspaceFeatureModels.remove(model);
            }
        } else if (this.workspaceModels != null) {
            this.workspaceModels.remove(model);
        }
        if (this.modelChanges != null) {
            this.modelChanges.add(new ModelChange(model, false));
        }
        IResource element = model.getUnderlyingResource();
        this.disconnect(element, null);
        PDECore.getDefault().getTracingOptionsManager().reset();
        model.dispose();
    }

    public void reset() {
        this.initializeWorkspacePluginModels();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.workspaceModels == null) {
            return;
        }
        switch (event.getType()) {
            case 8: {
                if (this.modelChanges == null) {
                    this.modelChanges = new Vector();
                }
                this.handleResourceDelta(event.getDelta());
                this.processModelChanges();
                break;
            }
            case 2: {
                if (this.modelChanges == null) {
                    this.modelChanges = new Vector();
                }
                this.handleProjectClosing((IProject)event.getResource());
                this.processModelChanges();
            }
        }
    }

    private void processModelChanges() {
        if (this.modelChanges.size() == 0) {
            this.modelChanges = null;
            return;
        }
        Vector<IModel> added = new Vector<IModel>();
        Vector<IModel> removed = new Vector<IModel>();
        int i = 0;
        while (i < this.modelChanges.size()) {
            ModelChange change = (ModelChange)this.modelChanges.get(i);
            if (change.added) {
                added.add(change.model);
            } else {
                removed.add(change.model);
            }
            ++i;
        }
        IModel[] addedArray = added.size() > 0 ? added.toArray(new IModel[added.size()]) : null;
        IModel[] removedArray = removed.size() > 0 ? removed.toArray(new IModel[removed.size()]) : null;
        int type = 0;
        if (addedArray != null) {
            type |= 1;
        }
        if (removedArray != null) {
            type |= 2;
        }
        this.modelChanges = null;
        if (type != 0) {
            ModelProviderEvent event = new ModelProviderEvent(this, type, addedArray, removedArray, null);
            this.fireModelProviderEvent(event);
        }
    }

    public void shutdown() {
        if (!this.initialized) {
            return;
        }
        IWorkspace workspace = PDECore.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
        Iterator iter = this.models.values().iterator();
        while (iter.hasNext()) {
            ModelInfo info = (ModelInfo)iter.next();
            if (info.model != null) {
                info.model.dispose();
            }
            if (info.readOnlyModel != null) {
                info.readOnlyModel.dispose();
            }
            Object var3_3 = null;
        }
        this.models.clear();
        this.workspaceModels = null;
        this.initialized = false;
    }

    private void verifyConsumer(ModelInfo info) {
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta != null) {
            IResource resource = delta.getResource();
            if (resource instanceof IProject) {
                this.handleProjectDelta(delta);
                IProject project = (IProject)resource;
                if (delta.getKind() == 2) {
                    return true;
                }
                return WorkspaceModelManager.isPluginProject(project) || WorkspaceModelManager.isFeatureProject(project);
            }
            if (resource instanceof IFile) {
                this.handleFileDelta(delta);
            }
        }
        return true;
    }

    private void validate() {
        this.validate(this.workspaceModels);
        this.validate(this.workspaceFragmentModels);
        this.validate(this.workspaceFeatureModels);
    }

    private void validate(Vector models) {
        if (models == null) {
            return;
        }
        Object[] entries = models.toArray();
        int i = 0;
        while (i < entries.length) {
            IModel model = (IModel)entries[i];
            if (!this.isValid(model)) {
                models.remove(model);
            }
            ++i;
        }
    }

    private boolean isValid(IModel model) {
        IResource resource = model.getUnderlyingResource();
        if (resource == null) {
            return false;
        }
        if (!resource.exists()) {
            return false;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        if (!project.isOpen()) {
            return false;
        }
        return this.hasRootObject(model) && model.isValid();
    }

    private boolean hasRootObject(IModel model) {
        if (model instanceof IPluginModelBase) {
            return this.hasRootObject((IPluginModelBase)model);
        }
        if (model instanceof IFeatureModel) {
            return this.hasRootObject((IFeatureModel)model);
        }
        return false;
    }

    private boolean hasRootObject(IPluginModelBase model) {
        IPluginBase plugin = model.getPluginBase();
        return plugin != null;
    }

    private boolean hasRootObject(IFeatureModel model) {
        IFeature feature = model.getFeature();
        return feature != null;
    }

    class ModelChange {
        IModel model;
        boolean added;

        public ModelChange(IModel model, boolean added) {
            this.model = model;
            this.added = added;
        }
    }

    class ModelInfo {
        int count;
        IModel model;
        IModel readOnlyModel;
        Object consumer;

        ModelInfo() {
        }

        public boolean isExclusiveAccess() {
            return true;
        }
    }
}

