/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;

public class TracingOptionsManager {
    private Properties template;
    private Properties options;

    private void addToTemplate(IPluginModelBase[] models) {
        int i = 0;
        while (i < models.length) {
            this.addToTemplate(models[i]);
            ++i;
        }
    }

    private void addToTemplate(IPluginModelBase model) {
        Properties modelOptions = this.getOptions(model);
        if (modelOptions == null) {
            return;
        }
        Enumeration enumeration = ((Hashtable)modelOptions).keys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            this.template.setProperty(key, modelOptions.getProperty(key));
        }
    }

    private void createTemplate() {
        this.template = new Properties();
        this.addToTemplate(PDECore.getDefault().getWorkspaceModelManager().getWorkspacePluginModels());
        this.addToTemplate(PDECore.getDefault().getExternalModelManager().getModels());
    }

    public void ensureTracingFileExists() {
        String fileName = this.getTracingFileName();
        File file = new File(fileName);
        if (!file.exists()) {
            this.getTracingOptions();
            this.save();
        }
    }

    private Properties getOptions(IPluginModelBase model) {
        InputStream stream = this.openInputStream(model);
        if (stream != null) {
            Properties modelOptions = new Properties();
            try {
                modelOptions.load(stream);
                stream.close();
                return modelOptions;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public Hashtable getTemplateTable(String pluginId) {
        if (this.template == null) {
            this.createTemplate();
        }
        Hashtable defaults = new Hashtable();
        Enumeration enumeration = ((Hashtable)this.template).keys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement().toString();
            if (!this.belongsTo(key, pluginId)) continue;
            defaults.put(key, ((Hashtable)this.template).get(key));
        }
        return defaults;
    }

    private boolean belongsTo(String option, String pluginId) {
        Path path = new Path(option);
        String firstSegment = path.segment(0);
        return pluginId.equalsIgnoreCase(firstSegment);
    }

    public String getTracingFileName() {
        IPath stateLocation = PDECore.getDefault().getStateLocation();
        return stateLocation.append(".options").toOSString();
    }

    public Properties getTracingOptions() {
        Properties defaults;
        this.options = defaults = this.getTracingTemplateCopy();
        this.loadStoredOptions();
        return this.options;
    }

    public Properties getTracingTemplateCopy() {
        if (this.template == null) {
            this.createTemplate();
        }
        return (Properties)((Hashtable)this.template).clone();
    }

    public static boolean isTraceable(IPluginModelBase model) {
        if (model.getUnderlyingResource() != null) {
            IProject project = model.getUnderlyingResource().getProject();
            IPath path = project.getFullPath().append(".options");
            IFile file = project.getWorkspace().getRoot().getFile(path);
            return file.exists();
        }
        String location = model.getInstallLocation();
        String fileName = String.valueOf(location) + File.separator + ".options";
        File file = new File(fileName);
        return file.exists();
    }

    private void loadStoredOptions() {
        String fileName = this.getTracingFileName();
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        try {
            FileInputStream stream = new FileInputStream(file);
            Properties storedOptions = new Properties();
            storedOptions.load(stream);
            stream.close();
            Enumeration enumeration = ((Hashtable)storedOptions).keys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement().toString();
                if (!((Hashtable)this.options).containsKey(key)) continue;
                this.options.setProperty(key, storedOptions.getProperty(key));
            }
        }
        catch (Exception e) {
            PDECore.logException(e);
        }
    }

    private InputStream openInputStream(IPluginModelBase model) {
        if (model.getUnderlyingResource() != null) {
            IProject project = model.getUnderlyingResource().getProject();
            IPath path = project.getFullPath().append(".options");
            IFile file = project.getWorkspace().getRoot().getFile(path);
            if (file.exists()) {
                try {
                    return file.getContents();
                }
                catch (CoreException coreException) {}
            }
        } else {
            String fileName = String.valueOf(model.getInstallLocation()) + File.separator + ".options";
            File file = new File(fileName);
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    public void reset() {
        this.template = null;
    }

    public void save() {
        this.save(this.getTracingFileName(), this.options);
    }

    private void save(String fileName, Properties properties) {
        try {
            FileOutputStream stream = new FileOutputStream(fileName);
            properties.store(stream, "Master Tracing Options");
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    public void setTracingOptions(Properties options) {
        this.options = options;
    }

    public void save(Map map) {
        Properties properties = new Properties();
        ((Hashtable)properties).putAll(map);
        this.save(this.getTracingFileName(), properties);
    }
}

