/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TempFileManager {
    private static final int TEMP_FILE_LIMIT = 10;
    private Hashtable clients = new Hashtable();

    public File createTempFile(Object client, String prefix, String suffix) throws CoreException {
        ArrayList<File> files = (ArrayList<File>)this.clients.get(client);
        if (files == null) {
            files = new ArrayList<File>();
            this.clients.put(client, files);
        }
        try {
            File tmpFile = File.createTempFile(prefix, suffix);
            if (files.size() > 10) {
                this.purgeTempFiles(files);
            }
            files.add(tmpFile);
            return tmpFile;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.pde.core", 0, null, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void purgeTempFiles(ArrayList tempFiles) {
        File[] files = tempFiles.toArray(new File[tempFiles.size()]);
        int i = 0;
        while (i < files.length) {
            File tempFile = files[i];
            if (tempFile.delete()) {
                ((AbstractCollection)tempFiles).remove(tempFile);
            }
            ++i;
        }
    }

    public void disconnect(Object client) {
        ArrayList files = (ArrayList)this.clients.get(client);
        if (files != null) {
            this.purgeTempFiles(files);
            this.clients.remove(client);
        }
    }

    public void shutdown() {
        Enumeration enumeration = this.clients.elements();
        while (enumeration.hasMoreElements()) {
            ArrayList files = (ArrayList)enumeration.nextElement();
            this.purgeTempFiles(files);
        }
        this.clients.clear();
    }
}

