/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.Choice;
import org.eclipse.pde.internal.core.CoreArraySorter;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.IEnvironmentVariables;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class TargetPlatform
implements IEnvironmentVariables {
    private static final String BOOT_ID = "org.eclipse.core.boot";

    public static File createPropertiesFile() throws CoreException {
        return TargetPlatform.createPropertiesFile(TargetPlatform.getVisibleModels(), null);
    }

    public static URL[] createPluginPath() throws CoreException {
        return TargetPlatform.createPluginPath(TargetPlatform.getVisibleModels());
    }

    public static URL[] createPluginPath(IPluginModelBase[] models) throws CoreException {
        URL[] urls = new URL[models.length];
        int i = 0;
        while (i < urls.length) {
            IPluginModelBase model = models[i];
            String urlName = TargetPlatform.createURL(model);
            try {
                urls[i] = new URL(urlName);
            }
            catch (MalformedURLException e) {
                PDECore.logException(e);
                return new URL[0];
            }
            ++i;
        }
        return urls;
    }

    private static IPluginModelBase[] getVisibleModels() {
        Vector result = new Vector();
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        TargetPlatform.addFromList(result, manager.getPlugins());
        IPluginModelBase[] array = result.toArray(new IPluginModelBase[result.size()]);
        return array;
    }

    private static void addFromList(Vector result, IPluginModelBase[] list) {
        int i = 0;
        while (i < list.length) {
            IPluginModelBase model = list[i];
            if (model.isEnabled()) {
                result.add(list[i]);
            }
            ++i;
        }
    }

    public static File createPropertiesFile(IPluginModelBase[] plugins, IPath data) throws CoreException {
        try {
            Object var9_11;
            String dataSuffix = TargetPlatform.createDataSuffix(data);
            IPath statePath = PDECore.getDefault().getStateLocation();
            String fileName = "plugin_path.properties";
            File dir = new File(statePath.toOSString());
            if (dataSuffix.length() > 0 && !(dir = new File(dir, dataSuffix)).exists()) {
                dir.mkdir();
            }
            File pluginFile = new File(dir, fileName);
            Properties properties = new Properties();
            int i = 0;
            while (i < plugins.length) {
                IPluginModelBase curr = plugins[i];
                String key = TargetPlatform.getKey(curr);
                if (key != null) {
                    properties.setProperty(key, TargetPlatform.createURL(curr));
                }
                ++i;
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(pluginFile);
                properties.store(fos, null);
            }
            catch (Throwable throwable) {
                var9_11 = null;
                if (fos != null) {
                    fos.close();
                }
                throw throwable;
            }
            var9_11 = null;
            if (fos != null) {
                fos.close();
            }
            return pluginFile;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PDECore.getPluginId(), 4, e.getMessage(), (Throwable)e));
        }
    }

    public static File createPlatformConfiguration(IPluginModelBase[] plugins, IPath data, String primaryFeatureId) throws CoreException {
        try {
            String dataSuffix = TargetPlatform.createDataSuffix(data);
            IPath statePath = PDECore.getDefault().getStateLocation();
            String fileName = "platform.cfg";
            File dir = new File(statePath.toOSString());
            if (dataSuffix.length() > 0 && !(dir = new File(dir, dataSuffix)).exists()) {
                dir.mkdir();
            }
            File configFile = new File(dir, fileName);
            TargetPlatform.savePlatformConfiguration(configFile, plugins, primaryFeatureId);
            return configFile;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = PDECore.getResourceString("TargetPlatform.exceptionThrown");
            }
            throw new CoreException((IStatus)new Status(4, PDECore.getPluginId(), 4, message, (Throwable)e));
        }
    }

    private static void savePlatformConfiguration(File configFile, IPluginModelBase[] models, String primaryFeatureId) throws IOException, CoreException, MalformedURLException {
        PluginVersionIdentifier bootVid;
        PluginVersionIdentifier breakVid;
        String version;
        ArrayList sites = new ArrayList();
        IPluginModelBase bootModel = null;
        int i = 0;
        while (i < models.length) {
            IResource resource;
            IPluginModelBase model = models[i];
            IPluginBase plugin = model.getPluginBase();
            String id = plugin.getId();
            if (id.equals(BOOT_ID)) {
                bootModel = model;
            }
            if ((resource = model.getUnderlyingResource()) != null) {
                IPath realPath = resource.getLocation();
                TargetPlatform.addToSite(realPath.removeLastSegments(3), model, sites);
            } else {
                Path path = new Path(model.getInstallLocation());
                path = path.removeLastSegments(2);
                TargetPlatform.addToSite((IPath)path, model, sites);
            }
            ++i;
        }
        URL configURL = new URL("file:" + configFile.getPath());
        IPlatformConfiguration platformConfiguration = BootLoader.getPlatformConfiguration(null);
        TargetPlatform.createConfigurationEntries(platformConfiguration, bootModel, sites);
        TargetPlatform.createFeatureEntries(platformConfiguration, models, primaryFeatureId);
        platformConfiguration.refresh();
        platformConfiguration.save(configURL);
        if (bootModel != null && (version = bootModel.getPluginBase().getVersion()) != null && (breakVid = new PluginVersionIdentifier("2.0.3")).isGreaterThan(bootVid = new PluginVersionIdentifier(version))) {
            TargetPlatform.repairConfigurationVersion(configURL);
        }
    }

    private static void repairConfigurationVersion(URL url) throws IOException {
        File file = new File(url.getFile());
        if (file.exists()) {
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            p.setProperty("version", "1.0");
            fis.close();
            FileOutputStream fos = new FileOutputStream(file);
            p.store(fos, new Date().toString());
            fos.close();
        }
    }

    private static void addToSite(IPath path, IPluginModelBase model, ArrayList sites) {
        int i = 0;
        while (i < sites.size()) {
            LocalSite localSite = (LocalSite)sites.get(i);
            if (localSite.getPath().equals((Object)path)) {
                localSite.add(model);
                return;
            }
            ++i;
        }
        LocalSite localSite = new LocalSite(path);
        localSite.add(model);
        sites.add(localSite);
    }

    private static void createConfigurationEntries(IPlatformConfiguration config, IPluginModelBase bootModel, ArrayList sites) throws CoreException, MalformedURLException {
        int i = 0;
        while (i < sites.size()) {
            LocalSite localSite = (LocalSite)sites.get(i);
            String[] plugins = localSite.getRelativePluginList();
            int policy = 0;
            IPlatformConfiguration.ISitePolicy sitePolicy = config.createSitePolicy(policy, plugins);
            IPlatformConfiguration.ISiteEntry siteEntry = config.createSiteEntry(localSite.getURL(), sitePolicy);
            config.configureSite(siteEntry);
            ++i;
        }
        IPath bootPath = TargetPlatform.getPluginLocation(bootModel);
        URL bootURL = new URL("file:" + bootPath.toOSString());
        config.setBootstrapPluginLocation(BOOT_ID, bootURL);
        config.isTransient(true);
    }

    private static IPath getPluginLocation(IPluginModelBase model) {
        String location = model.getInstallLocation();
        IResource resource = model.getUnderlyingResource();
        if (resource != null && resource.isLinked()) {
            location = resource.getLocation().removeLastSegments(1).addTrailingSeparator().toString();
        }
        return new Path(location).addTrailingSeparator();
    }

    private static void createFeatureEntries(IPlatformConfiguration config, IPluginModelBase[] models, String primaryFeatureId) throws MalformedURLException {
        IPath targetPath = ExternalModelManager.getEclipseHome(null);
        if (primaryFeatureId == null) {
            return;
        }
        IFeatureModel featureModel = TargetPlatform.loadPrimaryFeatureModel(targetPath, primaryFeatureId);
        if (featureModel == null) {
            return;
        }
        IFeature feature = featureModel.getFeature();
        String featureVersion = feature.getVersion();
        String pluginId = primaryFeatureId;
        IPluginBase primaryPlugin = TargetPlatform.findPlugin(pluginId, models);
        if (primaryPlugin == null) {
            return;
        }
        IPath pluginPath = TargetPlatform.getPluginLocation(primaryPlugin.getModel());
        URL pluginURL = new URL("file:" + pluginPath.toString());
        URL[] root = new URL[]{pluginURL};
        IPlatformConfiguration.IFeatureEntry featureEntry = config.createFeatureEntry(primaryFeatureId, featureVersion, pluginId, primaryPlugin.getVersion(), true, null, root);
        config.configureFeatureEntry(featureEntry);
        featureModel.dispose();
    }

    private static IPluginBase findPlugin(String id, IPluginModelBase[] models) {
        int i = 0;
        while (i < models.length) {
            IPluginBase plugin;
            IPluginModelBase model = models[i];
            if (!model.isFragmentModel() && (plugin = model.getPluginBase()).getId().equals(id)) {
                return plugin;
            }
            ++i;
        }
        return null;
    }

    private static IFeatureModel loadPrimaryFeatureModel(IPath targetPath, String featureId) {
        File mainFeatureDir = targetPath.append("features").toFile();
        if (!mainFeatureDir.exists() || !mainFeatureDir.isDirectory()) {
            return null;
        }
        File[] featureDirs = mainFeatureDir.listFiles();
        PluginVersionIdentifier bestVid = null;
        File bestDir = null;
        int i = 0;
        while (i < featureDirs.length) {
            int loc;
            File featureDir = featureDirs[i];
            String name = featureDir.getName();
            if (featureDir.isDirectory() && name.startsWith(featureId) && (loc = name.lastIndexOf("_")) != -1) {
                String version = name.substring(loc + 1);
                PluginVersionIdentifier vid = new PluginVersionIdentifier(version);
                if (bestVid == null || vid.isGreaterThan(bestVid)) {
                    bestVid = vid;
                    bestDir = featureDir;
                }
            }
            ++i;
        }
        if (bestVid == null) {
            return null;
        }
        File manifest = new File(bestDir, "feature.xml");
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation(bestDir.getAbsolutePath());
        FileInputStream stream = null;
        boolean error = false;
        try {
            stream = new FileInputStream(manifest);
            model.load(stream, false);
        }
        catch (Exception exception) {
            error = true;
        }
        if (stream != null) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        if (error || !model.isLoaded()) {
            return null;
        }
        return model;
    }

    private static String getKey(IPluginModelBase model) {
        if (model.isLoaded()) {
            return model.getPluginBase().getId();
        }
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            return resource.getProject().getName();
        }
        return model.getInstallLocation();
    }

    private static String createDataSuffix(IPath data) {
        if (data == null) {
            return "";
        }
        String suffix = data.toOSString();
        suffix = suffix.replace(File.separatorChar, '_');
        return suffix.replace(':', '_');
    }

    private static String createURL(IPluginModelBase model) {
        String linkedURL = TargetPlatform.createLinkedURL(model);
        if (linkedURL != null) {
            return linkedURL;
        }
        String prefix = "file:" + model.getInstallLocation() + File.separator;
        if (model instanceof IPluginModel) {
            return String.valueOf(prefix) + "plugin.xml";
        }
        if (model instanceof IFragmentModel) {
            return String.valueOf(prefix) + "fragment.xml";
        }
        return "";
    }

    private static String createLinkedURL(IPluginModelBase model) {
        IResource resource = model.getUnderlyingResource();
        if (resource == null || !resource.isLinked()) {
            return null;
        }
        return "file:" + resource.getLocation().toOSString();
    }

    public static String getOS() {
        TargetPlatform.initializeDefaults();
        return TargetPlatform.getProperty("org.eclipse.pde.ui.os");
    }

    public static String getWS() {
        TargetPlatform.initializeDefaults();
        return TargetPlatform.getProperty("org.eclipse.pde.ui.ws");
    }

    public static String getNL() {
        TargetPlatform.initializeDefaults();
        return TargetPlatform.getProperty("org.eclipse.pde.ui.nl");
    }

    public static String getOSArch() {
        TargetPlatform.initializeDefaults();
        return TargetPlatform.getProperty("org.eclipse.pde.ui.arch");
    }

    private static String getProperty(String key) {
        return PDECore.getDefault().getPluginPreferences().getString(key);
    }

    public static void initializeDefaults() {
        Preferences settings = PDECore.getDefault().getPluginPreferences();
        settings.setDefault("org.eclipse.pde.ui.os", BootLoader.getOS());
        settings.setDefault("org.eclipse.pde.ui.ws", BootLoader.getWS());
        settings.setDefault("org.eclipse.pde.ui.nl", Locale.getDefault().toString());
        settings.setDefault("org.eclipse.pde.ui.arch", BootLoader.getOSArch());
    }

    private static Choice[] getKnownChoices(String[] values) {
        Choice[] choices = new Choice[values.length];
        int i = 0;
        while (i < choices.length) {
            choices[i] = new Choice(values[i], values[i]);
            ++i;
        }
        return choices;
    }

    public static Choice[] getOSChoices() {
        return TargetPlatform.getKnownChoices(BootLoader.knownOSValues());
    }

    public static Choice[] getWSChoices() {
        return TargetPlatform.getKnownChoices(BootLoader.knownWSValues());
    }

    public static Choice[] getNLChoices() {
        Locale[] locales = Locale.getAvailableLocales();
        Object[] choices = new Choice[locales.length];
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            choices[i] = new Choice(locale.toString(), String.valueOf(locale.toString()) + " - " + locale.getDisplayName());
            ++i;
        }
        CoreArraySorter.INSTANCE.sortInPlace(choices);
        return choices;
    }

    public static Choice[] getArchChoices() {
        return TargetPlatform.getKnownChoices(BootLoader.knownOSArchValues());
    }

    static class LocalSite {
        private ArrayList plugins;
        private IPath path;

        public LocalSite(IPath path) {
            this.path = path;
            this.plugins = new ArrayList();
        }

        public IPath getPath() {
            return this.path;
        }

        public URL getURL() throws MalformedURLException {
            return new URL("file:" + this.path.addTrailingSeparator().toString());
        }

        public void add(IPluginModelBase model) {
            this.plugins.add(model);
        }

        public String[] getRelativePluginList() {
            String[] list = new String[this.plugins.size()];
            int i = 0;
            while (i < this.plugins.size()) {
                IPluginModelBase model = (IPluginModelBase)this.plugins.get(i);
                IPath location = TargetPlatform.getPluginLocation(model);
                location = location.append(model.isFragmentModel() ? "fragment.xml" : "plugin.xml");
                IPath relative = location.removeFirstSegments(location.segmentCount() - 3);
                list[i] = relative.setDevice(null).makeRelative().toString();
                ++i;
            }
            return list;
        }
    }
}

