/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.Hashtable;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SourceDOMParser
extends DOMParser {
    private Hashtable lines = new Hashtable();
    boolean notSupported;
    private XMLLocator locator;

    public SourceDOMParser() {
        try {
            this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (Exception exception) {
            this.notSupported = true;
        }
    }

    public void reset() {
        super.reset();
        this.lines.clear();
    }

    public void startDocument(XMLLocator locator, String encoding, Augmentations augs) throws XNIException {
        super.startDocument(locator, encoding, augs);
        this.locator = locator;
    }

    public void startElement(QName element, XMLAttributes atts, Augmentations augs) throws XNIException {
        super.startElement(element, atts, augs);
        if (this.notSupported) {
            return;
        }
        try {
            Integer[] range = new Integer[2];
            range[0] = new Integer(this.locator.getLineNumber());
            Node elNode = (Node)this.getProperty("http://apache.org/xml/features/dom/current-element-node");
            if (elNode != null) {
                this.lines.put(elNode, range);
            }
        }
        catch (SAXException sAXException) {}
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this.notSupported) {
            return;
        }
        try {
            Integer[] range;
            Node elNode = (Node)this.getProperty("http://apache.org/xml/features/dom/current-element-node");
            if (elNode != null && (range = (Integer[])this.lines.get(elNode)) != null) {
                Integer endValue;
                range[1] = endValue = new Integer(this.locator.getLineNumber());
            }
        }
        catch (SAXException sAXException) {}
        super.endElement(element, augs);
    }

    public Hashtable getLineTable() {
        return this.lines;
    }
}

