/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;

public class SourceAttachmentManager {
    private Hashtable entries = new Hashtable();
    private static final String KEY_PLATFORM_PATH = "platform-path";

    public SourceAttachmentManager() {
        this.initialize();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public SourceAttachmentEntry findEntry(IPath entryPath) {
        return (SourceAttachmentEntry)this.entries.get(entryPath);
    }

    public void addEntry(IPath libraryPath, IPath attachmentPath, IPath attachmentRootPath) {
        this.entries.put(libraryPath, new SourceAttachmentEntry(libraryPath, attachmentPath, attachmentRootPath));
    }

    private String getFileName() {
        IPath stateLocation = PDECore.getDefault().getStateLocation();
        IPath stateFile = stateLocation.append("sourceAttachements.properties");
        return stateFile.toOSString();
    }

    private void initialize() {
        String fileName = this.getFileName();
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(fileName);
            properties.load(fis);
            this.parseProperties(properties);
            fis.close();
        }
        catch (IOException iOException) {}
    }

    private void parseProperties(Properties properties) {
        String platformPath = properties.getProperty(KEY_PLATFORM_PATH);
        if (platformPath == null) {
            return;
        }
        Path oldPlatformPath = new Path(platformPath);
        IPath currentPlatformPath = ExternalModelManager.getEclipseHome(null);
        if (!oldPlatformPath.equals((Object)currentPlatformPath)) {
            return;
        }
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith("entry.")) continue;
            this.parseEntryProperty(properties.getProperty(key));
        }
    }

    private void parseEntryProperty(String value) {
        String att;
        int semi = value.indexOf(59);
        String library = value.substring(0, semi);
        String paths = value.substring(semi + 1);
        semi = paths.indexOf(";");
        String attRoot = null;
        if (semi != -1) {
            att = paths.substring(0, semi);
            attRoot = paths.substring(semi + 1);
        } else {
            att = paths;
        }
        this.addEntry((IPath)new Path(library), (IPath)new Path(att), (IPath)(attRoot != null ? new Path(attRoot) : null));
    }

    public void save() {
        String fileName = this.getFileName();
        Properties properties = new Properties();
        IPath platformPath = ExternalModelManager.getEclipseHome(null);
        properties.setProperty(KEY_PLATFORM_PATH, platformPath.toOSString());
        int i = 0;
        Enumeration enumeration = this.entries.keys();
        while (enumeration.hasMoreElements()) {
            IPath entryPath = (IPath)enumeration.nextElement();
            SourceAttachmentEntry entry = (SourceAttachmentEntry)this.entries.get(entryPath);
            String library = entry.getEntryPath().toOSString();
            String value = entry.getAttachmentRootPath() != null ? String.valueOf(library) + ";" + entry.getAttachmentPath().toOSString() + ";" + entry.getAttachmentRootPath().toOSString() : String.valueOf(library) + ";" + entry.getAttachmentPath().toOSString();
            properties.setProperty("entry." + ++i, value);
        }
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            properties.store(fos, "User-defined source attachments");
            fos.flush();
            fos.close();
        }
        catch (IOException iOException) {}
    }

    public static class SourceAttachmentEntry {
        private IPath entryPath;
        private IPath attachmentPath;
        private IPath attachmentRootPath;

        public SourceAttachmentEntry(IPath entryPath, IPath attachmentPath, IPath attachmentRootPath) {
            this.entryPath = entryPath;
            this.attachmentPath = attachmentPath;
            this.attachmentRootPath = attachmentRootPath;
        }

        public IPath getEntryPath() {
            return this.entryPath;
        }

        public IPath getAttachmentPath() {
            return this.attachmentPath;
        }

        public IPath getAttachmentRootPath() {
            return this.attachmentRootPath;
        }
    }
}

