/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;
import org.eclipse.pde.internal.core.TargetPlatformRegistryLoader;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;

public class RegistryLoader {
    public static MultiStatus loadFromDirectories(Vector result, Vector fresult, String[] pluginPaths, boolean resolve, boolean useCache, IProgressMonitor monitor) {
        try {
            URL[] urls = new URL[pluginPaths.length];
            int i = 0;
            while (i < pluginPaths.length) {
                urls[i] = new URL("file:" + pluginPaths[i].replace('\\', '/') + "/");
                ++i;
            }
            TargetPlatformRegistryLoader loader = new TargetPlatformRegistryLoader();
            monitor.beginTask("", 6);
            MultiStatus errors = loader.load(urls, resolve, useCache, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            PluginRegistryModel registryModel = loader.getRegistry();
            RegistryLoader.processPluginModel(result, (PluginModel[])registryModel.getPlugins(), false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            RegistryLoader.processPluginModel(fresult, (PluginModel[])registryModel.getFragments(), true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            return errors;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static void processPluginModel(Vector result, PluginModel[] models, boolean isFragment, IProgressMonitor monitor) {
        monitor.beginTask("", models.length);
        int i = 0;
        while (i < models.length) {
            ExternalPluginModelBase model = null;
            model = isFragment ? new ExternalFragmentModel() : new ExternalPluginModel();
            String location = models[i].getLocation();
            try {
                String localLocation = new URL(location).getFile();
                IPath path = new Path(localLocation).removeTrailingSeparator();
                model.setInstallLocation(path.toOSString());
                model.getPluginBase();
            }
            catch (MalformedURLException malformedURLException) {
                model.setInstallLocation(location);
            }
            model.load(models[i]);
            if (model.isLoaded()) {
                result.add(model);
                model.getPluginBase();
            }
            monitor.worked(1);
            ++i;
        }
        monitor.done();
    }

    public static void reloadFromLive(Vector result, Vector fresult, IProgressMonitor monitor) {
        PluginRegistryModel registryModel = (PluginRegistryModel)Platform.getPluginRegistry();
        PluginDescriptorModel[] plugins = registryModel.getPlugins();
        PluginFragmentModel[] fragments = registryModel.getFragments();
        monitor.beginTask("", plugins.length + fragments.length);
        RegistryLoader.processPluginModel(result, (PluginModel[])plugins, false, monitor);
        RegistryLoader.processPluginModel(fresult, (PluginModel[])fragments, true, monitor);
    }

    public static void reload(String[] pluginPaths, Vector result, Vector fresult, IProgressMonitor monitor) {
        MultiStatus errors = RegistryLoader.loadFromDirectories(result, fresult, pluginPaths, true, true, monitor);
        if (errors != null && errors.getChildren().length > 0) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)errors);
        }
    }
}

