/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.IFileAdapterFactory;
import org.eclipse.pde.internal.core.IModelProviderEvent;
import org.eclipse.pde.internal.core.IModelProviderListener;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.pde.internal.core.WorkspaceModelManager;

public class PluginModelManager
implements IAdaptable {
    private IModelProviderListener providerListener = new IModelProviderListener(){

        public void modelsChanged(IModelProviderEvent e) {
            if (PluginModelManager.this.entries != null) {
                PluginModelManager.this.handleModelsChanged(e);
            }
        }
    };
    private ExternalModelManager externalManager;
    private WorkspaceModelManager workspaceManager;
    private SearchablePluginsManager searchablePluginsManager;
    private ArrayList listeners = new ArrayList();
    private Hashtable entries;

    public PluginModelManager() {
        this.searchablePluginsManager = new SearchablePluginsManager(this);
    }

    public Object getAdapter(Class key) {
        return null;
    }

    public void addPluginModelListener(IPluginModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePluginModelListener(IPluginModelListener listener) {
        if (this.listeners.contains(listener)) {
            ((AbstractCollection)this.listeners).remove(listener);
        }
    }

    public boolean isEmpty() {
        if (this.entries == null) {
            this.initializeTable();
        }
        return this.entries.isEmpty();
    }

    public ModelEntry[] getEntries() {
        if (this.entries == null) {
            this.initializeTable();
        }
        Collection values = this.entries.values();
        return values.toArray(new ModelEntry[values.size()]);
    }

    public IPluginModelBase[] getPlugins() {
        if (this.entries == null) {
            this.initializeTable();
        }
        Collection values = this.entries.values();
        IPluginModelBase[] plugins = new IPluginModelBase[values.size()];
        int i = 0;
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            ModelEntry entry = (ModelEntry)((Object)iter.next());
            plugins[i++] = entry.getActiveModel();
        }
        return plugins;
    }

    public ModelEntry findEntry(IProject project) {
        IModel model;
        if (this.entries == null) {
            this.initializeTable();
        }
        if ((model = this.workspaceManager.getWorkspaceModel(project)) == null) {
            return null;
        }
        if (!(model instanceof IPluginModelBase)) {
            return null;
        }
        IPluginModelBase modelBase = (IPluginModelBase)model;
        String id = modelBase.getPluginBase().getId();
        return (ModelEntry)((Object)this.entries.get(id));
    }

    public ModelEntry findEntry(String id, String version) {
        if (this.entries == null) {
            this.initializeTable();
        }
        return (ModelEntry)((Object)this.entries.get(id));
    }

    public ModelEntry findEntry(String id, String version, int match) {
        if (this.entries == null) {
            this.initializeTable();
        }
        return (ModelEntry)((Object)this.entries.get(id));
    }

    public IPluginModelBase findPlugin(String id, String version, int match) {
        ModelEntry entry = this.findEntry(id, version, match);
        if (entry == null) {
            return null;
        }
        return entry.getActiveModel();
    }

    private void handleModelsChanged(IModelProviderEvent e) {
        IPluginBase plugin;
        IPluginModelBase model;
        int i;
        PluginModelDelta delta = new PluginModelDelta();
        ArrayList<IPluginBase> changedPlugins = new ArrayList<IPluginBase>();
        if ((e.getEventTypes() & 2) != 0) {
            IModel[] removed = e.getRemovedModels();
            i = 0;
            while (i < removed.length) {
                if (removed[i] instanceof IPluginModelBase) {
                    model = (IPluginModelBase)removed[i];
                    plugin = model.getPluginBase();
                    this.updateTable(plugin.getId(), model, false, delta);
                    changedPlugins.add(plugin);
                }
                ++i;
            }
        }
        if ((e.getEventTypes() & 1) != 0) {
            IModel[] added = e.getAddedModels();
            i = 0;
            while (i < added.length) {
                if (added[i] instanceof IPluginModelBase) {
                    model = (IPluginModelBase)added[i];
                    plugin = model.getPluginBase();
                    this.updateTable(plugin.getId(), model, true, delta);
                    changedPlugins.add(plugin);
                }
                ++i;
            }
        }
        if ((e.getEventTypes() & 4) != 0) {
            IModel[] changed = e.getChangedModels();
            i = 0;
            while (i < changed.length) {
                if (changed[i] instanceof IPluginModelBase) {
                    model = (IPluginModelBase)changed[i];
                    plugin = model.getPluginBase();
                    ModelEntry entry = (ModelEntry)((Object)this.entries.get(plugin.getId()));
                    delta.addEntry(entry, 4);
                    changedPlugins.add(plugin);
                }
                ++i;
            }
        }
        this.updateAffectedEntries(changedPlugins.toArray(new IPluginBase[changedPlugins.size()]));
        this.fireDelta(delta);
    }

    private void updateTable(String id, IPluginModelBase model, boolean added, PluginModelDelta delta) {
        boolean workspace;
        boolean bl = workspace = model.getUnderlyingResource() != null;
        if (id == null) {
            return;
        }
        ModelEntry entry = (ModelEntry)((Object)this.entries.get(id));
        int kind = 0;
        if (added && entry == null) {
            entry = new ModelEntry(this, id);
            this.entries.put(id, entry);
            kind = 1;
            try {
                entry.updateClasspathContainer(false);
            }
            catch (CoreException coreException) {}
        }
        if (added) {
            if (workspace) {
                entry.setWorkspaceModel(model);
            } else {
                entry.setExternalModel(model);
            }
        } else if (entry != null) {
            if (workspace) {
                entry.setWorkspaceModel(null);
            } else {
                entry.setExternalModel(null);
            }
            if (entry.isEmpty()) {
                this.entries.remove(id);
                kind = 2;
            }
        }
        if (kind == 0) {
            kind = 4;
        }
        delta.addEntry(entry, kind);
    }

    private void updateAffectedEntries(IPluginBase[] changedPlugins) {
        ModelEntry[] entries = this.getEntries();
        int i = 0;
        while (i < entries.length) {
            ModelEntry entry = entries[i];
            if (entry.isAffected(changedPlugins)) {
                try {
                    entry.updateClasspathContainer(true);
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
    }

    private void initializeTable() {
        this.entries = new Hashtable();
        IPluginModel[] models = this.workspaceManager.getWorkspacePluginModels();
        IFragmentModel[] fmodels = this.workspaceManager.getWorkspaceFragmentModels();
        this.addToTable(models, fmodels, true);
        models = this.externalManager.getModels();
        fmodels = this.externalManager.getFragmentModels();
        this.addToTable(models, fmodels, false);
        this.searchablePluginsManager.initialize();
    }

    private void addToTable(IPluginModel[] pmodels, IFragmentModel[] fmodels, boolean workspace) {
        int i = 0;
        while (i < pmodels.length) {
            this.addToTable(pmodels[i], workspace);
            ++i;
        }
        i = 0;
        while (i < fmodels.length) {
            this.addToTable(fmodels[i], workspace);
            ++i;
        }
    }

    private void addToTable(IPluginModelBase model, boolean workspace) {
        String id = model.getPluginBase().getId();
        if (id == null) {
            return;
        }
        ModelEntry entry = (ModelEntry)((Object)this.entries.get(id));
        if (entry == null) {
            entry = new ModelEntry(this, id);
            this.entries.put(id, entry);
        }
        if (workspace) {
            entry.setWorkspaceModel(model);
        } else {
            entry.setExternalModel(model);
        }
    }

    private void fireDelta(PluginModelDelta delta) {
        Object[] entries = this.listeners.toArray();
        int i = 0;
        while (i < entries.length) {
            ((IPluginModelListener)entries[i]).modelsChanged(delta);
            ++i;
        }
    }

    public void connect(WorkspaceModelManager wm, ExternalModelManager em) {
        this.externalManager = em;
        this.workspaceManager = wm;
        this.externalManager.addModelProviderListener(this.providerListener);
        this.workspaceManager.addModelProviderListener(this.providerListener);
    }

    public void shutdown() {
        if (this.workspaceManager != null) {
            this.workspaceManager.removeModelProviderListener(this.providerListener);
        }
        if (this.externalManager != null) {
            this.externalManager.removeModelProviderListener(this.providerListener);
        }
        this.searchablePluginsManager.shutdown();
    }

    public void setInJavaSearch(ModelEntry[] entries, boolean value, boolean useContainers, IProgressMonitor monitor) throws CoreException {
        PluginModelDelta delta = new PluginModelDelta();
        int i = 0;
        while (i < entries.length) {
            ModelEntry entry = entries[i];
            if (entry.isInJavaSearch() != value) {
                entry.setInJavaSearch(value);
                delta.addEntry(entry, 4);
            }
            ++i;
        }
        if (delta.getKind() != 0) {
            this.searchablePluginsManager.persistStates(useContainers, monitor);
            this.fireDelta(delta);
        }
    }

    void searchablePluginsRemoved() {
        ModelEntry[] entries = this.getEntries();
        PluginModelDelta delta = new PluginModelDelta();
        int i = 0;
        while (i < entries.length) {
            ModelEntry entry = entries[i];
            if (entry.isInJavaSearch()) {
                entry.setInJavaSearch(false);
                delta.addEntry(entry, 4);
            }
            ++i;
        }
        if (delta.getKind() != 0) {
            this.fireDelta(delta);
        }
    }

    public IFileAdapterFactory getFileAdapterFactory() {
        return this.searchablePluginsManager;
    }
}

