/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.model.ConfigurationElementModel;
import org.eclipse.core.runtime.model.ConfigurationPropertyModel;
import org.eclipse.core.runtime.model.ExtensionModel;
import org.eclipse.core.runtime.model.ExtensionPointModel;
import org.eclipse.core.runtime.model.LibraryModel;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;

public class PDERegistryCacheWriter {
    HashMap objectTable = null;
    private long code = 0L;
    public static final boolean DEBUG_REGISTRY_CACHE = false;

    public PDERegistryCacheWriter(long code) {
        this.code = code;
    }

    private int addToObjectTable(Object object) {
        if (this.objectTable == null) {
            this.objectTable = new HashMap();
        }
        this.objectTable.put(object, new Integer(this.objectTable.size()));
        return this.objectTable.size() - 1;
    }

    private int getFromObjectTable(Object object) {
        Object objectResult;
        if (this.objectTable != null && (objectResult = this.objectTable.get(object)) != null) {
            return (Integer)objectResult;
        }
        return -1;
    }

    private void writeLabel(byte labelValue, DataOutputStream out) {
        try {
            out.writeByte(labelValue);
        }
        catch (IOException iOException) {}
    }

    public void writeConfigurationElement(ConfigurationElementModel configElement, DataOutputStream out) {
        try {
            ConfigurationElementModel[] subElements;
            ConfigurationPropertyModel[] properties;
            int configElementIndex = this.getFromObjectTable(configElement);
            if (configElementIndex != -1) {
                this.writeLabel((byte)45, out);
                out.writeInt(configElementIndex);
                return;
            }
            this.addToObjectTable(configElement);
            this.writeLabel((byte)2, out);
            this.writeLabel((byte)33, out);
            out.writeBoolean(configElement.isReadOnly());
            this.writeLabel((byte)59, out);
            out.writeInt(configElement.getStartLine());
            String outString = configElement.getName();
            if (outString != null) {
                this.writeLabel((byte)19, out);
                out.writeUTF(outString);
            }
            if ((outString = configElement.getValue()) != null) {
                this.writeLabel((byte)43, out);
                out.writeUTF(outString);
            }
            if ((properties = configElement.getProperties()) != null) {
                this.writeLabel((byte)32, out);
                out.writeInt(properties.length);
                int i = 0;
                while (i < properties.length) {
                    this.writeConfigurationProperty(properties[i], out);
                    ++i;
                }
            }
            if ((subElements = configElement.getSubElements()) != null) {
                this.writeLabel((byte)42, out);
                out.writeInt(subElements.length);
                int i = 0;
                while (i < subElements.length) {
                    this.writeConfigurationElement(subElements[i], out);
                    ++i;
                }
            }
            Object parent = configElement.getParent();
            this.writeLabel((byte)3, out);
            out.writeInt(this.getFromObjectTable(parent));
            this.writeLabel((byte)1, out);
        }
        catch (IOException iOException) {}
    }

    public void writeConfigurationProperty(ConfigurationPropertyModel configProperty, DataOutputStream out) {
        try {
            this.writeLabel((byte)5, out);
            this.writeLabel((byte)33, out);
            out.writeBoolean(configProperty.isReadOnly());
            this.writeLabel((byte)59, out);
            out.writeInt(configProperty.getStartLine());
            String outString = configProperty.getName();
            if (outString != null) {
                this.writeLabel((byte)19, out);
                out.writeUTF(outString);
            }
            if ((outString = configProperty.getValue()) != null) {
                this.writeLabel((byte)43, out);
                out.writeUTF(outString);
            }
            this.writeLabel((byte)4, out);
        }
        catch (IOException iOException) {}
    }

    public void writeExtension(ExtensionModel extension, DataOutputStream out) {
        try {
            ConfigurationElementModel[] subElements;
            int extensionIndex = this.getFromObjectTable(extension);
            if (extensionIndex != -1) {
                this.writeLabel((byte)8, out);
                out.writeInt(extensionIndex);
                return;
            }
            this.addToObjectTable(extension);
            this.writeLabel((byte)23, out);
            this.writeLabel((byte)33, out);
            out.writeBoolean(extension.isReadOnly());
            this.writeLabel((byte)59, out);
            out.writeInt(extension.getStartLine());
            String outString = extension.getName();
            if (outString != null) {
                this.writeLabel((byte)19, out);
                out.writeUTF(outString);
            }
            if ((outString = extension.getExtensionPoint()) != null) {
                this.writeLabel((byte)7, out);
                out.writeUTF(outString);
            }
            if ((outString = extension.getId()) != null) {
                this.writeLabel((byte)15, out);
                out.writeUTF(outString);
            }
            if ((subElements = extension.getSubElements()) != null) {
                this.writeLabel((byte)42, out);
                out.writeInt(subElements.length);
                int i = 0;
                while (i < subElements.length) {
                    this.writeConfigurationElement(subElements[i], out);
                    ++i;
                }
            }
            PluginModel parent = extension.getParent();
            int parentIndex = this.getFromObjectTable(parent);
            this.writeLabel((byte)9, out);
            if (parentIndex != -1) {
                if (parent instanceof PluginDescriptorModel) {
                    this.writeLabel((byte)25, out);
                } else {
                    this.writeLabel((byte)47, out);
                }
                out.writeInt(parentIndex);
            } else if (parent instanceof PluginDescriptorModel) {
                this.writePluginDescriptor((PluginDescriptorModel)parent, out);
            } else {
                this.writePluginFragment((PluginFragmentModel)parent, out);
            }
            this.writeLabel((byte)6, out);
        }
        catch (IOException iOException) {}
    }

    public void writeExtensionPoint(ExtensionPointModel extPoint, DataOutputStream out) {
        try {
            ExtensionModel[] extensions;
            int extLength;
            int parentIndex;
            PluginModel parent;
            int extensionPointIndex = this.getFromObjectTable(extPoint);
            if (extensionPointIndex != -1) {
                this.writeLabel((byte)56, out);
                out.writeInt(extensionPointIndex);
                return;
            }
            this.addToObjectTable(extPoint);
            this.writeLabel((byte)24, out);
            this.writeLabel((byte)33, out);
            out.writeBoolean(extPoint.isReadOnly());
            this.writeLabel((byte)59, out);
            out.writeInt(extPoint.getStartLine());
            String outString = extPoint.getName();
            if (outString != null) {
                this.writeLabel((byte)19, out);
                out.writeUTF(outString);
            }
            if ((outString = extPoint.getId()) != null) {
                this.writeLabel((byte)15, out);
                out.writeUTF(outString);
            }
            if ((outString = extPoint.getSchema()) != null) {
                this.writeLabel((byte)14, out);
                out.writeUTF(outString);
            }
            if ((parent = extPoint.getParent()) != null && (parentIndex = this.getFromObjectTable(parent)) != -1) {
                this.writeLabel((byte)13, out);
                out.writeInt(parentIndex);
            }
            int n = extLength = (extensions = extPoint.getDeclaredExtensions()) == null ? 0 : extensions.length;
            if (extLength != 0) {
                this.writeLabel((byte)11, out);
                out.writeInt(extLength);
                this.writeLabel((byte)12, out);
                int i = 0;
                while (i < extLength) {
                    int extensionIndex = this.getFromObjectTable(extensions[i]);
                    if (extensionIndex != -1) {
                        this.writeLabel((byte)8, out);
                        out.writeInt(extensionIndex);
                    } else {
                        this.writeExtension(extensions[i], out);
                    }
                    ++i;
                }
            }
            this.writeLabel((byte)10, out);
        }
        catch (IOException iOException) {}
    }

    public void writeHeaderInformation(DataOutputStream out) {
        try {
            out.writeLong(this.code);
        }
        catch (IOException iOException) {}
    }

    public void writeLibrary(LibraryModel library, DataOutputStream out) {
        try {
            String[] prefixes;
            int libraryIndex = this.getFromObjectTable(library);
            if (libraryIndex != -1) {
                this.writeLabel((byte)57, out);
                out.writeInt(libraryIndex);
                return;
            }
            this.addToObjectTable(library);
            this.writeLabel((byte)28, out);
            this.writeLabel((byte)33, out);
            out.writeBoolean(library.isReadOnly());
            this.writeLabel((byte)59, out);
            out.writeInt(library.getStartLine());
            String outString = library.getName();
            if (outString != null) {
                this.writeLabel((byte)19, out);
                out.writeUTF(outString);
            }
            if ((outString = library.getType()) != null) {
                this.writeLabel((byte)54, out);
                out.writeUTF(outString);
            }
            String[] exports = null;
            exports = library.getExports();
            if (exports != null) {
                this.writeLabel((byte)18, out);
                out.writeInt(exports.length);
                this.writeLabel((byte)17, out);
                int i = 0;
                while (i < exports.length) {
                    out.writeUTF(exports[i]);
                    ++i;
                }
            }
            if ((prefixes = library.getPackagePrefixes()) != null) {
                this.writeLabel((byte)60, out);
                out.writeInt(prefixes.length);
                this.writeLabel((byte)61, out);
                int i = 0;
                while (i < prefixes.length) {
                    out.writeUTF(prefixes[i]);
                    ++i;
                }
            }
            this.writeLabel((byte)16, out);
        }
        catch (IOException iOException) {}
    }

    public void writePluginDescriptor(PluginDescriptorModel plugin, DataOutputStream out) {
        try {
            PluginFragmentModel[] fragments;
            int fragmentSize;
            ExtensionModel[] extensions;
            int extSize;
            ExtensionPointModel[] extensionPoints;
            int extPointsSize;
            LibraryModel[] runtime;
            int runtimeSize;
            int reqSize;
            int pluginIndex = this.getFromObjectTable(plugin);
            if (pluginIndex != -1) {
                this.writeLabel((byte)25, out);
                out.writeInt(pluginIndex);
                return;
            }
            this.addToObjectTable(plugin);
            this.writeLabel((byte)26, out);
            this.writeLabel((byte)33, out);
            out.writeBoolean(plugin.isReadOnly());
            this.writeLabel((byte)59, out);
            out.writeInt(plugin.getStartLine());
            String outString = plugin.getName();
            if (outString != null) {
                this.writeLabel((byte)19, out);
                out.writeUTF(outString);
            }
            if ((outString = plugin.getId()) != null) {
                this.writeLabel((byte)15, out);
                out.writeUTF(outString);
            }
            if ((outString = plugin.getProviderName()) != null) {
                this.writeLabel((byte)30, out);
                out.writeUTF(outString);
            }
            if ((outString = plugin.getVersion()) != null) {
                this.writeLabel((byte)44, out);
                out.writeUTF(outString);
            }
            if ((outString = plugin.getPluginClass()) != null) {
                this.writeLabel((byte)20, out);
                out.writeUTF(outString);
            }
            if ((outString = plugin.getLocation()) != null) {
                this.writeLabel((byte)27, out);
                out.writeUTF(outString);
            }
            this.writeLabel((byte)21, out);
            out.writeBoolean(plugin.getEnabled());
            PluginPrerequisiteModel[] requires = plugin.getRequires();
            int n = reqSize = requires == null ? 0 : requires.length;
            if (reqSize != 0) {
                int i = 0;
                while (i < reqSize) {
                    this.writePluginPrerequisite(requires[i], out);
                    ++i;
                }
            }
            int n2 = runtimeSize = (runtime = plugin.getRuntime()) == null ? 0 : runtime.length;
            if (runtimeSize != 0) {
                int i = 0;
                while (i < runtimeSize) {
                    this.writeLibrary(runtime[i], out);
                    ++i;
                }
            }
            int n3 = extPointsSize = (extensionPoints = plugin.getDeclaredExtensionPoints()) == null ? 0 : extensionPoints.length;
            if (extPointsSize != 0) {
                int i = 0;
                while (i < extPointsSize) {
                    this.writeExtensionPoint(extensionPoints[i], out);
                    ++i;
                }
            }
            int n4 = extSize = (extensions = plugin.getDeclaredExtensions()) == null ? 0 : extensions.length;
            if (extSize != 0) {
                int i = 0;
                while (i < extSize) {
                    this.writeExtension(extensions[i], out);
                    ++i;
                }
            }
            int n5 = fragmentSize = (fragments = plugin.getFragments()) == null ? 0 : fragments.length;
            if (fragmentSize != 0) {
                int i = 0;
                while (i < fragmentSize) {
                    this.writePluginFragment(fragments[i], out);
                    ++i;
                }
            }
            PluginRegistryModel parentRegistry = plugin.getRegistry();
            this.writeLabel((byte)29, out);
            out.writeInt(this.getFromObjectTable(parentRegistry));
            this.writeLabel((byte)22, out);
        }
        catch (IOException iOException) {}
    }

    public void writePluginFragment(PluginFragmentModel fragment, DataOutputStream out) {
        try {
            ExtensionModel[] extensions;
            int extSize;
            ExtensionPointModel[] extensionPoints;
            int extPointsSize;
            LibraryModel[] runtime;
            int runtimeSize;
            PluginPrerequisiteModel[] requires;
            int reqSize;
            byte outByte;
            int fragmentIndex = this.getFromObjectTable(fragment);
            if (fragmentIndex != -1) {
                this.writeLabel((byte)47, out);
                out.writeInt(fragmentIndex);
                return;
            }
            this.addToObjectTable(fragment);
            this.writeLabel((byte)48, out);
            this.writeLabel((byte)33, out);
            out.writeBoolean(fragment.isReadOnly());
            this.writeLabel((byte)59, out);
            out.writeInt(fragment.getStartLine());
            String outString = fragment.getName();
            if (outString != null) {
                this.writeLabel((byte)19, out);
                out.writeUTF(outString);
            }
            if ((outString = fragment.getId()) != null) {
                this.writeLabel((byte)15, out);
                out.writeUTF(outString);
            }
            if ((outString = fragment.getProviderName()) != null) {
                this.writeLabel((byte)30, out);
                out.writeUTF(outString);
            }
            if ((outString = fragment.getVersion()) != null) {
                this.writeLabel((byte)44, out);
                out.writeUTF(outString);
            }
            if ((outString = fragment.getLocation()) != null) {
                this.writeLabel((byte)27, out);
                out.writeUTF(outString);
            }
            if ((outString = fragment.getPlugin()) != null) {
                this.writeLabel((byte)50, out);
                out.writeUTF(outString);
            }
            if ((outString = fragment.getPluginVersion()) != null) {
                this.writeLabel((byte)51, out);
                out.writeUTF(outString);
            }
            if ((outByte = fragment.getMatch()) != 0) {
                this.writeLabel((byte)55, out);
                out.writeByte(outByte);
            }
            int n = reqSize = (requires = fragment.getRequires()) == null ? 0 : requires.length;
            if (reqSize != 0) {
                int i = 0;
                while (i < reqSize) {
                    this.writePluginPrerequisite(requires[i], out);
                    ++i;
                }
            }
            int n2 = runtimeSize = (runtime = fragment.getRuntime()) == null ? 0 : runtime.length;
            if (runtimeSize != 0) {
                int i = 0;
                while (i < runtimeSize) {
                    this.writeLibrary(runtime[i], out);
                    ++i;
                }
            }
            int n3 = extPointsSize = (extensionPoints = fragment.getDeclaredExtensionPoints()) == null ? 0 : extensionPoints.length;
            if (extPointsSize != 0) {
                int i = 0;
                while (i < extPointsSize) {
                    this.writeExtensionPoint(extensionPoints[i], out);
                    ++i;
                }
            }
            int n4 = extSize = (extensions = fragment.getDeclaredExtensions()) == null ? 0 : extensions.length;
            if (extSize != 0) {
                int i = 0;
                while (i < extSize) {
                    this.writeExtension(extensions[i], out);
                    ++i;
                }
            }
            PluginRegistryModel parentRegistry = fragment.getRegistry();
            this.writeLabel((byte)29, out);
            out.writeInt(this.getFromObjectTable(parentRegistry));
            this.writeLabel((byte)49, out);
        }
        catch (IOException iOException) {}
    }

    public void writePluginPrerequisite(PluginPrerequisiteModel requires, DataOutputStream out) {
        try {
            byte outMatch;
            int requiresIndex = this.getFromObjectTable(requires);
            if (requiresIndex != -1) {
                this.writeLabel((byte)58, out);
                out.writeInt(requiresIndex);
                return;
            }
            this.addToObjectTable(requires);
            String outString = null;
            this.writeLabel((byte)31, out);
            this.writeLabel((byte)33, out);
            out.writeBoolean(requires.isReadOnly());
            this.writeLabel((byte)59, out);
            out.writeInt(requires.getStartLine());
            outString = requires.getName();
            if (outString != null) {
                this.writeLabel((byte)19, out);
                out.writeUTF(outString);
            }
            if ((outString = requires.getVersion()) != null) {
                this.writeLabel((byte)44, out);
                out.writeUTF(outString);
            }
            if ((outMatch = requires.getMatchByte()) != 0) {
                this.writeLabel((byte)39, out);
                out.writeByte(requires.getMatchByte());
            }
            this.writeLabel((byte)38, out);
            out.writeBoolean(requires.getExport());
            this.writeLabel((byte)52, out);
            out.writeBoolean(requires.getOptional());
            outString = requires.getResolvedVersion();
            if (outString != null) {
                this.writeLabel((byte)41, out);
                out.writeUTF(outString);
            }
            if ((outString = requires.getPlugin()) != null) {
                this.writeLabel((byte)40, out);
                out.writeUTF(outString);
            }
            this.writeLabel((byte)37, out);
        }
        catch (IOException iOException) {}
    }

    public void writePluginRegistry(PluginRegistryModel registry, DataOutputStream out) {
        try {
            int registryIndex;
            if (this.objectTable != null && (registryIndex = this.getFromObjectTable(registry)) != -1) {
                this.writeLabel((byte)46, out);
                out.writeInt(registryIndex);
                return;
            }
            this.addToObjectTable(registry);
            this.writeHeaderInformation(out);
            this.writeLabel((byte)35, out);
            this.writeLabel((byte)33, out);
            out.writeBoolean(registry.isReadOnly());
            this.writeLabel((byte)36, out);
            out.writeBoolean(registry.isResolved());
            PluginDescriptorModel[] pluginList = registry.getPlugins();
            int i = 0;
            while (i < pluginList.length) {
                this.writePluginDescriptor(pluginList[i], out);
                ++i;
            }
            PluginFragmentModel[] fragmentList = registry.getFragments();
            int fragmentLength = fragmentList == null ? 0 : fragmentList.length;
            int i2 = 0;
            while (i2 < fragmentLength) {
                this.writePluginFragment(fragmentList[i2], out);
                ++i2;
            }
            this.writeLabel((byte)34, out);
        }
        catch (IOException iOException) {}
    }
}

