/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.model.ConfigurationElementModel;
import org.eclipse.core.runtime.model.ConfigurationPropertyModel;
import org.eclipse.core.runtime.model.ExtensionModel;
import org.eclipse.core.runtime.model.ExtensionPointModel;
import org.eclipse.core.runtime.model.Factory;
import org.eclipse.core.runtime.model.LibraryModel;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;

public class PDERegistryCacheReader {
    Factory cacheFactory;
    ArrayList objectTable = null;
    public static final byte REGISTRY_CACHE_VERSION = 10;
    public static final byte NONLABEL = 0;
    public static final byte CONFIGURATION_ELEMENT_END_LABEL = 1;
    public static final byte CONFIGURATION_ELEMENT_INDEX_LABEL = 45;
    public static final byte CONFIGURATION_ELEMENT_LABEL = 2;
    public static final byte CONFIGURATION_ELEMENT_PARENT_LABEL = 3;
    public static final byte CONFIGURATION_PROPERTY_END_LABEL = 4;
    public static final byte CONFIGURATION_PROPERTY_LABEL = 5;
    public static final byte EXTENSION_END_LABEL = 6;
    public static final byte EXTENSION_EXT_POINT_NAME_LABEL = 7;
    public static final byte EXTENSION_INDEX_LABEL = 8;
    public static final byte EXTENSION_PARENT_LABEL = 9;
    public static final byte EXTENSION_POINT_END_LABEL = 10;
    public static final byte EXTENSION_POINT_EXTENSIONS_LENGTH_LABEL = 11;
    public static final byte EXTENSION_POINT_EXTENSIONS_LABEL = 12;
    public static final byte EXTENSION_POINT_PARENT_LABEL = 13;
    public static final byte EXTENSION_POINT_SCHEMA_LABEL = 14;
    public static final byte EXTENSION_POINT_INDEX_LABEL = 56;
    public static final byte FRAGMENT_INDEX_LABEL = 47;
    public static final byte FRAGMENT_LABEL = 48;
    public static final byte FRAGMENT_END_LABEL = 49;
    public static final byte FRAGMENT_PLUGIN_LABEL = 50;
    public static final byte FRAGMENT_PLUGIN_VERSION_LABEL = 51;
    public static final byte FRAGMENT_PLUGIN_MATCH_LABEL = 55;
    public static final byte ID_LABEL = 15;
    public static final byte LIBRARY_END_LABEL = 16;
    public static final byte LIBRARY_EXPORTS_LABEL = 17;
    public static final byte LIBRARY_EXPORTS_LENGTH_LABEL = 18;
    public static final byte LIBRARY_PACKAGES_PREFIXES_LENGTH_LABEL = 60;
    public static final byte LIBRARY_PACKAGES_PREFIXES_LABEL = 61;
    public static final byte NAME_LABEL = 19;
    public static final byte LIBRARY_INDEX_LABEL = 57;
    public static final byte START_LINE = 59;
    public static final byte PLUGIN_CLASS_LABEL = 20;
    public static final byte PLUGIN_ENABLED_LABEL = 21;
    public static final byte PLUGIN_END_LABEL = 22;
    public static final byte PLUGIN_EXTENSION_LABEL = 23;
    public static final byte PLUGIN_EXTENSION_POINT_LABEL = 24;
    public static final byte PLUGIN_INDEX_LABEL = 25;
    public static final byte PLUGIN_LABEL = 26;
    public static final byte PLUGIN_LOCATION_LABEL = 27;
    public static final byte PLUGIN_LIBRARY_LABEL = 28;
    public static final byte PLUGIN_PARENT_LABEL = 29;
    public static final byte PLUGIN_PROVIDER_NAME_LABEL = 30;
    public static final byte PLUGIN_REQUIRES_LABEL = 31;
    public static final byte PROPERTIES_LENGTH_LABEL = 32;
    public static final byte READONLY_LABEL = 33;
    public static final byte REGISTRY_END_LABEL = 34;
    public static final byte REGISTRY_INDEX_LABEL = 46;
    public static final byte REGISTRY_LABEL = 35;
    public static final byte REGISTRY_RESOLVED_LABEL = 36;
    public static final byte REQUIRES_END_LABEL = 37;
    public static final byte REQUIRES_EXPORT_LABEL = 38;
    public static final byte REQUIRES_MATCH_LABEL = 39;
    public static final byte REQUIRES_OPTIONAL_LABEL = 52;
    public static final byte REQUIRES_PLUGIN_NAME_LABEL = 40;
    public static final byte REQUIRES_RESOLVED_VERSION_LABEL = 41;
    public static final byte REQUIRES_INDEX_LABEL = 58;
    public static final byte SOURCE_LABEL = 53;
    public static final byte SUBELEMENTS_LENGTH_LABEL = 42;
    public static final byte TYPE_LABEL = 54;
    public static final byte VALUE_LABEL = 43;
    public static final byte VERSION_LABEL = 44;
    public static final byte LARGEST_LABEL = 61;
    private static final String RESOLVED = "resolved";
    private static final String READONLY = "readonly";
    private static final String LOCATION = "location";
    private static final String ENABLED = "enabled";
    private static final String RESOLVED_VERSION = "resolved_version";
    private static final String END = "end";
    private static final String EXPORTS_LENGTH = "<length of export list>";
    private static final String SUBELEMENTS_LENGTH = "<length of subelement list>";
    private static final String PROPERTIES_LENGTH = "<length of properties list>";
    private static final String PARENT_REGISTRY = "<index of parent registry>";
    private static final String CONFIGURATION_ELEMENT_PARENT = "<index of element parent>";
    private static final String PLUGIN_INDEX = "<index of plugin>";
    private static final String EXTENSION_INDEX = "<index of extension>";
    private static final String EXT_PT_PARENT_INDEX = "<index of extension point parent>";
    private static final String EXT_PT_EXTENSION_LENGTH = "<length of extension list>";
    private static final String EXT_LIST = "<list of extensions>";
    private static final String EXTENSION_PARENT = "<index of extension parent>";
    private static final String ELEMENT_INDEX = "<index of element>";
    private static final String REGISTRY_INDEX = "<index of registry>";
    private static final String FRAGMENT_INDEX = "<index of fragment>";
    private static final String EXTENSION_POINT_INDEX = "<index of extension point>";
    private static final String LIBRARY_INDEX = "<index of library>";
    private static final String REQUIRES_INDEX = "<index of prerequisite>";
    private static final String UNKNOWN = "<unknown label>";
    private long code = 0L;

    public PDERegistryCacheReader(Factory factory, long code) {
        this.cacheFactory = factory;
        this.objectTable = null;
        this.code = code;
    }

    private int addToObjectTable(Object object) {
        if (this.objectTable == null) {
            this.objectTable = new ArrayList();
        }
        this.objectTable.add(object);
        return this.objectTable.size() - 1;
    }

    private void debug(String msg) {
        System.out.println("RegistryCacheReader: " + msg);
    }

    public static String decipherLabel(byte labelValue) {
        String retValue = "\"";
        switch (labelValue) {
            case 35: {
                retValue = String.valueOf(retValue) + "plugin-registry";
                break;
            }
            case 36: {
                retValue = String.valueOf(retValue) + RESOLVED;
                break;
            }
            case 26: {
                retValue = String.valueOf(retValue) + "plugin";
                break;
            }
            case 34: {
                retValue = String.valueOf(retValue) + "endplugin-registry";
                break;
            }
            case 33: {
                retValue = String.valueOf(retValue) + READONLY;
                break;
            }
            case 19: {
                retValue = String.valueOf(retValue) + "name";
                break;
            }
            case 15: {
                retValue = String.valueOf(retValue) + "id";
                break;
            }
            case 30: {
                retValue = String.valueOf(retValue) + "provider-name";
                break;
            }
            case 44: {
                retValue = String.valueOf(retValue) + "version";
                break;
            }
            case 20: {
                retValue = String.valueOf(retValue) + "class";
                break;
            }
            case 27: {
                retValue = String.valueOf(retValue) + LOCATION;
                break;
            }
            case 21: {
                retValue = String.valueOf(retValue) + ENABLED;
                break;
            }
            case 31: {
                retValue = String.valueOf(retValue) + "requires";
                break;
            }
            case 28: {
                retValue = String.valueOf(retValue) + "library";
                break;
            }
            case 23: {
                retValue = String.valueOf(retValue) + "extension";
                break;
            }
            case 24: {
                retValue = String.valueOf(retValue) + "extension-point";
                break;
            }
            case 22: {
                retValue = String.valueOf(retValue) + "endplugin";
                break;
            }
            case 39: {
                retValue = String.valueOf(retValue) + "match";
                break;
            }
            case 38: {
                retValue = String.valueOf(retValue) + "export";
                break;
            }
            case 41: {
                retValue = String.valueOf(retValue) + RESOLVED_VERSION;
                break;
            }
            case 40: {
                retValue = String.valueOf(retValue) + "plugin";
                break;
            }
            case 37: {
                retValue = String.valueOf(retValue) + "endrequires";
                break;
            }
            case 18: {
                retValue = String.valueOf(retValue) + EXPORTS_LENGTH;
                break;
            }
            case 17: {
                retValue = String.valueOf(retValue) + "export";
                break;
            }
            case 16: {
                retValue = String.valueOf(retValue) + "endlibrary";
                break;
            }
            case 14: {
                retValue = String.valueOf(retValue) + "schema";
                break;
            }
            case 10: {
                retValue = String.valueOf(retValue) + "endextension-point";
                break;
            }
            case 7: {
                retValue = String.valueOf(retValue) + "point";
                break;
            }
            case 42: {
                retValue = String.valueOf(retValue) + SUBELEMENTS_LENGTH;
                break;
            }
            case 6: {
                retValue = String.valueOf(retValue) + "endextension";
                break;
            }
            case 2: {
                retValue = String.valueOf(retValue) + "element";
                break;
            }
            case 43: {
                retValue = String.valueOf(retValue) + "value";
                break;
            }
            case 32: {
                retValue = String.valueOf(retValue) + PROPERTIES_LENGTH;
                break;
            }
            case 1: {
                retValue = String.valueOf(retValue) + "endelement";
                break;
            }
            case 5: {
                retValue = String.valueOf(retValue) + "property";
                break;
            }
            case 4: {
                retValue = String.valueOf(retValue) + "endproperty";
                break;
            }
            case 29: {
                retValue = String.valueOf(retValue) + PARENT_REGISTRY;
                break;
            }
            case 3: {
                retValue = String.valueOf(retValue) + CONFIGURATION_ELEMENT_PARENT;
                break;
            }
            case 25: {
                retValue = String.valueOf(retValue) + PLUGIN_INDEX;
                break;
            }
            case 8: {
                retValue = String.valueOf(retValue) + EXTENSION_INDEX;
                break;
            }
            case 13: {
                retValue = String.valueOf(retValue) + EXT_PT_PARENT_INDEX;
                break;
            }
            case 11: {
                retValue = String.valueOf(retValue) + EXT_PT_EXTENSION_LENGTH;
                break;
            }
            case 12: {
                retValue = String.valueOf(retValue) + EXT_LIST;
                break;
            }
            case 9: {
                retValue = String.valueOf(retValue) + EXTENSION_PARENT;
                break;
            }
            case 45: {
                retValue = String.valueOf(retValue) + ELEMENT_INDEX;
                break;
            }
            case 46: {
                retValue = String.valueOf(retValue) + REGISTRY_INDEX;
                break;
            }
            case 49: {
                retValue = String.valueOf(retValue) + "endfragment";
                break;
            }
            case 47: {
                retValue = String.valueOf(retValue) + FRAGMENT_INDEX;
                break;
            }
            case 48: {
                retValue = String.valueOf(retValue) + "fragment";
                break;
            }
            case 50: {
                retValue = String.valueOf(retValue) + "plugin-id";
                break;
            }
            case 55: {
                retValue = String.valueOf(retValue) + "match";
                break;
            }
            case 51: {
                retValue = String.valueOf(retValue) + "plugin-version";
                break;
            }
            case 52: {
                retValue = String.valueOf(retValue) + "optional";
                break;
            }
            case 53: {
                retValue = String.valueOf(retValue) + "source";
                break;
            }
            case 54: {
                retValue = String.valueOf(retValue) + "type";
                break;
            }
            case 56: {
                retValue = String.valueOf(retValue) + EXTENSION_POINT_INDEX;
                break;
            }
            case 57: {
                retValue = String.valueOf(retValue) + LIBRARY_INDEX;
                break;
            }
            case 58: {
                retValue = String.valueOf(retValue) + REQUIRES_INDEX;
                break;
            }
            default: {
                retValue = String.valueOf(retValue) + UNKNOWN;
            }
        }
        retValue = String.valueOf(retValue) + "\"";
        return retValue;
    }

    public boolean interpretHeaderInformation(DataInputStream in) {
        try {
            return in.readLong() == this.code;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public ConfigurationElementModel readConfigurationElement(DataInputStream in, boolean debugFlag) {
        ConfigurationElementModel configurationElement = this.cacheFactory.createConfigurationElement();
        this.addToObjectTable(configurationElement);
        try {
            byte inByte = 0;
            boolean done = false;
            while (!done) {
                try {
                    inByte = in.readByte();
                }
                catch (EOFException eOFException) {
                    done = true;
                    break;
                }
                switch (inByte) {
                    case 33: {
                        in.readBoolean();
                        break;
                    }
                    case 59: {
                        configurationElement.setStartLine(in.readInt());
                        break;
                    }
                    case 19: {
                        configurationElement.setName(in.readUTF());
                        break;
                    }
                    case 43: {
                        configurationElement.setValue(in.readUTF());
                        break;
                    }
                    case 32: {
                        int propertiesLength = in.readInt();
                        ConfigurationPropertyModel[] properties = new ConfigurationPropertyModel[propertiesLength];
                        int i = 0;
                        while (i < propertiesLength && !done) {
                            properties[i] = this.readConfigurationProperty(in, debugFlag);
                            if (properties[i] == null) {
                                if (debugFlag) {
                                    String name = configurationElement.getName();
                                    if (name == null) {
                                        name = new String("<unknown name>");
                                    }
                                    this.debug("Trouble reading configuration property #" + i + " for configuration element " + name);
                                }
                                configurationElement = null;
                                done = true;
                            }
                            ++i;
                        }
                        if (configurationElement != null) {
                            configurationElement.setProperties(properties);
                        }
                        properties = null;
                        break;
                    }
                    case 42: {
                        int subElementsLength = in.readInt();
                        ConfigurationElementModel[] subElements = new ConfigurationElementModel[subElementsLength];
                        int i = 0;
                        while (i < subElementsLength && !done) {
                            byte subInByte = in.readByte();
                            switch (subInByte) {
                                case 2: {
                                    String name;
                                    subElements[i] = this.readConfigurationElement(in, debugFlag);
                                    if (subElements[i] != null) break;
                                    if (debugFlag) {
                                        name = configurationElement.getName();
                                        if (name == null) {
                                            name = new String("<unknown name>");
                                        }
                                        this.debug("Unable to read subelement #" + i + " for configuration element " + name);
                                    }
                                    configurationElement = null;
                                    done = true;
                                    break;
                                }
                                case 45: {
                                    subElements[i] = (ConfigurationElementModel)this.objectTable.get(in.readInt());
                                    break;
                                }
                                default: {
                                    String name;
                                    if (debugFlag) {
                                        name = configurationElement.getName();
                                        if (name == null) {
                                            name = new String("<unknown name>");
                                        }
                                        this.debug("Unexpected byte code " + PDERegistryCacheReader.decipherLabel(subInByte) + "reading subelements of configuration element" + name);
                                    }
                                    done = true;
                                    configurationElement = null;
                                }
                            }
                            ++i;
                        }
                        if (configurationElement != null) {
                            configurationElement.setSubElements(subElements);
                        }
                        subElements = null;
                        break;
                    }
                    case 3: {
                        configurationElement.setParent(this.objectTable.get(in.readInt()));
                        break;
                    }
                    case 1: {
                        done = true;
                        break;
                    }
                    default: {
                        if (debugFlag) {
                            String name = configurationElement.getName();
                            if (name == null) {
                                name = new String("<unknown name>");
                            }
                            this.debug("Unexpected byte code " + PDERegistryCacheReader.decipherLabel(inByte) + "reading configuration element" + name);
                        }
                        done = true;
                        configurationElement = null;
                    }
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return configurationElement;
    }

    public ConfigurationPropertyModel readConfigurationProperty(DataInputStream in, boolean debugFlag) {
        ConfigurationPropertyModel configurationProperty = this.cacheFactory.createConfigurationProperty();
        try {
            byte inByte = 0;
            boolean done = false;
            while (!done) {
                try {
                    inByte = in.readByte();
                }
                catch (EOFException eOFException) {
                    done = true;
                    break;
                }
                switch (inByte) {
                    case 5: {
                        break;
                    }
                    case 33: {
                        in.readBoolean();
                        break;
                    }
                    case 59: {
                        configurationProperty.setStartLine(in.readInt());
                        break;
                    }
                    case 19: {
                        configurationProperty.setName(in.readUTF());
                        break;
                    }
                    case 43: {
                        configurationProperty.setValue(in.readUTF());
                        break;
                    }
                    case 4: {
                        done = true;
                        break;
                    }
                    default: {
                        if (debugFlag) {
                            String name = configurationProperty.getName();
                            if (name == null) {
                                name = new String("<unknown name>");
                            }
                            this.debug("Unexpected byte code " + PDERegistryCacheReader.decipherLabel(inByte) + " reading configuration property " + name);
                        }
                        configurationProperty = null;
                        done = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return configurationProperty;
    }

    public ExtensionModel readExtension(DataInputStream in, boolean debugFlag) {
        ExtensionModel extension = this.cacheFactory.createExtension();
        this.addToObjectTable(extension);
        try {
            byte inByte = 0;
            boolean done = false;
            while (!done) {
                try {
                    inByte = in.readByte();
                }
                catch (EOFException eOFException) {
                    done = true;
                    break;
                }
                block2 : switch (inByte) {
                    case 33: {
                        in.readBoolean();
                        break;
                    }
                    case 59: {
                        extension.setStartLine(in.readInt());
                        break;
                    }
                    case 19: {
                        extension.setName(in.readUTF());
                        break;
                    }
                    case 15: {
                        extension.setId(in.readUTF());
                        break;
                    }
                    case 7: {
                        extension.setExtensionPoint(in.readUTF());
                        break;
                    }
                    case 42: {
                        String name2;
                        int subElementsLength = in.readInt();
                        ConfigurationElementModel[] subElements = new ConfigurationElementModel[subElementsLength];
                        int i = 0;
                        while (i < subElementsLength && !done) {
                            byte subInByte = in.readByte();
                            switch (subInByte) {
                                case 2: {
                                    subElements[i] = this.readConfigurationElement(in, debugFlag);
                                    if (subElements[i] != null) break;
                                    if (debugFlag) {
                                        name2 = extension.getName();
                                        if (name2 == null) {
                                            name2 = new String("<unknown name>");
                                        }
                                        this.debug("Unable to read subelement #" + i + " for extension " + name2);
                                    }
                                    extension = null;
                                    done = true;
                                    break;
                                }
                                case 45: {
                                    subElements[i] = (ConfigurationElementModel)this.objectTable.get(in.readInt());
                                    break;
                                }
                                default: {
                                    if (debugFlag) {
                                        name2 = extension.getName();
                                        if (name2 == null) {
                                            name2 = new String("<unknown name>");
                                        }
                                        this.debug("Unexpected byte code " + PDERegistryCacheReader.decipherLabel(subInByte) + " reading subelements for extension " + name2);
                                    }
                                    extension = null;
                                    done = true;
                                }
                            }
                            ++i;
                        }
                        if (extension != null) {
                            extension.setSubElements(subElements);
                        }
                        subElements = null;
                        break;
                    }
                    case 9: {
                        String name;
                        String name2;
                        byte subByte = in.readByte();
                        switch (subByte) {
                            case 26: {
                                PluginDescriptorModel parent = this.readPluginDescriptor(in, debugFlag);
                                if (parent == null) {
                                    if (debugFlag) {
                                        name2 = extension.getName();
                                        if (name2 == null) {
                                            name2 = new String("<unknown name>");
                                        }
                                        this.debug("Trouble reading parent plugin for extension " + name2);
                                    }
                                    done = true;
                                    extension = null;
                                    break block2;
                                }
                                extension.setParent((PluginModel)parent);
                                break block2;
                            }
                            case 25: {
                                extension.setParent((PluginModel)this.objectTable.get(in.readInt()));
                                break block2;
                            }
                            case 48: {
                                PluginFragmentModel fragmentParent = this.readPluginFragment(in, debugFlag);
                                if (fragmentParent == null) {
                                    if (debugFlag) {
                                        name = extension.getName();
                                        if (name == null) {
                                            name = new String("<unknown name>");
                                        }
                                        this.debug("Trouble reading parent fragment for extension " + name);
                                    }
                                    done = true;
                                    extension = null;
                                    break block2;
                                }
                                extension.setParent((PluginModel)fragmentParent);
                                break block2;
                            }
                            case 47: {
                                extension.setParent((PluginModel)this.objectTable.get(in.readInt()));
                                break block2;
                            }
                        }
                        if (debugFlag) {
                            name = extension.getName();
                            if (name == null) {
                                name = new String("<unknown name>");
                            }
                            this.debug("Unexpected byte code " + PDERegistryCacheReader.decipherLabel(subByte) + "reading parent of extension " + name);
                        }
                        done = true;
                        extension = null;
                        break;
                    }
                    case 6: {
                        done = true;
                        break;
                    }
                    default: {
                        if (debugFlag) {
                            String name = extension.getName();
                            if (name == null) {
                                name = new String("<unknown name>");
                            }
                            this.debug("Unexpected byte code " + PDERegistryCacheReader.decipherLabel(inByte) + "reading extension" + name);
                        }
                        done = true;
                        extension = null;
                    }
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return extension;
    }

    public ExtensionPointModel readExtensionPoint(DataInputStream in, boolean debugFlag) {
        ExtensionPointModel extPoint = this.cacheFactory.createExtensionPoint();
        this.addToObjectTable(extPoint);
        int extensionLength = 0;
        try {
            byte inByte = 0;
            boolean done = false;
            block19: while (!done) {
                try {
                    inByte = in.readByte();
                }
                catch (EOFException eOFException) {
                    done = true;
                    break;
                }
                switch (inByte) {
                    case 33: {
                        in.readBoolean();
                        break;
                    }
                    case 59: {
                        extPoint.setStartLine(in.readInt());
                        break;
                    }
                    case 19: {
                        extPoint.setName(in.readUTF());
                        break;
                    }
                    case 15: {
                        extPoint.setId(in.readUTF());
                        break;
                    }
                    case 14: {
                        extPoint.setSchema(in.readUTF());
                        break;
                    }
                    case 11: {
                        extensionLength = in.readInt();
                        break;
                    }
                    case 12: {
                        ExtensionModel[] extensions = new ExtensionModel[extensionLength];
                        int i = 0;
                        while (i < extensionLength && !done) {
                            byte subByte = in.readByte();
                            switch (subByte) {
                                case 23: {
                                    String name;
                                    extensions[i] = this.readExtension(in, debugFlag);
                                    if (extensions[i] != null) break;
                                    if (debugFlag) {
                                        name = extPoint.getName();
                                        if (name == null) {
                                            name = new String("<unknown name>");
                                        }
                                        this.debug("Unable to read extension #" + i + " for extension point " + name);
                                    }
                                    done = true;
                                    extPoint = null;
                                    break;
                                }
                                case 8: {
                                    extensions[i] = (ExtensionModel)this.objectTable.get(in.readInt());
                                    break;
                                }
                                default: {
                                    String name;
                                    if (debugFlag) {
                                        name = extPoint.getName();
                                        if (name == null) {
                                            name = new String("<unknown name>");
                                        }
                                        this.debug("Unexpected byte code " + PDERegistryCacheReader.decipherLabel(subByte) + "reading extension #" + i + " for extension point " + name);
                                    }
                                    extPoint = null;
                                    done = true;
                                }
                            }
                            ++i;
                        }
                        if (extPoint == null) continue block19;
                        extPoint.setDeclaredExtensions(extensions);
                        break;
                    }
                    case 13: {
                        extPoint.setParent((PluginModel)this.objectTable.get(in.readInt()));
                        break;
                    }
                    case 10: {
                        done = true;
                        break;
                    }
                    default: {
                        if (debugFlag) {
                            String name = extPoint.getName();
                            if (name == null) {
                                name = new String("<unknown name>");
                            }
                            this.debug("Unexpected byte code " + PDERegistryCacheReader.decipherLabel(inByte) + " reading extension point " + name);
                        }
                        extPoint = null;
                        done = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return extPoint;
    }

    public LibraryModel readLibrary(DataInputStream in, boolean debugFlag) {
        LibraryModel library = this.cacheFactory.createLibrary();
        this.addToObjectTable(library);
        int exportsLength = 0;
        int prefixesLength = 0;
        try {
            byte inByte = 0;
            boolean done = false;
            while (!done) {
                try {
                    inByte = in.readByte();
                }
                catch (EOFException eOFException) {
                    done = true;
                    break;
                }
                switch (inByte) {
                    case 33: {
                        in.readBoolean();
                        break;
                    }
                    case 59: {
                        library.setStartLine(in.readInt());
                        break;
                    }
                    case 19: {
                        library.setName(in.readUTF());
                        break;
                    }
                    case 18: {
                        exportsLength = in.readInt();
                        break;
                    }
                    case 54: {
                        library.setType(in.readUTF());
                        break;
                    }
                    case 17: {
                        String[] exports = new String[exportsLength];
                        int i = 0;
                        while (i < exportsLength && !done) {
                            exports[i] = in.readUTF();
                            if (exports[i] == null) {
                                if (debugFlag) {
                                    String name = library.getName();
                                    if (name == null) {
                                        name = new String("<unknown name>");
                                    }
                                    this.debug("Empty export string for export #" + i + " reading library " + name);
                                }
                                done = true;
                                library = null;
                            }
                            ++i;
                        }
                        if (!done) {
                            library.setExports(exports);
                        }
                        exports = null;
                        break;
                    }
                    case 16: {
                        done = true;
                        break;
                    }
                    case 60: {
                        prefixesLength = in.readInt();
                        break;
                    }
                    case 61: {
                        String[] prefixes = new String[prefixesLength];
                        int i = 0;
                        while (i < prefixesLength && !done) {
                            prefixes[i] = in.readUTF();
                            if (prefixes[i] == null) {
                                if (debugFlag) {
                                    String name = library.getName();
                                    if (name == null) {
                                        name = new String("<unknown name>");
                                    }
                                    this.debug("Empty prefix string for prefix #" + i + " reading library " + name);
                                }
                                done = true;
                                library = null;
                            }
                            ++i;
                        }
                        if (!done) {
                            library.setPackagePrefixes(prefixes);
                        }
                        prefixes = null;
                        break;
                    }
                    default: {
                        if (debugFlag) {
                            String name = library.getName();
                            if (name == null) {
                                name = new String("<unknown name>");
                            }
                            this.debug("Unexpected byte code " + PDERegistryCacheReader.decipherLabel(inByte) + " reading library " + name);
                        }
                        library = null;
                        done = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return library;
    }

    public PluginDescriptorModel readPluginDescriptor(DataInputStream in, boolean debugFlag) {
        PluginDescriptorModel plugin = this.cacheFactory.createPluginDescriptor();
        this.addToObjectTable(plugin);
        try {
            byte inByte = 0;
            boolean done = false;
            while (!done) {
                try {
                    inByte = in.readByte();
                }
                catch (EOFException eOFException) {
                    done = true;
                    break;
                }
                switch (inByte) {
                    case 33: {
                        in.readBoolean();
                        break;
                    }
                    case 59: {
                        plugin.setStartLine(in.readInt());
                        break;
                    }
                    case 19: {
                        plugin.setName(in.readUTF());
                        break;
                    }
                    case 15: {
                        plugin.setId(in.readUTF());
                        break;
                    }
                    case 30: {
                        plugin.setProviderName(in.readUTF());
                        break;
                    }
                    case 44: {
                        plugin.setVersion(in.readUTF());
                        break;
                    }
                    case 20: {
                        plugin.setPluginClass(in.readUTF());
                        break;
                    }
                    case 27: {
                        plugin.setLocation(in.readUTF());
                        break;
                    }
                    case 21: {
                        plugin.setEnabled(in.readBoolean());
                        break;
                    }
                    case 31: {
                        PluginPrerequisiteModel[] newRequiresValues;
                        PluginPrerequisiteModel[] requiresList;
                        PluginPrerequisiteModel requires = this.readPluginPrerequisite(in, debugFlag);
                        if (requires == null) {
                            if (debugFlag) {
                                String name = plugin.getName();
                                if (name == null) {
                                    name = new String("<unknown name>");
                                }
                                this.debug("Unable to read prerequisite for plugin " + name);
                            }
                            plugin = null;
                            done = true;
                        } else {
                            requiresList = plugin.getRequires();
                            newRequiresValues = null;
                            if (requiresList == null) {
                                newRequiresValues = new PluginPrerequisiteModel[]{requires};
                            } else {
                                newRequiresValues = new PluginPrerequisiteModel[requiresList.length + 1];
                                System.arraycopy(requiresList, 0, newRequiresValues, 0, requiresList.length);
                                newRequiresValues[requiresList.length] = requires;
                            }
                            plugin.setRequires(newRequiresValues);
                            newRequiresValues = null;
                            requiresList = null;
                        }
                        requires = null;
                        break;
                    }
                    case 58: {
                        PluginPrerequisiteModel requires = (PluginPrerequisiteModel)this.objectTable.get(in.readInt());
                        PluginPrerequisiteModel[] requiresList = plugin.getRequires();
                        PluginPrerequisiteModel[] newRequiresValues = null;
                        if (requiresList == null) {
                            newRequiresValues = new PluginPrerequisiteModel[]{requires};
                        } else {
                            newRequiresValues = new PluginPrerequisiteModel[requiresList.length + 1];
                            System.arraycopy(requiresList, 0, newRequiresValues, 0, requiresList.length);
                            newRequiresValues[requiresList.length] = requires;
                        }
                        plugin.setRequires(newRequiresValues);
                        requires = null;
                        newRequiresValues = null;
                        requiresList = null;
                        break;
                    }
                    case 28: {
                        LibraryModel[] newLibraryValues;
                        LibraryModel[] libraryList;
                        LibraryModel library = this.readLibrary(in, debugFlag);
                        if (library == null) {
                            if (debugFlag) {
                                String name = plugin.getName();
                                if (name == null) {
                                    name = new String("<unknown name>");
                                }
                                this.debug("Unable to read library for plugin " + name);
                            }
                            plugin = null;
                            done = true;
                        } else {
                            libraryList = plugin.getRuntime();
                            newLibraryValues = null;
                            if (libraryList == null) {
                                newLibraryValues = new LibraryModel[]{library};
                            } else {
                                newLibraryValues = new LibraryModel[libraryList.length + 1];
                                System.arraycopy(libraryList, 0, newLibraryValues, 0, libraryList.length);
                                newLibraryValues[libraryList.length] = library;
                            }
                            plugin.setRuntime(newLibraryValues);
                            newLibraryValues = null;
                            libraryList = null;
                        }
                        library = null;
                        break;
                    }
                    case 57: {
                        LibraryModel library = (LibraryModel)this.objectTable.get(in.readInt());
                        LibraryModel[] libraryList = plugin.getRuntime();
                        LibraryModel[] newLibraryValues = null;
                        if (libraryList == null) {
                            newLibraryValues = new LibraryModel[]{library};
                        } else {
                            newLibraryValues = new LibraryModel[libraryList.length + 1];
                            System.arraycopy(libraryList, 0, newLibraryValues, 0, libraryList.length);
                            newLibraryValues[libraryList.length] = library;
                        }
                        plugin.setRuntime(newLibraryValues);
                        library = null;
                        newLibraryValues = null;
                        libraryList = null;
                        break;
                    }
                    case 23: {
                        ExtensionModel[] newExtValues;
                        ExtensionModel[] extList;
                        ExtensionModel extension = this.readExtension(in, debugFlag);
                        if (extension == null) {
                            if (debugFlag) {
                                String name = plugin.getName();
                                if (name == null) {
                                    name = new String("<unknown name>");
                                }
                                this.debug("Unable to read extension for plugin " + name);
                            }
                            plugin = null;
                            done = true;
                        } else {
                            extList = plugin.getDeclaredExtensions();
                            newExtValues = null;
                            if (extList == null) {
                                newExtValues = new ExtensionModel[]{extension};
                            } else {
                                newExtValues = new ExtensionModel[extList.length + 1];
                                System.arraycopy(extList, 0, newExtValues, 0, extList.length);
                                newExtValues[extList.length] = extension;
                            }
                            plugin.setDeclaredExtensions(newExtValues);
                            newExtValues = null;
                            extList = null;
                        }
                        extension = null;
                        break;
                    }
                    case 8: {
                        ExtensionModel extension = (ExtensionModel)this.objectTable.get(in.readInt());
                        ExtensionModel[] extList = plugin.getDeclaredExtensions();
                        ExtensionModel[] newExtValues = null;
                        if (extList == null) {
                            newExtValues = new ExtensionModel[]{extension};
                        } else {
                            newExtValues = new ExtensionModel[extList.length + 1];
                            System.arraycopy(extList, 0, newExtValues, 0, extList.length);
                            newExtValues[extList.length] = extension;
                        }
                        plugin.setDeclaredExtensions(newExtValues);
                        extension = null;
                        newExtValues = null;
                        extList = null;
                        break;
                    }
                    case 24: {
                        ExtensionPointModel extensionPoint = this.readExtensionPoint(in, debugFlag);
                        if (extensionPoint == null) {
                            if (debugFlag) {
                                String name = plugin.getName();
                                if (name == null) {
                                    name = new String("<unknown name>");
                                }
                                this.debug("Unable to read extension point for plugin " + name);
                            }
                            plugin = null;
                            done = true;
                            break;
                        }
                        ExtensionPointModel[] extPointList = plugin.getDeclaredExtensionPoints();
                        ExtensionPointModel[] newExtPointValues = null;
                        if (extPointList == null) {
                            newExtPointValues = new ExtensionPointModel[]{extensionPoint};
                        } else {
                            newExtPointValues = new ExtensionPointModel[extPointList.length + 1];
                            System.arraycopy(extPointList, 0, newExtPointValues, 0, extPointList.length);
                            newExtPointValues[extPointList.length] = extensionPoint;
                        }
                        plugin.setDeclaredExtensionPoints(newExtPointValues);
                        extensionPoint = null;
                        newExtPointValues = null;
                        extPointList = null;
                        break;
                    }
                    case 56: {
                        ExtensionPointModel extensionPoint = (ExtensionPointModel)this.objectTable.get(in.readInt());
                        ExtensionPointModel[] extPointList = plugin.getDeclaredExtensionPoints();
                        ExtensionPointModel[] newExtPointValues = null;
                        if (extPointList == null) {
                            newExtPointValues = new ExtensionPointModel[]{extensionPoint};
                        } else {
                            newExtPointValues = new ExtensionPointModel[extPointList.length + 1];
                            System.arraycopy(extPointList, 0, newExtPointValues, 0, extPointList.length);
                            newExtPointValues[extPointList.length] = extensionPoint;
                        }
                        plugin.setDeclaredExtensionPoints(newExtPointValues);
                        extensionPoint = null;
                        newExtPointValues = null;
                        extPointList = null;
                        break;
                    }
                    case 48: {
                        PluginFragmentModel fragment = this.readPluginFragment(in, debugFlag);
                        if (fragment == null) {
                            if (debugFlag) {
                                String name = plugin.getName();
                                if (name == null) {
                                    name = new String("<unknown name>");
                                }
                                this.debug("Unable to read fragment for plugin " + name);
                            }
                            plugin = null;
                            done = true;
                            break;
                        }
                        PluginFragmentModel[] fragmentList = plugin.getFragments();
                        PluginFragmentModel[] newFragmentValues = null;
                        if (fragmentList == null) {
                            newFragmentValues = new PluginFragmentModel[]{fragment};
                        } else {
                            newFragmentValues = new PluginFragmentModel[fragmentList.length + 1];
                            System.arraycopy(fragmentList, 0, newFragmentValues, 0, fragmentList.length);
                            newFragmentValues[fragmentList.length] = fragment;
                        }
                        plugin.setFragments(newFragmentValues);
                        fragment = null;
                        newFragmentValues = null;
                        fragmentList = null;
                        break;
                    }
                    case 47: {
                        PluginFragmentModel fragment = (PluginFragmentModel)this.objectTable.get(in.readInt());
                        PluginFragmentModel[] fragmentList = plugin.getFragments();
                        PluginFragmentModel[] newFragmentValues = null;
                        if (fragmentList == null) {
                            newFragmentValues = new PluginFragmentModel[]{fragment};
                        } else {
                            newFragmentValues = new PluginFragmentModel[fragmentList.length + 1];
                            System.arraycopy(fragmentList, 0, newFragmentValues, 0, fragmentList.length);
                            newFragmentValues[fragmentList.length] = fragment;
                        }
                        plugin.setFragments(newFragmentValues);
                        fragment = null;
                        newFragmentValues = null;
                        fragmentList = null;
                        break;
                    }
                    case 29: {
                        plugin.setRegistry((PluginRegistryModel)this.objectTable.get(in.readInt()));
                        break;
                    }
                    case 22: {
                        done = true;
                        break;
                    }
                    default: {
                        if (debugFlag) {
                            String name = plugin.getName();
                            if (name == null) {
                                name = new String("<unknown name>");
                            }
                            this.debug("Unexpected byte code " + PDERegistryCacheReader.decipherLabel(inByte) + " reading plugin " + name);
                        }
                        plugin = null;
                        done = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return plugin;
    }

    public PluginFragmentModel readPluginFragment(DataInputStream in, boolean debugFlag) {
        PluginFragmentModel fragment = this.cacheFactory.createPluginFragment();
        this.addToObjectTable(fragment);
        try {
            byte inByte = 0;
            boolean done = false;
            while (!done) {
                try {
                    inByte = in.readByte();
                }
                catch (EOFException eOFException) {
                    done = true;
                    break;
                }
                switch (inByte) {
                    case 33: {
                        in.readBoolean();
                        break;
                    }
                    case 59: {
                        fragment.setStartLine(in.readInt());
                        break;
                    }
                    case 19: {
                        fragment.setName(in.readUTF());
                        break;
                    }
                    case 15: {
                        fragment.setId(in.readUTF());
                        break;
                    }
                    case 30: {
                        fragment.setProviderName(in.readUTF());
                        break;
                    }
                    case 44: {
                        fragment.setVersion(in.readUTF());
                        break;
                    }
                    case 27: {
                        fragment.setLocation(in.readUTF());
                        break;
                    }
                    case 50: {
                        fragment.setPlugin(in.readUTF());
                        break;
                    }
                    case 51: {
                        fragment.setPluginVersion(in.readUTF());
                        break;
                    }
                    case 55: {
                        fragment.setMatch(in.readByte());
                        break;
                    }
                    case 31: {
                        PluginPrerequisiteModel requires = this.readPluginPrerequisite(in, debugFlag);
                        if (requires == null) {
                            if (debugFlag) {
                                String name = fragment.getName();
                                if (name == null) {
                                    name = new String("<unknown name>");
                                }
                                this.debug("Unable to read prerequisite for fragment " + name);
                            }
                            done = true;
                            fragment = null;
                            break;
                        }
                        PluginPrerequisiteModel[] requiresList = fragment.getRequires();
                        PluginPrerequisiteModel[] newRequiresValues = null;
                        if (requiresList == null) {
                            newRequiresValues = new PluginPrerequisiteModel[]{requires};
                        } else {
                            newRequiresValues = new PluginPrerequisiteModel[requiresList.length + 1];
                            System.arraycopy(requiresList, 0, newRequiresValues, 0, requiresList.length);
                            newRequiresValues[requiresList.length] = requires;
                        }
                        fragment.setRequires(newRequiresValues);
                        requires = null;
                        newRequiresValues = null;
                        requiresList = null;
                        break;
                    }
                    case 58: {
                        PluginPrerequisiteModel requires = (PluginPrerequisiteModel)this.objectTable.get(in.readInt());
                        PluginPrerequisiteModel[] requiresList = fragment.getRequires();
                        PluginPrerequisiteModel[] newRequiresValues = null;
                        if (requiresList == null) {
                            newRequiresValues = new PluginPrerequisiteModel[]{requires};
                        } else {
                            newRequiresValues = new PluginPrerequisiteModel[requiresList.length + 1];
                            System.arraycopy(requiresList, 0, newRequiresValues, 0, requiresList.length);
                            newRequiresValues[requiresList.length] = requires;
                        }
                        fragment.setRequires(newRequiresValues);
                        requires = null;
                        newRequiresValues = null;
                        requiresList = null;
                        break;
                    }
                    case 28: {
                        LibraryModel library = this.readLibrary(in, debugFlag);
                        if (library == null) {
                            if (debugFlag) {
                                String name = fragment.getName();
                                if (name == null) {
                                    name = new String("<unknown name>");
                                }
                                this.debug("Unable to read library for fragment " + name);
                            }
                            fragment = null;
                            done = true;
                            break;
                        }
                        LibraryModel[] libraryList = fragment.getRuntime();
                        LibraryModel[] newLibraryValues = null;
                        if (libraryList == null) {
                            newLibraryValues = new LibraryModel[]{library};
                        } else {
                            newLibraryValues = new LibraryModel[libraryList.length + 1];
                            System.arraycopy(libraryList, 0, newLibraryValues, 0, libraryList.length);
                            newLibraryValues[libraryList.length] = library;
                        }
                        fragment.setRuntime(newLibraryValues);
                        library = null;
                        newLibraryValues = null;
                        libraryList = null;
                        break;
                    }
                    case 57: {
                        LibraryModel library = (LibraryModel)this.objectTable.get(in.readInt());
                        LibraryModel[] libraryList = fragment.getRuntime();
                        LibraryModel[] newLibraryValues = null;
                        if (libraryList == null) {
                            newLibraryValues = new LibraryModel[]{library};
                        } else {
                            newLibraryValues = new LibraryModel[libraryList.length + 1];
                            System.arraycopy(libraryList, 0, newLibraryValues, 0, libraryList.length);
                            newLibraryValues[libraryList.length] = library;
                        }
                        fragment.setRuntime(newLibraryValues);
                        library = null;
                        newLibraryValues = null;
                        libraryList = null;
                        break;
                    }
                    case 23: {
                        ExtensionModel extension = this.readExtension(in, debugFlag);
                        if (extension == null) {
                            if (debugFlag) {
                                String name = fragment.getName();
                                if (name == null) {
                                    name = new String("<unknown name>");
                                }
                                this.debug("Unable to read extension for fragment " + name);
                            }
                            fragment = null;
                            done = true;
                            break;
                        }
                        ExtensionModel[] extList = fragment.getDeclaredExtensions();
                        ExtensionModel[] newExtValues = null;
                        if (extList == null) {
                            newExtValues = new ExtensionModel[]{extension};
                        } else {
                            newExtValues = new ExtensionModel[extList.length + 1];
                            System.arraycopy(extList, 0, newExtValues, 0, extList.length);
                            newExtValues[extList.length] = extension;
                        }
                        fragment.setDeclaredExtensions(newExtValues);
                        extension = null;
                        newExtValues = null;
                        extList = null;
                        break;
                    }
                    case 8: {
                        ExtensionModel extension = (ExtensionModel)this.objectTable.get(in.readInt());
                        ExtensionModel[] extList = fragment.getDeclaredExtensions();
                        ExtensionModel[] newExtValues = null;
                        if (extList == null) {
                            newExtValues = new ExtensionModel[]{extension};
                        } else {
                            newExtValues = new ExtensionModel[extList.length + 1];
                            System.arraycopy(extList, 0, newExtValues, 0, extList.length);
                            newExtValues[extList.length] = extension;
                        }
                        fragment.setDeclaredExtensions(newExtValues);
                        extension = null;
                        newExtValues = null;
                        extList = null;
                        break;
                    }
                    case 24: {
                        ExtensionPointModel extensionPoint = this.readExtensionPoint(in, debugFlag);
                        if (extensionPoint == null) {
                            if (debugFlag) {
                                String name = fragment.getName();
                                if (name == null) {
                                    name = new String("<unknown name>");
                                }
                                this.debug("Unable to read extension point for fragment " + name);
                            }
                            fragment = null;
                            done = true;
                            break;
                        }
                        ExtensionPointModel[] extPointList = fragment.getDeclaredExtensionPoints();
                        ExtensionPointModel[] newExtPointValues = null;
                        if (extPointList == null) {
                            newExtPointValues = new ExtensionPointModel[]{extensionPoint};
                        } else {
                            newExtPointValues = new ExtensionPointModel[extPointList.length + 1];
                            System.arraycopy(extPointList, 0, newExtPointValues, 0, extPointList.length);
                            newExtPointValues[extPointList.length] = extensionPoint;
                        }
                        fragment.setDeclaredExtensionPoints(newExtPointValues);
                        extensionPoint = null;
                        newExtPointValues = null;
                        extPointList = null;
                        break;
                    }
                    case 56: {
                        ExtensionPointModel extensionPoint = (ExtensionPointModel)this.objectTable.get(in.readInt());
                        ExtensionPointModel[] extPointList = fragment.getDeclaredExtensionPoints();
                        ExtensionPointModel[] newExtPointValues = null;
                        if (extPointList == null) {
                            newExtPointValues = new ExtensionPointModel[]{extensionPoint};
                        } else {
                            newExtPointValues = new ExtensionPointModel[extPointList.length + 1];
                            System.arraycopy(extPointList, 0, newExtPointValues, 0, extPointList.length);
                            newExtPointValues[extPointList.length] = extensionPoint;
                        }
                        fragment.setDeclaredExtensionPoints(newExtPointValues);
                        extensionPoint = null;
                        newExtPointValues = null;
                        extPointList = null;
                        break;
                    }
                    case 29: {
                        fragment.setRegistry((PluginRegistryModel)this.objectTable.get(in.readInt()));
                        break;
                    }
                    case 49: {
                        done = true;
                        break;
                    }
                    default: {
                        if (debugFlag) {
                            String name = fragment.getName();
                            if (name == null) {
                                name = new String("<unknown name>");
                            }
                            this.debug("Unexpected byte code " + PDERegistryCacheReader.decipherLabel(inByte) + " reading fragment " + name);
                        }
                        fragment = null;
                        done = true;
                    }
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return fragment;
    }

    public PluginPrerequisiteModel readPluginPrerequisite(DataInputStream in, boolean debugFlag) {
        PluginPrerequisiteModel requires = this.cacheFactory.createPluginPrerequisite();
        this.addToObjectTable(requires);
        try {
            byte inByte = 0;
            boolean done = false;
            while (!done) {
                try {
                    inByte = in.readByte();
                }
                catch (EOFException eOFException) {
                    done = true;
                    break;
                }
                switch (inByte) {
                    case 33: {
                        in.readBoolean();
                        break;
                    }
                    case 59: {
                        requires.setStartLine(in.readInt());
                        break;
                    }
                    case 19: {
                        requires.setName(in.readUTF());
                        break;
                    }
                    case 44: {
                        requires.setVersion(in.readUTF());
                        break;
                    }
                    case 39: {
                        requires.setMatchByte(in.readByte());
                        break;
                    }
                    case 38: {
                        requires.setExport(in.readBoolean());
                        break;
                    }
                    case 52: {
                        requires.setOptional(in.readBoolean());
                        break;
                    }
                    case 41: {
                        requires.setResolvedVersion(in.readUTF());
                        break;
                    }
                    case 40: {
                        requires.setPlugin(in.readUTF());
                        break;
                    }
                    case 37: {
                        done = true;
                        break;
                    }
                    default: {
                        if (debugFlag) {
                            String name = requires.getName();
                            if (name == null) {
                                name = new String("<unknown name>");
                            }
                            this.debug("Unexpected byte code " + PDERegistryCacheReader.decipherLabel(inByte) + " reading prerequisite " + name);
                        }
                        done = true;
                        requires = null;
                    }
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return requires;
    }

    public PluginRegistryModel readPluginRegistry(DataInputStream in, URL[] pluginPath, boolean debugFlag) {
        PluginDescriptorModel[] pluginList;
        if (!this.interpretHeaderInformation(in)) {
            if (debugFlag) {
                this.debug("Cache header information out of date - ignoring cache");
            }
            return null;
        }
        PluginRegistryModel cachedRegistry = this.cacheFactory.createPluginRegistry();
        this.addToObjectTable(cachedRegistry);
        boolean setReadOnlyFlag = false;
        try {
            byte inByte = 0;
            boolean done = false;
            block14: while (!done) {
                try {
                    inByte = in.readByte();
                }
                catch (EOFException eOFException) {
                    return null;
                }
                switch (inByte) {
                    case 35: {
                        break;
                    }
                    case 33: {
                        if (!in.readBoolean()) continue block14;
                        setReadOnlyFlag = true;
                        break;
                    }
                    case 36: {
                        if (!in.readBoolean()) continue block14;
                        cachedRegistry.markResolved();
                        break;
                    }
                    case 26: {
                        PluginDescriptorModel plugin = null;
                        plugin = this.readPluginDescriptor(in, debugFlag);
                        if (plugin != null) {
                            cachedRegistry.addPlugin(plugin);
                            break;
                        }
                        if (debugFlag) {
                            this.debug("Unable to read plugin descriptor for plugin registry");
                        }
                        done = true;
                        cachedRegistry = null;
                        break;
                    }
                    case 25: {
                        PluginDescriptorModel plugin = (PluginDescriptorModel)this.objectTable.get(in.readInt());
                        cachedRegistry.addPlugin(plugin);
                        break;
                    }
                    case 48: {
                        PluginFragmentModel fragment = null;
                        fragment = this.readPluginFragment(in, debugFlag);
                        if (fragment != null) {
                            cachedRegistry.addFragment(fragment);
                            break;
                        }
                        if (debugFlag) {
                            this.debug("Unable to read fragment descriptor for plugin registry");
                        }
                        done = true;
                        cachedRegistry = null;
                        break;
                    }
                    case 47: {
                        PluginFragmentModel fragment = (PluginFragmentModel)this.objectTable.get(in.readInt());
                        cachedRegistry.addFragment(fragment);
                        break;
                    }
                    case 34: {
                        done = true;
                        break;
                    }
                    default: {
                        if (debugFlag) {
                            this.debug("Unexpected byte code " + PDERegistryCacheReader.decipherLabel(inByte) + " reading plugin registry");
                        }
                        done = true;
                        cachedRegistry = null;
                    }
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        if (cachedRegistry == null) {
            return null;
        }
        if (setReadOnlyFlag) {
            cachedRegistry.markReadOnly();
        }
        if ((pluginList = cachedRegistry.getPlugins()) == null || pluginList.length == 0) {
            return null;
        }
        return cachedRegistry;
    }

    private String[] getPathMembers(URL path) {
        String[] list = null;
        String protocol = path.getProtocol();
        if (protocol.equals("file")) {
            list = new File(path.getFile()).list();
        }
        return list == null ? new String[]{} : list;
    }
}

