/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.EntryFileAdapter;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;

public class ModelEntry
extends PlatformObject {
    public static final int AUTOMATIC = 0;
    public static final int WORKSPACE = 1;
    public static final int EXTERNAL = 2;
    private String id;
    private IPluginModelBase workspaceModel;
    private IPluginModelBase externalModel;
    private int mode = 0;
    private RequiredPluginsClasspathContainer classpathContainer;
    private boolean inJavaSearch = false;
    private PluginModelManager manager;

    public ModelEntry(PluginModelManager manager, String id) {
        this.manager = manager;
        this.id = id;
    }

    public IPluginModelBase getActiveModel() {
        if (this.mode == 0) {
            if (this.workspaceModel != null) {
                return this.workspaceModel;
            }
            return this.externalModel;
        }
        return this.mode == 1 ? this.workspaceModel : this.externalModel;
    }

    public String getId() {
        return this.id;
    }

    public Object[] getChildren() {
        if (this.workspaceModel == null && this.externalModel != null) {
            String location = this.externalModel.getInstallLocation();
            File file = new File(location);
            EntryFileAdapter adapter = new EntryFileAdapter(this, file, this.manager.getFileAdapterFactory());
            return adapter.getChildren();
        }
        return new Object[0];
    }

    public boolean isInJavaSearch() {
        return this.inJavaSearch;
    }

    void setInJavaSearch(boolean value) {
        this.inJavaSearch = value;
    }

    public void setWorkspaceModel(IPluginModelBase model) {
        this.workspaceModel = model;
        this.classpathContainer = null;
    }

    public void setExternalModel(IPluginModelBase model) {
        this.externalModel = model;
        this.classpathContainer = null;
    }

    public IPluginModelBase getWorkspaceModel() {
        return this.workspaceModel;
    }

    public IPluginModelBase getExternalModel() {
        return this.externalModel;
    }

    public boolean isEmpty() {
        return this.workspaceModel == null && this.externalModel == null;
    }

    public RequiredPluginsClasspathContainer getClasspathContainer() {
        if (this.classpathContainer == null) {
            this.classpathContainer = new RequiredPluginsClasspathContainer(this.workspaceModel);
        }
        return this.classpathContainer;
    }

    public void updateClasspathContainer(boolean force) throws CoreException {
        if (this.workspaceModel == null || !this.usesContainers()) {
            return;
        }
        if (force) {
            this.classpathContainer = null;
        }
        RequiredPluginsClasspathContainer container = this.getClasspathContainer();
        container.reset();
        IProject project = this.workspaceModel.getUnderlyingResource().getProject();
        IJavaProject[] javaProjects = new IJavaProject[]{JavaCore.create((IProject)project)};
        IClasspathContainer[] containers = new IClasspathContainer[]{container};
        Path path = new Path("org.eclipse.pde.core.requiredPlugins");
        JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])javaProjects, (IClasspathContainer[])containers, null);
    }

    private boolean usesContainers() throws CoreException {
        IProject project = this.workspaceModel.getUnderlyingResource().getProject();
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IClasspathEntry[] entries = JavaCore.create((IProject)project).getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 5 && entry.getPath().equals((Object)new Path("org.eclipse.pde.core.requiredPlugins"))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void updateUnknownClasspathContainer(IJavaProject javaProject) throws CoreException {
        Path path = new Path("org.eclipse.pde.core.requiredPlugins");
        JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{new RequiredPluginsClasspathContainer(null)}, null);
    }

    public boolean isAffected(IPluginBase[] changedPlugins) {
        if (this.workspaceModel == null) {
            return false;
        }
        IPluginBase plugin = this.workspaceModel.getPluginBase();
        int i = 0;
        while (i < changedPlugins.length) {
            IPluginBase changedPlugin = changedPlugins[i];
            String id = changedPlugin.getId();
            if (plugin.getId().equals(id)) {
                return true;
            }
            if (this.isRequired(plugin, changedPlugin)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isRequired(IPluginBase plugin, IPluginBase changedPlugin) {
        String changedId = changedPlugin.getId();
        if (changedId == null) {
            return false;
        }
        if (changedId.equalsIgnoreCase("org.eclipse.core.boot") || changedId.equalsIgnoreCase("org.eclipse.core.runtime")) {
            return true;
        }
        IPluginImport[] imports = plugin.getImports();
        int i = 0;
        while (i < imports.length) {
            IPluginImport iimport = imports[i];
            if (iimport.getId().equals(changedId)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

