/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginPathFinder;

public class EclipseHomeInitializer
extends ClasspathVariableInitializer {
    public void initialize(String variable) {
        EclipseHomeInitializer.resetEclipseHomeVariables();
    }

    public static void resetEclipseHomeVariables() {
        try {
            JavaCore.run((IWorkspaceRunnable)new SetEclipseVariablesOperation(), null);
        }
        catch (CoreException coreException) {}
    }

    public static IPath createEclipseRelativeHome(String installLocation) {
        Path fullPath = new Path(installLocation);
        String[] variables = JavaCore.getClasspathVariableNames();
        String correctVariable = null;
        int maxMatching = 0;
        int i = 0;
        while (i < variables.length) {
            IPath currentPath;
            int currentMatch;
            if (variables[i].startsWith("ECLIPSE_HOME") && (currentMatch = fullPath.matchingFirstSegments(currentPath = JavaCore.getClasspathVariable((String)variables[i]))) > maxMatching) {
                maxMatching = currentMatch;
                correctVariable = variables[i];
            }
            ++i;
        }
        return correctVariable == null ? fullPath : new Path(correctVariable).append(fullPath.removeFirstSegments(maxMatching));
    }

    static class SetEclipseVariablesOperation
    implements IWorkspaceRunnable {
        SetEclipseVariablesOperation() {
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            String[] variables = JavaCore.getClasspathVariableNames();
            int i = 0;
            while (i < variables.length) {
                if (variables[i].startsWith("ECLIPSE_HOME") && !variables[i].equals("ECLIPSE_HOME")) {
                    JavaCore.removeClasspathVariable((String)variables[i], null);
                }
                ++i;
            }
            try {
                Preferences pref = PDECore.getDefault().getPluginPreferences();
                String platformHome = pref.getString("platform_path");
                JavaCore.setClasspathVariable((String)"ECLIPSE_HOME", (IPath)new Path(platformHome), null);
                File[] linkFiles = PluginPathFinder.getLinkFiles(platformHome);
                if (linkFiles != null) {
                    int i2 = 0;
                    while (i2 < linkFiles.length) {
                        String path = PluginPathFinder.getPath(platformHome, linkFiles[i2]);
                        if (path != null) {
                            String variable = "ECLIPSE_HOME_" + linkFiles[i2].getName().replace('.', '_').toUpperCase();
                            JavaCore.setClasspathVariable((String)variable, (IPath)new Path(path), null);
                        }
                        ++i2;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }
}

