/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.EclipseHomeInitializer;
import org.eclipse.pde.internal.core.IMissingPluginConfirmation;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;

public class ClasspathUtilCore {
    public static void setClasspath(IPluginModelBase model, boolean useClasspathContainer, IMissingPluginConfirmation confirmation, IProgressMonitor monitor) throws CoreException {
        Vector<IClasspathEntry> result = new Vector<IClasspathEntry>();
        int numUnits = 3;
        if (!useClasspathContainer) {
            numUnits += model.getPluginBase().getImports().length;
        }
        monitor.beginTask("", numUnits);
        ClasspathUtilCore.addSourceAndLibraries(model, result);
        monitor.worked(1);
        if (useClasspathContainer) {
            result.add(ClasspathUtilCore.createContainerEntry());
            monitor.worked(1);
        } else {
            ClasspathUtilCore.computePluginEntries(model, true, result, confirmation, monitor);
        }
        ClasspathUtilCore.addJRE(result);
        monitor.worked(1);
        IClasspathEntry[] entries = result.toArray(new IClasspathEntry[result.size()]);
        IJavaProject javaProject = JavaCore.create((IProject)model.getUnderlyingResource().getProject());
        IJavaModelStatus validation = JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])entries, (IPath)javaProject.getOutputLocation());
        if (!validation.isOK()) {
            PDECore.logErrorMessage(validation.getMessage());
            throw new CoreException((IStatus)validation);
        }
        javaProject.setRawClasspath(entries, monitor);
    }

    private static void computePluginEntries(IPluginModelBase model, boolean relative, Vector result, IMissingPluginConfirmation confirmation, IProgressMonitor monitor) {
        try {
            HashSet alreadyAdded = new HashSet();
            if (model.isFragmentModel()) {
                ClasspathUtilCore.addParentPlugin((IFragment)model.getPluginBase(), relative, result, alreadyAdded);
            } else {
                ClasspathUtilCore.addFragmentLibraries(model.getPluginBase(), relative, result);
            }
            IPluginImport[] dependencies = model.getPluginBase().getImports();
            int i = 0;
            while (i < dependencies.length) {
                IPluginImport dependency = dependencies[i];
                IPlugin plugin = PDECore.getDefault().findPlugin(dependency.getId(), dependency.getVersion(), dependency.getMatch());
                if (plugin != null) {
                    ClasspathUtilCore.addDependency(plugin, dependency.isReexported(), relative, true, result, alreadyAdded);
                } else if (confirmation != null && confirmation.getUseProjectReference()) {
                    ClasspathUtilCore.addMissingDependencyAsProject(dependency.getId(), dependency.isReexported(), result);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                ++i;
            }
            ClasspathUtilCore.addImplicitDependencies(model.getPluginBase().getId(), relative, result, alreadyAdded);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        catch (CoreException coreException) {}
    }

    public static IClasspathEntry[] computePluginEntries(IPluginModelBase model, IMissingPluginConfirmation confirmation) {
        Vector result = new Vector();
        ClasspathUtilCore.computePluginEntries(model, false, result, confirmation, null);
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    private static void addMissingDependencyAsProject(String name, boolean isExported, Vector result) {
        IProject project = PDECore.getWorkspace().getRoot().getProject(name);
        IClasspathEntry entry = JavaCore.newProjectEntry((IPath)project.getFullPath(), (boolean)isExported);
        result.add(entry);
    }

    private static void addDependency(IPlugin plugin, boolean isExported, boolean relative, boolean doAddWorkspaceFragments, Vector result, HashSet alreadyAdded) throws CoreException {
        if (!alreadyAdded.add(plugin)) {
            return;
        }
        IResource resource = plugin.getModel().getUnderlyingResource();
        if (resource != null) {
            IProject project = resource.getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IClasspathEntry entry = JavaCore.newProjectEntry((IPath)project.getFullPath(), (boolean)isExported);
                result.add(entry);
            }
            if (doAddWorkspaceFragments) {
                ClasspathUtilCore.addFragmentsWithSource(plugin, isExported, result);
            }
            return;
        }
        IPluginLibrary[] libraries = plugin.getLibraries();
        int i = 0;
        while (i < libraries.length) {
            IClasspathEntry entry = ClasspathUtilCore.createLibraryEntry(libraries[i], isExported, relative);
            if (entry != null) {
                result.add(entry);
            }
            ++i;
        }
        IPluginImport[] imports = plugin.getImports();
        int i2 = 0;
        while (i2 < imports.length) {
            IPlugin importedPlugin;
            IPluginImport dependency = imports[i2];
            if (dependency.isReexported() && (importedPlugin = PDECore.getDefault().findPlugin(dependency.getId(), dependency.getVersion(), dependency.getMatch())) != null) {
                ClasspathUtilCore.addDependency(importedPlugin, isExported, relative, true, result, alreadyAdded);
            }
            ++i2;
        }
    }

    private static void addFragmentLibraries(IPluginBase plugin, boolean relative, Vector result) {
        IFragment[] fragments = PDECore.getDefault().findFragmentsFor(plugin.getId(), plugin.getVersion());
        int i = 0;
        while (i < fragments.length) {
            IPluginLibrary[] libraries = fragments[i].getLibraries();
            int j = 0;
            while (j < libraries.length) {
                IClasspathEntry entry = ClasspathUtilCore.createLibraryEntry(libraries[j], true, relative);
                if (entry != null && !result.contains(entry)) {
                    result.add(entry);
                }
                ++j;
            }
            ++i;
        }
    }

    private static void addFragmentsWithSource(IPlugin plugin, boolean isExported, Vector result) throws CoreException {
        IFragment[] fragments = PDECore.getDefault().getWorkspaceModelManager().getFragmentsFor(plugin.getId(), plugin.getVersion());
        int i = 0;
        while (i < fragments.length) {
            IClasspathEntry projectEntry;
            IProject project = fragments[i].getModel().getUnderlyingResource().getProject();
            if (WorkspaceModelManager.isJavaPluginProjectWithSource(project) && !result.contains(projectEntry = JavaCore.newProjectEntry((IPath)project.getFullPath(), (boolean)isExported))) {
                result.add(projectEntry);
            }
            ++i;
        }
    }

    protected static void addImplicitDependencies(String id, boolean relative, Vector result, HashSet alreadyAdded) throws CoreException {
        if (!id.equals("org.eclipse.core.boot") && !id.equals("org.apache.xerces")) {
            IPlugin plugin = PDECore.getDefault().findPlugin("org.eclipse.core.boot");
            if (plugin != null) {
                ClasspathUtilCore.addDependency(plugin, false, relative, true, result, alreadyAdded);
            }
            if (!id.equals("org.eclipse.core.runtime") && (plugin = PDECore.getDefault().findPlugin("org.eclipse.core.runtime")) != null) {
                ClasspathUtilCore.addDependency(plugin, false, relative, true, result, alreadyAdded);
            }
        }
    }

    protected static void addJRE(Vector result) {
        result.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER")));
    }

    public static void addLibraries(IPluginModelBase model, boolean unconditionallyExport, boolean relative, Vector result) {
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        int i = 0;
        while (i < libraries.length) {
            IClasspathEntry entry = ClasspathUtilCore.createLibraryEntry(libraries[i], unconditionallyExport, relative);
            if (entry != null) {
                result.add(entry);
            }
            ++i;
        }
    }

    private static void addParentPlugin(IFragment fragment, boolean relative, Vector result, HashSet alreadyAdded) throws CoreException {
        IPlugin parent = PDECore.getDefault().findPlugin(fragment.getPluginId(), fragment.getPluginVersion(), fragment.getRule());
        if (parent != null) {
            ClasspathUtilCore.addDependency(parent, false, relative, false, result, alreadyAdded);
            IPluginImport[] imports = parent.getImports();
            int i = 0;
            while (i < imports.length) {
                IPlugin plugin;
                if (!imports[i].isReexported() && (plugin = PDECore.getDefault().findPlugin(imports[i].getId(), imports[i].getVersion(), imports[i].getMatch())) != null) {
                    ClasspathUtilCore.addDependency(plugin, false, relative, true, result, alreadyAdded);
                }
                ++i;
            }
        }
    }

    private static void addSourceAndLibraries(IPluginModelBase model, Vector result) throws CoreException {
        int i;
        IProject project = model.getUnderlyingResource().getProject();
        IBuildEntry[] buildEntries = ClasspathUtilCore.getBuildEntries(model, project);
        if (!WorkspaceModelManager.isBinaryPluginProject(project) && buildEntries.length == 0) {
            IPackageFragmentRoot[] roots = JavaCore.create((IProject)project).getPackageFragmentRoots();
            i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (root.getKind() == 1) {
                    result.add(JavaCore.newSourceEntry((IPath)root.getPath()));
                }
                ++i;
            }
        }
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        i = 0;
        while (i < libraries.length) {
            IClasspathEntry entry;
            IPluginLibrary library = libraries[i];
            boolean found = false;
            int j = 0;
            while (j < buildEntries.length) {
                IBuildEntry buildEntry = buildEntries[j];
                if (buildEntry.getName().equals("source." + library.getName())) {
                    String[] folders = buildEntry.getTokens();
                    int k = 0;
                    while (k < folders.length) {
                        IPath path = project.getFullPath().append(folders[k]);
                        if (path.toFile().exists()) {
                            result.add(JavaCore.newSourceEntry((IPath)path));
                        } else {
                            ClasspathUtilCore.addSourceFolder(folders[k], project, result);
                        }
                        ++k;
                    }
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found && (entry = ClasspathUtilCore.createLibraryEntry(library, library.isExported(), true)) != null) {
                result.add(entry);
            }
            ++i;
        }
    }

    protected static void addSourceFolder(String name, IProject project, Vector result) throws CoreException {
        IPath path = project.getFullPath().append(name);
        ClasspathUtilCore.ensureFolderExists(project, path);
        IClasspathEntry entry = JavaCore.newSourceEntry((IPath)path);
        result.add(entry);
    }

    private static void ensureFolderExists(IProject project, IPath folderPath) throws CoreException {
        IWorkspace workspace = project.getWorkspace();
        int i = 1;
        while (i <= folderPath.segmentCount()) {
            IPath partialPath = folderPath.uptoSegment(i);
            if (!workspace.getRoot().exists(partialPath)) {
                IFolder folder = workspace.getRoot().getFolder(partialPath);
                folder.create(true, true, null);
            }
            ++i;
        }
    }

    public static IClasspathEntry createContainerEntry() {
        Path path = new Path("org.eclipse.pde.core.requiredPlugins");
        return JavaCore.newContainerEntry((IPath)path);
    }

    private static IClasspathEntry createLibraryEntry(IPluginLibrary library, boolean unconditionallyExport, boolean relative) {
        try {
            String expandedName = ClasspathUtilCore.expandLibraryName(library.getName());
            boolean isExported = unconditionallyExport ? true : library.isFullyExported();
            IPluginModelBase model = library.getModel();
            IPath path = ClasspathUtilCore.getPath(model, expandedName);
            if (path == null) {
                if (model.isFragmentModel()) {
                    return null;
                }
                model = ClasspathUtilCore.resolveLibraryInFragments(library, expandedName);
                if (model == null) {
                    return null;
                }
                path = ClasspathUtilCore.getPath(model, expandedName);
            }
            if (relative && model.getUnderlyingResource() == null) {
                return JavaCore.newVariableEntry((IPath)EclipseHomeInitializer.createEclipseRelativeHome(path.toOSString()), (IPath)ClasspathUtilCore.getSourceAnnotation(model, expandedName, relative), null, (boolean)isExported);
            }
            return JavaCore.newLibraryEntry((IPath)path, (IPath)ClasspathUtilCore.getSourceAnnotation(model, expandedName, relative), null, (boolean)isExported);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static String expandLibraryName(String source) {
        if (source == null || source.length() == 0) {
            return "";
        }
        if (source.charAt(0) != '$') {
            return source;
        }
        Path path = new Path(source);
        String firstSegment = path.segment(0);
        if (firstSegment.charAt(firstSegment.length() - 1) != '$') {
            return source;
        }
        String variable = firstSegment.substring(1, firstSegment.length() - 1);
        if ((variable = variable.toLowerCase()).equals("ws")) {
            variable = TargetPlatform.getWS();
            if (variable != null) {
                variable = "ws" + File.separator + variable;
            }
        } else if (variable.equals("os")) {
            variable = TargetPlatform.getOS();
            if (variable != null) {
                variable = "os" + File.separator + variable;
            }
        } else {
            variable = null;
        }
        if (variable != null) {
            path = path.removeFirstSegments(1);
            return String.valueOf(variable) + '/' + path.toString();
        }
        return source;
    }

    private static IBuildEntry[] getBuildEntries(IPluginModelBase model, IProject project) throws CoreException {
        IFile buildFile;
        IBuildModel buildModel = model.getBuildModel();
        if (buildModel == null && (buildFile = project.getFile("build.properties")).exists()) {
            buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
        }
        if (buildModel != null) {
            return buildModel.getBuild().getBuildEntries();
        }
        return new IBuildEntry[0];
    }

    private static IPath getSourceAnnotation(IPluginModelBase model, String libraryName, boolean relative) throws CoreException {
        String zipName;
        IPath path = null;
        int dot = libraryName.lastIndexOf(46);
        if (dot != -1 && (path = ClasspathUtilCore.getPath(model, zipName = String.valueOf(libraryName.substring(0, dot)) + "src.zip")) == null) {
            IResource resource = model.getUnderlyingResource();
            SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
            path = manager.findVariableRelativePath(model.getPluginBase(), (IPath)new Path(zipName));
            if (path != null && (!relative || resource != null && !resource.getProject().hasNature("org.eclipse.jdt.core.javanature") || resource != null && resource.isLinked())) {
                path = JavaCore.getResolvedVariablePath((IPath)path);
            }
        }
        return path;
    }

    private static IPluginModelBase resolveLibraryInFragments(IPluginLibrary library, String libraryName) {
        IFragment[] fragments = PDECore.getDefault().findFragmentsFor(library.getPluginBase().getId(), library.getPluginBase().getVersion());
        int i = 0;
        while (i < fragments.length) {
            IPath path = ClasspathUtilCore.getPath(fragments[i].getModel(), libraryName);
            if (path != null) {
                return fragments[i].getModel();
            }
            ++i;
        }
        return null;
    }

    private static IPath getPath(IPluginModelBase model, String libraryName) {
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            IResource jarFile = resource.getProject().findMember(libraryName);
            if (jarFile != null) {
                return jarFile.getFullPath();
            }
        } else {
            IPath path = new Path(model.getInstallLocation()).append(libraryName);
            if (path.toFile().exists()) {
                return path;
            }
        }
        return null;
    }
}

