/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.selena.profiles;

import com.togethersoft.selena.profiles.DefaultProfileDescriptor;
import com.togethersoft.selena.profiles.IProfileDescriptor;
import com.togethersoft.selena.profiles.ProfilesPlugin;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;

public class ProfilesRegistryReader {
    static final String TAG_PROFILE = "profile";
    static final String ATT_PROFILE_ID = "id";
    static final String ATT_PROFILE_NAME = "name";
    static final String ATT_PROFILE_NATURE = "nature";
    static final String ATT_PROFILE_ANTINATURE = "antinature";
    static final String ATT_PROFILE_ICON = "icon";
    private static ProfilesRegistryReader myInstance;
    private ArrayList myProfiles = null;

    public static ProfilesRegistryReader getInstance() {
        if (myInstance == null) {
            myInstance = new ProfilesRegistryReader();
        }
        return myInstance;
    }

    public IProfileDescriptor[] getProfiles() {
        if (this.myProfiles == null) {
            this.myProfiles = new ArrayList();
            this.readRegistry();
        }
        IProfileDescriptor[] iProfileDescriptorArray = new IProfileDescriptor[this.myProfiles.size()];
        this.myProfiles.toArray(iProfileDescriptorArray);
        return iProfileDescriptorArray;
    }

    private void readRegistry() {
        IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
        String string = ProfilesPlugin.getDefault().getDescriptor().getUniqueIdentifier();
        String string2 = "profiles";
        IExtensionPoint iExtensionPoint = iPluginRegistry.getExtensionPoint(string, string2);
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        IConfigurationElement[] iConfigurationElementArray = null;
        int n = 0;
        while (n < iExtensionArray.length) {
            iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                this.readElement(iConfigurationElementArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    private void readElement(IConfigurationElement iConfigurationElement) {
        if (TAG_PROFILE.equals(iConfigurationElement.getName())) {
            this.registerProfile(iConfigurationElement);
        }
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            this.readElement(iConfigurationElementArray[n]);
            ++n;
        }
    }

    private void registerProfile(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getDeclaringExtension().getUniqueIdentifier();
        String string2 = iConfigurationElement.getAttribute(ATT_PROFILE_ID);
        String string3 = iConfigurationElement.getAttribute(ATT_PROFILE_NAME);
        String string4 = iConfigurationElement.getAttribute(ATT_PROFILE_NATURE);
        String string5 = iConfigurationElement.getAttribute(ATT_PROFILE_ANTINATURE);
        String string6 = iConfigurationElement.getAttribute(ATT_PROFILE_ICON);
        if (string3 != null && string4 != null) {
            this.myProfiles.add(new DefaultProfileDescriptor(string2, string3, string4, string5, string6));
        }
    }
}

