/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.datasvc.ejb;

import com.sap.caf.km.datasvc.CAFDataServiceImpl;
import com.sap.caf.km.datasvc.data.BO;
import com.sap.caf.km.datasvc.data.BODescription;
import com.sap.caf.km.datasvc.data.BOInstance;
import com.sap.caf.km.datasvc.data.Relation;
import com.sap.caf.km.datasvc.exceptions.AccessDeniedException;
import com.sap.caf.km.datasvc.exceptions.DataServiceWSException;
import com.sap.caf.rt.exception.CAFBaseException;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class CAFDataServiceBean
implements SessionBean {
    private static final String jARMRequest = "CAF:RT:cafdataservice";
    private static final Location location = Location.getLocation((Class)(class$com$sap$caf$km$datasvc$ejb$CAFDataServiceBean == null ? (class$com$sap$caf$km$datasvc$ejb$CAFDataServiceBean = CAFDataServiceBean.class$("com.sap.caf.km.datasvc.ejb.CAFDataServiceBean")) : class$com$sap$caf$km$datasvc$ejb$CAFDataServiceBean));
    private transient CAFDataServiceImpl browser = null;
    private transient SessionContext myContext;
    static /* synthetic */ Class class$com$sap$caf$km$datasvc$ejb$CAFDataServiceBean;

    public void ejbRemove() {
        String method = "ejbRemove()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[0]);
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
    }

    public void ejbActivate() {
        String method = "ejbActivate()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[0]);
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
    }

    public void ejbPassivate() {
        String method = "ejbPassivate()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[0]);
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
    }

    public void setSessionContext(SessionContext context) {
        String method = "setSessionContext(SessionContext)";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{context});
        this.myContext = context;
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
    }

    public void ejbCreate() throws CreateException {
        String method = "ejbCreate()";
        CAFPublicLogger.entering(null, (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[0]);
        try {
            this.browser = new CAFDataServiceImpl();
        }
        catch (DataAccessException e) {
            throw new CreateException("Could not initialize caf data service");
        }
        CAFPublicLogger.exiting(null, (String)jARMRequest, (String)method, (Location)location);
    }

    public BODescription[] getAllBOs() throws DataServiceWSException {
        String method = "getAllBOs()";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[0]);
        BODescription[] tmp = new BODescription[]{};
        try {
            tmp = this.browser.getAllBOs();
        }
        catch (DataAccessException ex) {
            throw new DataServiceWSException((CAFBaseException)ex);
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    public Relation[] getAssociatedBOs(String guidBO) throws DataServiceWSException {
        String method = "getAssociatedBOs(String)";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO});
        Relation[] tmp = new Relation[]{};
        try {
            tmp = this.browser.getAssociatedBOs(guidBO);
        }
        catch (DataAccessException ex) {
            throw new DataServiceWSException((CAFBaseException)ex);
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    public Relation[] getAggregatedBOs(String guidBO) throws DataServiceWSException {
        String method = "getAggregatedBOs(String)";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO});
        Relation[] tmp = new Relation[]{};
        try {
            tmp = this.browser.getAggregatedBOs(guidBO);
        }
        catch (DataAccessException ex) {
            throw new DataServiceWSException((CAFBaseException)ex);
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    public BO getBO(String provider, String application, String bo) throws DataServiceWSException {
        String method = "getBO(String, String, String)";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{provider, application, bo});
        BO tmp = null;
        try {
            tmp = this.browser.getBO(provider, application, bo);
        }
        catch (DataAccessException ex) {
            throw new DataServiceWSException((CAFBaseException)ex);
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    public BO getBOByGUID(String guid) throws DataServiceWSException {
        String method = "getBOByGUID(String)";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guid});
        BO tmp = null;
        try {
            tmp = this.browser.getBOByGUID(guid);
        }
        catch (DataAccessException ex) {
            throw new DataServiceWSException((CAFBaseException)ex);
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    public BOInstance getBOInstance(String guidBO, String guidInstance) throws DataServiceWSException, AccessDeniedException {
        String method = "getBOInstance(String, String)";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidInstance});
        BOInstance tmp = null;
        try {
            tmp = this.browser.getBOInstance(guidBO, guidInstance);
        }
        catch (DataAccessException ex) {
            throw new DataServiceWSException((CAFBaseException)ex);
        }
        catch (CAFPermissionException ex4) {
            throw new AccessDeniedException("Access denied");
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    public String[] getInstancesByGUIDPart(String guidBO, String guidPart) throws DataServiceWSException {
        String method = "getInstancesByGUIDPart(String, String)";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidPart});
        String[] guids = null;
        try {
            guids = this.browser.getInstancesByGUIDPart(guidBO, guidPart);
        }
        catch (DataAccessException ex) {
            throw new DataServiceWSException((CAFBaseException)ex);
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return guids;
    }

    public String[] getRelatedInstancesByGUIDPart(String guidBO, String guidRelation, String guidInstance, String guidPart) throws DataServiceWSException {
        String method = "getRelatedInstancesByGUIDPart(String, String, String, String)";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidRelation, guidInstance, guidPart});
        String[] guids = null;
        try {
            guids = this.browser.getRelatedInstancesByGUIDPart(guidBO, guidRelation, guidInstance, guidPart);
        }
        catch (DataAccessException ex) {
            throw new DataServiceWSException((CAFBaseException)ex);
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return guids;
    }

    public BO getRelatedBOByRelationGUID(String relationGuid) throws DataServiceWSException {
        String method = "getRelatedBOByRelationGUID(String)";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{relationGuid});
        BO bo = null;
        try {
            try {
                bo = this.browser.getRelatedBOByRelationGUID(relationGuid);
            }
            catch (DataAccessException ex) {
                throw new DataServiceWSException((CAFBaseException)ex);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
            throw throwable;
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return bo;
    }

    public String[] getPopulatedFolders(String guid, int noDigits, String startGuid) throws DataServiceWSException {
        String method = "getPopulatedFolders(String, int, String)";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guid, new Integer(noDigits), startGuid});
        String[] guids = null;
        try {
            try {
                guids = this.browser.getPopulatedFolders(guid, noDigits, startGuid);
            }
            catch (DataAccessException ex) {
                throw new DataServiceWSException((CAFBaseException)ex);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
            throw throwable;
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return guids;
    }

    public String[] getRelatedPopulatedFolders(String guidBO, String guidRelation, String guidInstance, int digits, String guidPart) throws DataServiceWSException {
        String method = "getRelatedPopulatedFolders(String, String, String, int, String)";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidRelation, guidInstance, new Integer(digits), guidPart});
        String[] guids = null;
        try {
            try {
                guids = this.browser.getRelatedPopulatedFolders(guidBO, guidRelation, guidInstance, digits, guidPart);
            }
            catch (DataAccessException ex) {
                throw new DataServiceWSException((CAFBaseException)ex);
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
            throw throwable;
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return guids;
    }

    public Relation[] getComplexAttributes(String guidBO, String[] guidRelation) throws DataServiceWSException {
        String method = "getComplexAttributes(String, String[])";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidRelation});
        Relation[] tmp = new Relation[]{};
        try {
            try {
                tmp = this.browser.getComplexAttributes(guidBO, guidRelation);
            }
            catch (DataAccessException ex) {
                throw new DataServiceWSException((CAFBaseException)ex);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
            throw throwable;
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    public String[] getComplexAttributeInstances(String guidBO, String guidInstance, String[] guidRelation, String[] guidDOInstance) throws DataServiceWSException {
        String method = "getComplexAttributeInstances(String, String, String[], String[])";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidInstance, guidRelation, guidDOInstance});
        String[] tmp = new String[]{};
        try {
            try {
                tmp = this.browser.getComplexAttributeInstances(guidBO, guidInstance, guidRelation, guidDOInstance);
            }
            catch (DataAccessException ex) {
                throw new DataServiceWSException((CAFBaseException)ex);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
            throw throwable;
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    public BO getComplexAttribute(String guidDO) throws DataServiceWSException {
        String method = "getComplexAttribute(String)";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidDO});
        BO tmp = null;
        try {
            try {
                tmp = this.browser.getComplexAttribute(guidDO);
            }
            catch (DataAccessException ex) {
                throw new DataServiceWSException((CAFBaseException)ex);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
            throw throwable;
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    public BOInstance getComplexAttributeInstance(String guidBO, String guidBOInstance, String[] guidRelation, String[] guidDOInstance) throws DataServiceWSException, AccessDeniedException {
        String method = "getComplexAttributeInstance(String, String, String[], String[]";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidBOInstance, guidRelation, guidDOInstance});
        BOInstance tmp = null;
        try {
            try {
                tmp = this.browser.getComplexAttributeInstance(guidBO, guidBOInstance, guidRelation, guidDOInstance);
            }
            catch (DataAccessException ex) {
                throw new DataServiceWSException((CAFBaseException)ex);
            }
            catch (CAFPermissionException ex4) {
                throw new AccessDeniedException("Access denied");
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
            throw throwable;
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    public String[] getRelatedKMObjects(String fullBOName) throws DataServiceWSException {
        String method = "getRelatedKMObjects(String)";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{fullBOName});
        String[] tmp = null;
        try {
            try {
                tmp = this.browser.getRelatedKMObjects(fullBOName);
            }
            catch (DataAccessException ex) {
                throw new DataServiceWSException((CAFBaseException)ex);
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
            throw throwable;
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    public boolean[] checkRights(String guidBO, String guidInstance, String[] rightsToCheck) throws DataServiceWSException, AccessDeniedException {
        String method = "checkRights(String, String, String[])";
        CAFPublicLogger.entering((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location, (Object[])new Object[]{guidBO, guidInstance, rightsToCheck});
        boolean[] tmp = null;
        try {
            try {
                tmp = this.browser.checkRights(guidBO, this.myContext.getCallerPrincipal().getName(), guidInstance, rightsToCheck);
            }
            catch (DataAccessException ex) {
                throw new DataServiceWSException((CAFBaseException)ex);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
            throw throwable;
        }
        CAFPublicLogger.exiting((String)this.myContext.getCallerPrincipal().getName(), (String)jARMRequest, (String)method, (Location)location);
        return tmp;
    }

    public boolean isConnectionLoopbackAlive() throws DataServiceWSException {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

