/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.archivebuilder.project;

import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.ColumnIterator;
import com.sap.sql.catalog.Table;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.core.resources.IProject;

public class MetamodelCatalogReader
implements CatalogReader {
    Vector mRoots = new Vector();

    public MetamodelCatalogReader(String projectName) {
        this.addProject(projectName);
    }

    public MetamodelCatalogReader(IProject project) {
        this(project.getName());
    }

    public void addProject(IProject project) {
        String projectName = project.getName();
        this.addProject(projectName);
    }

    public void addProject(String projectName) {
        DtDictionaryRoot root = DataSourceManager.getDataSourceManager((String)projectName).getDictionaryRoot();
        this.mRoots.add(root);
    }

    public boolean existsTable(String tableName) throws SQLException {
        int i = 0;
        while (i < this.mRoots.size()) {
            DtDictionaryRoot root = (DtDictionaryRoot)this.mRoots.get(i);
            if (root.hasTable("", tableName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean existsTable(String schemaName, String tableName) throws SQLException {
        int i = 0;
        while (i < this.mRoots.size()) {
            DtDictionaryRoot root = (DtDictionaryRoot)this.mRoots.get(i);
            if (root.hasTable("", tableName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Table getTable(String tableName) throws SQLException {
        try {
            int i = 0;
            while (i < this.mRoots.size()) {
                DtDbTable dtDbTable;
                DtDictionaryRoot root = (DtDictionaryRoot)this.mRoots.get(i);
                if (!root.isValid()) {
                    String projectName = root.getMetamodel().getName();
                    root = DataSourceManager.getDataSourceManager((String)projectName).getDictionaryRoot();
                    this.mRoots.set(i, root);
                }
                if ((dtDbTable = root.getTable("", tableName)) != null) {
                    return new MetamodelTable(dtDbTable);
                }
                ++i;
            }
        }
        catch (LoadException e) {
            throw new SQLException(e.getMessage());
        }
        return null;
    }

    public Table getTable(String schemaName, String tableName) throws SQLException {
        return this.getTable(tableName);
    }

    public boolean isLogicalCatalogReader() {
        return true;
    }

    private class MetamodelColumn
    implements Column {
        DtDbTable mDtDbTable;
        DtField mDtField;
        Table mTable;

        public MetamodelColumn(Table table, DtDbTable dtDbTable, DtField field) {
            this.mDtField = field;
            this.mTable = table;
            this.mDtDbTable = dtDbTable;
        }

        public int getDecimals() {
            return this.mDtField.getFractionDigits();
        }

        public Object getDefault() {
            return null;
        }

        public int getJdbcType() {
            String typeName = this.getTypeName();
            if (typeName.equals("BLOB")) {
                return 2004;
            }
            if (typeName.equals("BINARY")) {
                return -2;
            }
            if (typeName.equals("LONGVARBINARY")) {
                return -4;
            }
            if (typeName.equals("DATE")) {
                return 91;
            }
            if (typeName.equals("DECIMAL")) {
                return 3;
            }
            if (typeName.equals("DOUBLE")) {
                return 8;
            }
            if (typeName.equals("REAL")) {
                return 7;
            }
            if (typeName.equals("INTEGER")) {
                return 4;
            }
            if (typeName.equals("BIGINT")) {
                return -5;
            }
            if (typeName.equals("SMALLINT")) {
                return 5;
            }
            if (typeName.equals("CLOB")) {
                return 2005;
            }
            if (typeName.equals("VARCHAR")) {
                return 12;
            }
            if (typeName.equals("LONGVARCHAR")) {
                return -1;
            }
            if (typeName.equals("TIME")) {
                return 92;
            }
            if (typeName.equals("TIMESTAMP")) {
                return 93;
            }
            return 1111;
        }

        public String getName() {
            return this.mDtField.getName();
        }

        public int getPosition() {
            return this.mDtField.getPosition();
        }

        public int getPrimaryKeyPosition() {
            if (this.mDtDbTable.hasPrimaryKey()) {
                return this.mDtDbTable.getPrimaryKey().getKeyElementPosition((DtStructureElement)this.mDtField);
            }
            return 0;
        }

        public long getSize() {
            if (this.mDtField.getTotalDigits() > 0) {
                return this.mDtField.getTotalDigits();
            }
            return this.mDtField.getLength();
        }

        public Table getTable() {
            return this.mTable;
        }

        public String getTypeName() {
            if (this.mDtField.getBuiltInType() == null || this.mDtField.getBuiltInType().length() == 0) {
                DtSimpleType st = (DtSimpleType)this.mDtField.getReferencedType();
                return st.getDbProperty().getJdbcTypeName();
            }
            return this.mDtField.getJdbcTypeName();
        }

        public boolean isNullable() {
            return new Boolean(this.mDtField.getNotNull().toString()) == false;
        }

        public boolean isPrimaryKey() {
            if (this.mDtDbTable.hasPrimaryKey()) {
                return this.mDtDbTable.getPrimaryKey().hasKeyElement((DtStructureElement)this.mDtField);
            }
            return false;
        }

        public String toString() {
            return this.mTable.getName() + "," + this.mDtField.getName() + ", " + this.mDtField.getJdbcTypeName();
        }
    }

    private class MetamodelTable
    implements Table {
        private DtDbTable mDtDbTable;

        public MetamodelTable(DtDbTable dtTable) {
            this.mDtDbTable = dtTable;
        }

        public int getBufferKeyCnt() {
            return this.mDtDbTable.getTechnicalSettings().getGenKeyCount();
        }

        public Column getClientColumn() {
            return null;
        }

        public Column getColumn(int pos) {
            if (pos - 1 < this.mDtDbTable.getStructureElementCount()) {
                DtField field = (DtField)this.mDtDbTable.getStructureElement(pos - 1);
                if (field == null) {
                    return null;
                }
                return new MetamodelColumn(this, this.mDtDbTable, field);
            }
            return null;
        }

        public Column getColumn(String columnName) {
            DtField field = (DtField)this.mDtDbTable.getStructureElement(columnName);
            if (field == null) {
                return null;
            }
            return new MetamodelColumn(this, this.mDtDbTable, field);
        }

        public int getColumnCnt() {
            return this.mDtDbTable.getStructureElementCount();
        }

        public ColumnIterator getColumns() {
            MetamodelTable table = this;
            return new ColumnIterator(this, table){
                int pos;
                int columnCount;
                DtStructureElement[] elements;
                private final /* synthetic */ Table val$table;
                private final /* synthetic */ MetamodelTable this$1;
                {
                    this.this$1 = this$1;
                    this.val$table = val$table;
                    this.pos = 0;
                    this.columnCount = MetamodelTable.access$000(this.this$1).getStructureElementCount();
                    this.elements = MetamodelTable.access$000(this.this$1).getStructureElements();
                }

                public boolean hasNext() {
                    return this.pos < this.columnCount;
                }

                public Column next() {
                    MetamodelColumn column = MetamodelTable.access$100(this.this$1).new MetamodelColumn(this.val$table, MetamodelTable.access$000(this.this$1), (DtField)this.elements[this.pos]);
                    ++this.pos;
                    return column;
                }
            };
        }

        public String getName() {
            return this.mDtDbTable.getName();
        }

        public int getPrimaryKeyCnt() {
            if (this.mDtDbTable.hasPrimaryKey()) {
                return this.mDtDbTable.getPrimaryKey().getKeyElementCount();
            }
            return 0;
        }

        public Column getPrimaryKeyColumn(int pos) {
            return new MetamodelColumn(this, this.mDtDbTable, (DtField)this.mDtDbTable.getStructureElement(pos - 1));
        }

        public String getSchemaName() {
            return null;
        }

        public int getTableType() {
            return 1;
        }

        public boolean isClientDependent() {
            return this.mDtDbTable.getMultiClientEnabled();
        }

        static /* synthetic */ DtDbTable access$000(MetamodelTable x0) {
            return x0.mDtDbTable;
        }

        static /* synthetic */ MetamodelCatalogReader access$100(MetamodelTable x0) {
            return x0.MetamodelCatalogReader.this;
        }
    }
}

