/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.archivebuilder.project;

import com.sap.dictionary.tools.archivebuilder.ProjectwizardPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class DictionaryNatureAction
implements IActionDelegate,
IRunnableWithProgress {
    private IProject mProject = null;

    public DictionaryNatureAction(IProject project) {
        this.setProject(project);
    }

    public void run() {
        final DictionaryNatureAction me = this;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                WorkspaceModifyDelegatingOperation operation = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)me);
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(DictionaryNatureAction.getShell());
                try {
                    dialog.run(false, true, (IRunnableWithProgress)operation);
                }
                catch (Exception ex) {
                    ProjectwizardPlugin.logError(ex);
                }
            }
        });
    }

    public void run(IAction action) {
        this.run();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            DictionaryNatureAction.addNature(this.mProject, "com.sap.dictionary.tools.archivebuilder.DictionaryNature", monitor);
        }
        catch (CoreException ex) {
            throw new InvocationTargetException(ex);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private static void addNature(IProject project, String id, IProgressMonitor monitor) throws CoreException {
        IProjectDescription lDescription = project.getDescription();
        String[] lNatures = lDescription.getNatureIds();
        if (!DictionaryNatureAction.hasNature(lNatures, id)) {
            lNatures = DictionaryNatureAction.addNature(lNatures, id);
            lDescription.setNatureIds(lNatures);
            project.setDescription(lDescription, monitor);
        }
    }

    private static boolean hasNature(String[] natures, String id) {
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String[] addNature(String[] natures, String id) {
        String[] lResult = new String[natures.length + 1];
        System.arraycopy(natures, 0, lResult, 1, natures.length);
        lResult[0] = id;
        return lResult;
    }

    private static Shell getShell() {
        return DictionaryNatureAction.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public IProject getProject() {
        return this.mProject;
    }

    private void setProject(IProject project) {
        this.mProject = project;
    }
}

