/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.archivebuilder.project;

import com.sap.dictionary.database.catalog.XmlCatalogReader;
import com.sap.dictionary.tools.archivebuilder.ProjectwizardPlugin;
import com.sap.dictionary.tools.archivebuilder.project.MetamodelCatalogReader;
import com.sap.dictionary.tools.generation.eclipse.GenerationEclipse;
import com.sap.dictionary.tools.generation.eclipse.GenerationPlugin;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.eclipse.dii.component.IDCExtendedProject;
import com.sap.ide.eclipse.dii.component.IProjectUpdatedListener;
import com.sap.ide.eclipse.dii.component.ProjectConsistencyManager;
import com.sap.ide.eclipse.dii.component.ProjectUpdatedEvent;
import com.sap.ide.metamodel.core.dc.DevComponentService;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.dictionary.project.IDictionaryProject;
import com.sap.sql.catalog.CachedCatalogReader;
import com.sap.sql.catalog.CatalogReader;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public final class DictionaryNature
implements IProjectNature,
IDictionaryProject,
IResourceDeltaVisitor {
    public static final String NATURE_ID = "com.sap.dictionary.tools.archivebuilder.DictionaryNature";
    private IProject mProject;
    private CatalogReader mDesigntimeCatalogReader;
    private CachedCatalogReader mRuntimeCatalogReader;
    private IProjectUpdatedListener mListener;
    private IResourceChangeListener mResourceChangeListener;

    public IProject getProject() {
        return this.mProject;
    }

    public void setProject(IProject project) {
        this.mProject = project;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (this.mRuntimeCatalogReader != null) {
            IResource resource = delta.getResource();
            if (resource instanceof File && resource.getProject().equals((Object)this.getProject()) && resource.getFileExtension().equals("gdbtable")) {
                String name = resource.getName();
                name = name.substring(0, name.indexOf("gdbtable"));
                this.mRuntimeCatalogReader.invalidateTable(name);
            }
            return true;
        }
        return false;
    }

    public void configure() throws CoreException {
        GenerationPlugin.addBuilder((IProject)this.getProject());
    }

    public void deconfigure() throws CoreException {
        GenerationPlugin.removeBuilder((IProject)this.getProject());
    }

    public IDictionaryProject getDictionaryProject() {
        return this;
    }

    public CatalogReader getDesigntimeCatalogReader() {
        if (this.mDesigntimeCatalogReader != null) {
            return this.mDesigntimeCatalogReader;
        }
        this.mDesigntimeCatalogReader = new MetamodelCatalogReader(this.getProject());
        return this.mDesigntimeCatalogReader;
    }

    public CachedCatalogReader getRuntimeCatalogReader() {
        if (this.mRuntimeCatalogReader != null) {
            return this.mRuntimeCatalogReader;
        }
        IPath dictionaryGenSrcPathDbTables = this.getProject().getLocation().append(GenerationEclipse.getGenerationOutputPathInfix() + "/" + "dbtables");
        String path = dictionaryGenSrcPathDbTables.toOSString();
        try {
            XmlCatalogReader reader = new XmlCatalogReader(path);
            this.mRuntimeCatalogReader = new CachedCatalogReader((CatalogReader)reader);
            CatalogReader ppreader = DictionaryNature.getCatalogReaderForPPJars(this.getProject());
            if (ppreader != null) {
                this.mRuntimeCatalogReader.addReader(ppreader);
            }
            if (this.mRuntimeCatalogReader != null) {
                this.addProjectListener();
                this.addResourceChangeListener();
            }
        }
        catch (SQLException e) {
            ProjectwizardPlugin.tracer.error("get catalog reader", (Throwable)e);
            return null;
        }
        return this.mRuntimeCatalogReader;
    }

    private void addResourceChangeListener() {
        if (this.mResourceChangeListener == null) {
            final DictionaryNature instance = this;
            this.mResourceChangeListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    try {
                        IResourceDelta delta = event.getDelta();
                        if (delta != null) {
                            delta.accept((IResourceDeltaVisitor)instance);
                        }
                    }
                    catch (CoreException e) {
                        ProjectwizardPlugin.tracer.error("resource visitor", (Throwable)e);
                    }
                }
            };
            this.getProject().getWorkspace().addResourceChangeListener(this.mResourceChangeListener);
        }
    }

    private void addProjectListener() {
        IDCExtendedProject componentProject = ServicesEclipse.getComponentProject((String)this.getProject().getName());
        if (componentProject != null) {
            IDevelopmentConfiguration developmentConfiguration = ComponentUtil.getParentDevConf((IProject)this.getProject());
            if (this.mListener == null) {
                this.mListener = new IProjectUpdatedListener(){

                    public void projectUpdated(ProjectUpdatedEvent arg0) {
                        if (DictionaryNature.this.mRuntimeCatalogReader != null) {
                            DictionaryNature.this.mRuntimeCatalogReader.close();
                            DictionaryNature.this.mRuntimeCatalogReader = null;
                            DictionaryNature.this.getRuntimeCatalogReader();
                        }
                    }
                };
                if (developmentConfiguration != null) {
                    ProjectConsistencyManager.getInstance((IDevelopmentConfiguration)developmentConfiguration).addProjectUpdateListener(this.mListener);
                }
            }
        }
    }

    public static CatalogReader getCatalogReaderForPPJars(IProject project) {
        try {
            Vector<String> list = new Vector<String>();
            IJavaProject jProject = JavaCore.create((IProject)project);
            IClasspathEntry[] cpEntries = jProject.getRawClasspath();
            int i = 0;
            while (i < cpEntries.length) {
                String path;
                String value;
                if (1 == cpEntries[i].getEntryKind() && (value = DevComponentService.getPublicPartManifestAttributeValue((String)(path = cpEntries[i].getPath().toOSString()), (String)"DC-Type")) != null && value.length() > 0) {
                    list.add(path);
                }
                ++i;
            }
            StringBuffer str = new StringBuffer();
            int i2 = 0;
            while (i2 < list.size()) {
                if (i2 != 0) {
                    str.append(";");
                }
                str.append(list.get(i2));
                ++i2;
            }
            String path = str.toString();
            if (path != null && path.length() > 0) {
                return new XmlCatalogReader(path);
            }
        }
        catch (JavaModelException e) {
            ProjectwizardPlugin.tracer.error("get java project", (Throwable)e);
        }
        catch (SQLException e2) {
            ProjectwizardPlugin.tracer.error("create XmlCatalogReader", (Throwable)e2);
        }
        return null;
    }
}

