/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.archivebuilder;

import com.sap.dictionary.tools.archivebuilder.ProjectwizardPlugin;
import com.sap.dictionary.tools.archivebuilder.TextPool;
import com.sap.dictionary.tools.archivebuilder.ui.AsyncUIServices;
import com.sap.dictionary.tools.generation.eclipse.GenerationEclipse;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.dii.component.IDCProject;
import com.tssap.selena.model.elements.Element;
import com.tssap.tools.archive.ArchiveBuildException;
import com.tssap.tools.archive.ArchiveBuilder;
import com.tssap.tools.archive.ArchiveDescriptionManager;
import com.tssap.tools.archive.IArchiveDescriptor;
import com.tssap.tools.archive.IComponentBuildInfo;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.IMutablePattern;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.IProjectFileSet;
import com.tssap.tools.archive.Pattern;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class PopupBuild {
    private boolean gdbTableFound = false;
    private String deployFileContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SDA>   <SoftwareType>JDDSCHEMA</SoftwareType></SDA>";
    private static boolean myFlag = false;
    private Shell myShell;
    private Element myElement;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myShell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        Object[] arguments = new Object[]{};
        Class[] parameterTypes = new Class[]{};
        new AsyncUIServices().openAnimatedProgressDialog(true, this, "createArchive", arguments, parameterTypes, TextPool.CREATE_ARCHIVE);
    }

    public void setSelectedElement(Element element) {
        this.myElement = element;
    }

    public void createArchive(IProgressMonitor monitor) throws ArchiveBuildException {
        if (this.myElement == null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)TextPool.COULDNT_CREATE_ARCHIVE);
                }
            });
            return;
        }
        String projectName = this.myElement.getModel().getUniqueName().getName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        try {
            this.gdbTableFound = false;
            project.getFolder(GenerationEclipse.getGenerationOutputPathInfix() + "/" + "dbtables").accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof File) {
                        if (resource.getFileExtension().compareTo("gdbtable") == 0) {
                            PopupBuild.this.gdbTableFound = true;
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            ProjectwizardPlugin.tracer.error("search gdbtables", (Throwable)e);
        }
        if (!this.gdbTableFound) {
            this.callGeneration(monitor, project, "", "", "");
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)TextPool.CREATING_ARCHIVE, (String)TextPool.NO_GEN_TABLES_FOUND);
                }
            });
            return;
        }
        final IArchiveDescriptor arDesc = ArchiveDescriptionManager.newArchiveDescription();
        IProjectFileSet fs = ArchiveDescriptionManager.getProjectFileSet();
        IMutablePattern pattern = Pattern.getEmptyPattern();
        pattern.addIncludePattern("**/*.gdbtable");
        fs.addProjectFiles((IContainer)project.getFolder(GenerationEclipse.getGenerationOutputPathInfix() + "/" + "dbtables"), (IPattern)pattern);
        arDesc.addFileSet((IFileSet)fs);
        IProjectNature nature = null;
        try {
            nature = project.getNature("com.sap.ide.eclipse.component.provider.dcnature");
        }
        catch (CoreException e) {
            ProjectwizardPlugin.tracer.error("get nature", (Throwable)e);
        }
        IFile file = null;
        if (nature instanceof IDCProject) {
            IFolder tempFolder;
            IDCProject compProj = (IDCProject)nature;
            String buildVariant = compProj.getBuildVariant();
            if (buildVariant == null) {
                buildVariant = "dbg";
            }
            if (!(tempFolder = project.getFolder("gen")).exists()) {
                try {
                    tempFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    ProjectwizardPlugin.tracer.error("create gen-Folder:", (Throwable)e);
                }
            }
            if (!(tempFolder = project.getFolder("gen/" + buildVariant)).exists()) {
                try {
                    tempFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    ProjectwizardPlugin.tracer.error("create gen/build Variant-Folder:", (Throwable)e);
                }
            }
            if (!(tempFolder = project.getFolder("gen/" + buildVariant + "/deploy")).exists()) {
                try {
                    tempFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    ProjectwizardPlugin.tracer.error("create gen/build/deploy Variant-Folder:", (Throwable)e);
                }
            }
            String pn = compProj.getDCName().replace('/', '~');
            String sdaName = compProj.getDCVendor() + "~" + pn + ".sda";
            file = tempFolder.getFile(sdaName);
            arDesc.setDestPath(file);
            IComponentBuildInfo buildInfo = arDesc.getComponentBuildInfo();
            buildInfo.setDeployFileContent(this.deployFileContent);
            buildInfo.getComponent().setVendor("sap.com");
            buildInfo.getComponent().setName(compProj.getDCName());
            buildInfo.setUseComponentBuild(true);
            this.callGeneration(monitor, project, sdaName, "sap.com", compProj.getDCName());
        } else {
            String sdaName = project.getName() + ".sda";
            file = project.getFile(sdaName);
            arDesc.setDestPath(file);
            IComponentBuildInfo buildInfo = arDesc.getComponentBuildInfo();
            buildInfo.setDeployFileContent(this.deployFileContent);
            buildInfo.getComponent().setVendor("sap.com");
            buildInfo.getComponent().setName(projectName);
            buildInfo.setUseComponentBuild(true);
            this.callGeneration(monitor, project, sdaName, "", "");
        }
        ArchiveBuilder.suppressMonitorDialog((boolean)true);
        final IProgressMonitor fMonitor = monitor;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                fMonitor.beginTask(TextPool.BUILDING_ARCHIVE, -1);
            }
        });
        try {
            final IFile fFile = file;
            final IProjectNature fNature = nature;
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    arDesc.performBuild();
                    if (fNature instanceof IDCProject) {
                        try {
                            fFile.refreshLocal(0, monitor);
                        }
                        catch (CoreException e) {
                            ProjectwizardPlugin.tracer.error("refresh local", (Throwable)e);
                        }
                        if (fFile.exists()) {
                            try {
                                fFile.setDerived(true);
                            }
                            catch (CoreException e) {
                                ProjectwizardPlugin.tracer.error("set derived flag of sda:", (Throwable)e);
                            }
                        }
                    } else {
                        try {
                            fFile.refreshLocal(0, monitor);
                        }
                        catch (CoreException e) {
                            ProjectwizardPlugin.tracer.error("refresh local", (Throwable)e);
                        }
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ProjectwizardPlugin.tracer.error("build archive and set derived flag", (Throwable)e);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)TextPool.COULDNT_CREATE_ARCHIVE);
                }
            });
        }
    }

    private void callGeneration(IProgressMonitor monitor, IProject project, String archiveName, String vendorName, String dcName) {
        final IProject fProject = project;
        final String fArchiveName = archiveName;
        final String fVendorName = vendorName;
        final String fDcName = dcName;
        final IProgressMonitor fMonitor = monitor;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this){
                        private final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run(IProgressMonitor monitor) throws CoreException {
                            try {
                                DtDictionaryRoot dictRoot = DataSourceManager.getDataSourceManager((String)7.access$100(this.this$1).getName()).getDictionaryRoot();
                                GenerationEclipse generator = new GenerationEclipse(monitor);
                                generator.setTargetPath(7.access$100(this.this$1).getLocation().toFile().getAbsolutePath());
                                generator.setIncremental(false);
                                generator.refreshConfiguration();
                                generator.generatePersistentArchive(7.access$200(this.this$1), 7.access$300(this.this$1), 7.access$400(this.this$1), dictRoot.getLogicalDictionaries(), dictRoot.getSimpleTypes(), dictRoot.getStructures(), dictRoot.getTables(), true, true, true);
                                generator.cleanup();
                            }
                            catch (LoadException e) {
                                ProjectwizardPlugin.tracer.error("get simpletypes and tables from metamodel", (Throwable)e);
                            }
                        }
                    }, fMonitor);
                }
                catch (CoreException e) {
                    ProjectwizardPlugin.tracer.error("run workspace runnable", (Throwable)e);
                }
            }

            static /* synthetic */ IProject access$100(7 x0) {
                return x0.fProject;
            }

            static /* synthetic */ String access$200(7 x0) {
                return x0.fArchiveName;
            }

            static /* synthetic */ String access$300(7 x0) {
                return x0.fVendorName;
            }

            static /* synthetic */ String access$400(7 x0) {
                return x0.fDcName;
            }
        });
    }
}

