/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.archivebuilder;

import com.sap.dictionary.tools.archivebuilder.DictionaryWizardProjectCreationPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.preferences.NewJavaProjectPreferencePage;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewDictionaryProjectWizardPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "NewJavaProjectWizardPage";
    private DictionaryWizardProjectCreationPage fMainPage;
    private IPath fOutputLocation;
    private IClasspathEntry[] fClasspathEntries;
    private boolean fAddJRE;
    private BuildPathsBlock fBuildPathsBlock;
    private boolean fProjectModified;

    public NewDictionaryProjectWizardPage(IWorkspaceRoot root, DictionaryWizardProjectCreationPage mainpage) {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.getString((String)"NewJavaProjectWizardPage.title"));
        this.setDescription(NewWizardMessages.getString((String)"NewJavaProjectWizardPage.description"));
        this.fMainPage = mainpage;
        IStatusChangeListener listener = new IStatusChangeListener(){

            public void statusChanged(IStatus status) {
                NewDictionaryProjectWizardPage.super.updateStatus(status);
            }
        };
        this.fBuildPathsBlock = new BuildPathsBlock(listener, 0);
        this.fProjectModified = true;
        this.fOutputLocation = null;
        this.fClasspathEntries = null;
        this.fAddJRE = false;
    }

    public NewDictionaryProjectWizardPage(IWorkspaceRoot root, DictionaryWizardProjectCreationPage mainpage, String projectName, IPath location) {
        super(PAGE_NAME);
        this.setTitle(NewWizardMessages.getString((String)"NewJavaProjectWizardPage.title"));
        this.setDescription(NewWizardMessages.getString((String)"NewJavaProjectWizardPage.description"));
        this.fMainPage = mainpage;
        this.fMainPage.setProjectName(projectName);
        this.fMainPage.setLocation(location);
        IStatusChangeListener listener = new IStatusChangeListener(){

            public void statusChanged(IStatus status) {
                NewDictionaryProjectWizardPage.super.updateStatus(status);
            }
        };
        this.fBuildPathsBlock = new BuildPathsBlock(listener, 0);
        this.fProjectModified = true;
        this.fOutputLocation = null;
        this.fClasspathEntries = null;
        this.fAddJRE = false;
    }

    public void setDefaultOutputFolder(IPath path) {
        this.fOutputLocation = path;
        this.setProjectModified();
    }

    public void setDefaultClassPath(IClasspathEntry[] entries, boolean appendDefaultJRE) {
        if (entries != null && appendDefaultJRE) {
            IClasspathEntry[] jreEntry = NewJavaProjectPreferencePage.getDefaultJRELibrary();
            IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + jreEntry.length];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            System.arraycopy(jreEntry, 0, newEntries, entries.length, jreEntry.length);
            entries = newEntries;
        }
        this.fClasspathEntries = entries;
        this.fAddJRE = appendDefaultJRE;
        this.setProjectModified();
    }

    public void setProjectModified() {
        this.fProjectModified = true;
    }

    protected IProject getProjectHandle() {
        Assert.isNotNull((Object)((Object)this.fMainPage));
        return this.fMainPage.getProjectHandle();
    }

    protected IPath getLocationPath() {
        Assert.isNotNull((Object)((Object)this.fMainPage));
        return this.fMainPage.getLocationPath();
    }

    public IJavaProject getNewJavaProject() {
        return JavaCore.create((IProject)this.getProjectHandle());
    }

    public void createControl(Composite parent) {
        Control control = this.fBuildPathsBlock.createControl(parent);
        this.setControl(control);
        WorkbenchHelp.setHelp((Control)control, (String)"org.eclipse.jdt.ui.new_javaproject_wizard_page_context");
    }

    protected void initBuildPaths() {
        this.fBuildPathsBlock.init(this.getNewJavaProject(), this.fOutputLocation, this.fClasspathEntries);
    }

    public void setVisible(boolean visible) {
        if (visible && (this.fProjectModified || this.isNewProjectHandle())) {
            this.initBuildPaths();
            this.fProjectModified = false;
        }
        super.setVisible(visible);
    }

    private boolean isNewProjectHandle() {
        IProject oldProject = this.fBuildPathsBlock.getJavaProject().getProject();
        return !oldProject.equals((Object)this.getProjectHandle());
    }

    public IPath getOutputLocation() {
        return this.fBuildPathsBlock.getOutputLocation();
    }

    public IClasspathEntry[] getRawClassPath() {
        return this.fBuildPathsBlock.getRawClassPath();
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(NewWizardMessages.getString((String)"NewJavaProjectWizardPage.op_desc"), 10);
                int workLeft = 10;
                if (NewDictionaryProjectWizardPage.this.fProjectModified || NewDictionaryProjectWizardPage.this.isNewProjectHandle()) {
                    NewDictionaryProjectWizardPage.this.initBuildPaths();
                }
                try {
                    try {
                        BuildPathsBlock.createProject((IProject)NewDictionaryProjectWizardPage.this.getProjectHandle(), (IPath)NewDictionaryProjectWizardPage.this.getLocationPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        BuildPathsBlock.addJavaNature((IProject)NewDictionaryProjectWizardPage.this.getProjectHandle(), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        NewDictionaryProjectWizardPage.this.fBuildPathsBlock.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 6));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
        };
    }
}

