/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.archivebuilder;

import com.sap.dictionary.tools.archivebuilder.ProjectwizardPlugin;
import com.sap.dictionary.tools.archivebuilder.TextPool;
import com.sap.ide.metamodel.general.exception.I18NException;
import com.sap.ide.metamodel.general.i18n.I18NService;
import com.sap.ide.metamodel.general.i18n.LanguageInfo;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class DictionaryWizardProjectCreationPage
extends WizardPage {
    private boolean useDefaults = true;
    private String initialProjectFieldValue;
    private IPath initialLocationFieldValue;
    private String customLocationFieldValue;
    private Text projectNameField;
    private Text locationPathField;
    private Label locationLabel;
    private Button browseButton;
    private boolean enabled = false;
    private String mProjectName;
    private String mProjectPath;
    private Combo mLanguageCombo = null;
    private LanguageInfo[] mLanguages = null;
    private String mSelLanguage = null;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            DictionaryWizardProjectCreationPage.this.setLocationForSelection();
            DictionaryWizardProjectCreationPage.this.setPageComplete(DictionaryWizardProjectCreationPage.this.validatePage());
        }
    };
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            DictionaryWizardProjectCreationPage.this.setPageComplete(DictionaryWizardProjectCreationPage.this.validatePage());
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final int SIZING_INDENTATION_WIDTH = 10;

    public DictionaryWizardProjectCreationPage(String pageName, boolean ena) {
        super(pageName);
        this.setPageComplete(false);
        this.initialLocationFieldValue = Platform.getLocation();
        this.customLocationFieldValue = "";
        this.initializeSAPspecifics();
        this.enabled = ena;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.ui.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        this.createSAPSpecificGroup(composite);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private void createSAPSpecificGroup(Composite parent) {
        IGridLayoutPane sapGroup = PaneFactory.createGridLayoutPane((Composite)parent, (int)2);
        if (this.enabled) {
            sapGroup.addTextLabel(TextPool.PROJECT_LANGUAGE);
            this.mLanguageCombo = sapGroup.addComboBox(this.getLanguageNames(), this.getDefaultLanguageName(), true);
            this.mLanguageCombo.setEnabled(this.enabled);
            this.mLanguageCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    DictionaryWizardProjectCreationPage.this.setPageComplete(DictionaryWizardProjectCreationPage.this.validatePage());
                }
            });
        }
    }

    private final void createProjectLocationGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectContentsLabel = new Label(projectGroup, 0);
        projectContentsLabel.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.projectContentsLabel"));
        GridData labelData = new GridData();
        labelData.horizontalSpan = 3;
        projectContentsLabel.setLayoutData((Object)labelData);
        final Button useDefaultsButton = new Button(projectGroup, 131104);
        useDefaultsButton.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.useDefaultLabel"));
        useDefaultsButton.setSelection(this.useDefaults);
        useDefaultsButton.setEnabled(this.enabled);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup(projectGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DictionaryWizardProjectCreationPage.this.useDefaults = useDefaultsButton.getSelection();
                DictionaryWizardProjectCreationPage.this.browseButton.setEnabled(!DictionaryWizardProjectCreationPage.this.useDefaults);
                DictionaryWizardProjectCreationPage.this.locationPathField.setEnabled(!DictionaryWizardProjectCreationPage.this.useDefaults);
                DictionaryWizardProjectCreationPage.this.locationLabel.setEnabled(!DictionaryWizardProjectCreationPage.this.useDefaults);
                if (DictionaryWizardProjectCreationPage.this.useDefaults) {
                    DictionaryWizardProjectCreationPage.this.customLocationFieldValue = DictionaryWizardProjectCreationPage.this.locationPathField.getText();
                    DictionaryWizardProjectCreationPage.this.setLocationForSelection();
                } else {
                    DictionaryWizardProjectCreationPage.this.locationPathField.setText(DictionaryWizardProjectCreationPage.this.customLocationFieldValue);
                }
            }
        };
        useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.nameLabel"));
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        if (this.mProjectName != null) {
            this.projectNameField.setText(this.mProjectName);
        }
        this.projectNameField.setEnabled(this.enabled);
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        this.locationLabel = new Label(projectGroup, 0);
        this.locationLabel.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.locationLabel"));
        this.locationLabel.setEnabled(enabled);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setEnabled(enabled);
        if (enabled) {
            this.locationPathField.setEnabled(this.enabled);
        }
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.browseLabel"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DictionaryWizardProjectCreationPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        if (this.initialLocationFieldValue != null) {
            this.locationPathField.setText(this.initialLocationFieldValue.toOSString());
        }
        if (this.mProjectPath != null) {
            this.locationPathField.setText(this.mProjectPath);
            this.setPageComplete(this.validatePage());
        } else {
            this.locationPathField.addListener(24, this.locationModifyListener);
        }
    }

    public IPath getLocationPath() {
        if (this.useDefaults) {
            return this.initialLocationFieldValue;
        }
        return new Path(this.getProjectLocationFieldValue());
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.mProjectName;
        }
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private String getProjectLocationFieldValue() {
        if (this.locationPathField == null) {
            return "";
        }
        return this.locationPathField.getText().trim();
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.directoryLabel"));
        String dirName = this.getProjectLocationFieldValue();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.customLocationFieldValue = selectedDirectory;
            this.locationPathField.setText(this.customLocationFieldValue);
        }
    }

    public void setInitialProjectName(String name) {
        this.initialProjectFieldValue = name == null ? null : name.trim();
    }

    private void setLocationForSelection() {
        if (this.useDefaults) {
            IPath defaultPath = Platform.getLocation().append(this.getProjectNameFieldValue());
            this.locationPathField.setText(defaultPath.toOSString());
        }
    }

    private boolean validatePage() {
        IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.projectNameEmpty"));
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        String locationFieldContents = this.getProjectLocationFieldValue();
        if (locationFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.projectLocationEmpty"));
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            this.setErrorMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.locationError"));
            return false;
        }
        if (!this.useDefaults && Platform.getLocation().isPrefixOf((IPath)new Path(locationFieldContents))) {
            this.setErrorMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.defaultLocationError"));
            return false;
        }
        if (this.getProjectHandle().exists()) {
            this.setErrorMessage(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.projectExistsMessage"));
            return false;
        }
        if (this.mLanguageCombo != null && this.mLanguageCombo.getSelectionIndex() == 0) {
            this.setErrorMessage(TextPool.PLEASE_SELECT_LANGUAGE);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    public void setProjectName(String name) {
        this.mProjectName = name;
    }

    public void setLocation(IPath path) {
        this.useDefaults = false;
        this.mProjectPath = path.toOSString();
    }

    private void initializeSAPspecifics() {
        I18NService service = I18NService.getInstance();
        try {
            this.mLanguages = service.getValidLanguages();
            Arrays.sort(this.mLanguages, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((LanguageInfo)o1).getDescription().compareTo(((LanguageInfo)o2).getDescription());
                }
            });
        }
        catch (I18NException e) {
            ProjectwizardPlugin.tracer.error("initialize languages ", (Throwable)e);
        }
    }

    private String[] getLanguageNames() {
        String[] names = new String[this.mLanguages.length + 1];
        names[0] = "";
        int i = 0;
        while (i < this.mLanguages.length) {
            names[i + 1] = this.mLanguages[i].getDescription();
            ++i;
        }
        return names;
    }

    private String getDefaultLanguageName() {
        int i = 0;
        while (i < this.mLanguages.length) {
            if (this.mLanguages[i].getName().equals("en")) {
                return this.mLanguages[i].getDescription();
            }
            ++i;
        }
        return "";
    }

    public String getSelectedLanguage() {
        if (this.mSelLanguage != null) {
            return this.mSelLanguage;
        }
        if (this.mLanguageCombo.getSelectionIndex() == 0) {
            return null;
        }
        return this.mLanguages[this.mLanguageCombo.getSelectionIndex() - 1].getName();
    }

    public void setLanguage(String lang) {
        int i = 0;
        while (i < this.mLanguages.length) {
            if (this.mLanguages[i].getDescription().equals(lang)) {
                this.mSelLanguage = this.mLanguages[i].getName();
                this.setPageComplete(true);
                return;
            }
            ++i;
        }
        this.mSelLanguage = null;
    }
}

