/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.archivebuilder;

import com.sap.dictionary.tools.archivebuilder.DictionaryWizardProjectCreationPage;
import com.sap.dictionary.tools.archivebuilder.ProjectwizardPlugin;
import com.sap.dictionary.tools.archivebuilder.TextPool;
import com.sap.dictionary.tools.archivebuilder.project.DictionaryNatureAction;
import com.sap.dictionary.tools.generation.eclipse.GenerationEclipse;
import com.sap.ide.metamodel.core.dc.DevComponentService;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.tssap.dii.component.IConnectedWizard;
import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceMonitor;
import com.tssap.util.projectinfo.ProjectInfo;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class DictionaryProjectWizard
extends Wizard
implements INewWizard,
IConnectedWizard {
    private DictionaryWizardProjectCreationPage mMainPage = null;
    private IStartCreateProjectWizard startWizard;
    public static final String SOURCE_PATH_ENTRY = "src";
    public static final String OUTPUT_PATH_ENTRY = "bin";
    private static final String FILE_NAME_PROJECT = ".project";
    private static final String FILE_NAME_CLASSPATH = ".classpath";
    private static final String FILE_NAME_TSSAPINFO = ".tssapinfo";
    private String mProjectName = null;
    private String mLanguage = null;
    boolean retValue = true;

    public DictionaryProjectWizard() {
    }

    public DictionaryProjectWizard(String projectName, String language) {
        this.mProjectName = projectName;
        this.mLanguage = language;
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run(IProgressMonitor monitor) throws CoreException {
                                String error = 1.access$000(this.this$1).runPerformFinish(monitor);
                                if (error != null) {
                                    DictionaryProjectWizard.access$100(1.access$000(this.this$1)).setErrorMessage(error);
                                }
                            }
                        }, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }

            static /* synthetic */ DictionaryProjectWizard access$000(1 x0) {
                return x0.DictionaryProjectWizard.this;
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            ProjectwizardPlugin.tracer.error("perform finish create project", (Throwable)e);
            this.mMainPage.setErrorMessage(e.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException e) {
            ProjectwizardPlugin.tracer.error("perform finish create project", (Throwable)e);
            return true;
        }
        return true;
    }

    protected IJavaProject createJavaProject(IProject project, IProgressMonitor monitor) {
        IJavaProject javaProject = ServicesEclipse.getJavaProject((String)project.getName());
        if (javaProject == null || !javaProject.exists()) {
            IProjectDescription projectDescription = null;
            try {
                projectDescription = project.getDescription();
            }
            catch (CoreException e) {
                ProjectwizardPlugin.tracer.error("createJavaProject(IProject, IProgressMonitor)", (Throwable)e);
                return null;
            }
            String[] natures = projectDescription.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = "org.eclipse.jdt.core.javanature";
            projectDescription.setNatureIds(newNatures);
            try {
                project.setDescription(projectDescription, monitor);
            }
            catch (CoreException e) {
                ProjectwizardPlugin.tracer.error("createJavaProject(IProject, IProgressMonitor)", (Throwable)e);
                return null;
            }
            javaProject = ServicesEclipse.getJavaProject((String)project.getName());
        }
        IClasspathEntry[] classpathEntries = new IClasspathEntry[]{JavaRuntime.getJREVariableEntry()};
        try {
            javaProject.setRawClasspath(classpathEntries, javaProject.getOutputLocation(), monitor);
        }
        catch (JavaModelException e) {
            ProjectwizardPlugin.tracer.error("createJavaProject(IProject, IProgressMonitor)", (Throwable)e);
        }
        return javaProject;
    }

    protected IProject createProject(String projectName, IPath projectPath, IProgressMonitor monitor) {
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        if (projectPath != null) {
            if (!projectPath.equals((Object)Platform.getLocation())) {
                projectDescription.setLocation(projectPath);
            } else {
                projectDescription.setLocation(null);
            }
        } else {
            projectDescription.setLocation(null);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectDescription.getName());
        try {
            project.create(projectDescription, monitor);
        }
        catch (CoreException e) {
            ProjectwizardPlugin.tracer.error("createProject(String, IPath, IProgressMonitor)", (Throwable)e);
            return null;
        }
        if (!project.isOpen()) {
            try {
                project.open(monitor);
            }
            catch (CoreException e) {
                ProjectwizardPlugin.tracer.error("createProject(String, IPath, IProgressMonitor)", (Throwable)e);
                return null;
            }
        }
        return project;
    }

    public String runPerformFinish(IProgressMonitor monitor) {
        String projectName = null;
        IPath locationPath = null;
        if (this.mMainPage == null) {
            projectName = this.mProjectName;
        } else {
            projectName = this.mMainPage.getProjectName();
            locationPath = this.mMainPage.getLocationPath();
        }
        if (projectName == null) {
            return TextPool.SET_NAME_FOR_PROJECT;
        }
        IJavaProject javaProject = this.createJavaProject(this.createProject(projectName, locationPath, monitor), monitor);
        if (!DictionaryProjectWizard.addSourcePaths(javaProject, true)) {
            return TextPool.ERROR_CREATING_SOURCE_PATHS;
        }
        DictionaryNatureAction dictionaryNatureAction = new DictionaryNatureAction(javaProject.getProject());
        dictionaryNatureAction.run();
        monitor.worked(50);
        try {
            PlatformUI.getWorkbench().showPerspective("com.sap.dictionary.tools.archivebuilder.DictionaryPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
        catch (WorkbenchException e) {
            ProjectwizardPlugin.tracer.error("show perspective", (Throwable)e);
        }
        monitor.worked(70);
        if (this.startWizard != null) {
            boolean ret;
            if (!this.setDCProjectSpecific(javaProject.getProject())) {
                ProjectwizardPlugin.tracer.error("could not set dc specific stuff");
            }
            if (ret = this.startWizard.fillProject(javaProject.getProject(), this.createPropertiesForDevelopmentComponent(javaProject))) {
                return null;
            }
            if (javaProject != null) {
                try {
                    javaProject.getProject().delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    ProjectwizardPlugin.tracer.error("couldn't delete project", (Throwable)e);
                }
            }
            return TextPool.ERROR_CREATING_DC_CONTENTS;
        }
        String selLan = null;
        selLan = this.mMainPage == null ? this.mLanguage : this.mMainPage.getSelectedLanguage();
        this.setProjectProperties(javaProject.getProject(), selLan);
        return null;
    }

    private Properties createPropertiesForDevelopmentComponent(IJavaProject javaProject) {
        Properties properties = new Properties();
        ArrayList<String> list = new ArrayList<String>();
        if (javaProject != null) {
            IClasspathEntry[] classpathEntries = null;
            try {
                classpathEntries = javaProject.getRawClasspath();
            }
            catch (JavaModelException e) {
                ProjectwizardPlugin.tracer.error("createPropertiesForDevelopmentComponent(IProject)", (Throwable)e);
                return null;
            }
            int i = 0;
            while (i < classpathEntries.length) {
                if (classpathEntries[i].getEntryKind() == 3 && !this.isPathForGeneratedSources(javaProject, classpathEntries[i])) {
                    String path = classpathEntries[i].getPath().removeFirstSegments(1).toString();
                    list.add(path);
                }
                ++i;
            }
        }
        ((Hashtable)properties).put("DCPackageFolder", list);
        return properties;
    }

    private boolean setDCProjectSpecific(IProject project) {
        String folderName;
        IFolder folder;
        WorkspaceMonitor monitor = WorkspaceMonitor.getInstance();
        IFile file = project.getFile(FILE_NAME_PROJECT);
        if (file.exists()) {
            try {
                file.setDerived(true);
            }
            catch (CoreException e) {
                ProjectwizardPlugin.tracer.error("setDCProjectSpecific(IProject)", (Throwable)e);
            }
            monitor.setMonitorResource((IResource)file, false, 1);
        }
        if ((file = project.getFile(FILE_NAME_CLASSPATH)).exists()) {
            try {
                file.setDerived(true);
            }
            catch (CoreException e) {
                ProjectwizardPlugin.tracer.error("Could not set .project file to derived", (Throwable)e);
            }
            monitor.setMonitorResource((IResource)file, false, 1);
        }
        if ((file = project.getFile(FILE_NAME_TSSAPINFO)).exists()) {
            try {
                file.setDerived(true);
            }
            catch (CoreException e) {
                ProjectwizardPlugin.tracer.error("Could not set .project file to derived", (Throwable)e);
            }
        }
        if ((folder = project.getFolder(folderName = GenerationEclipse.getGenerationOutputPathInfix())).exists()) {
            try {
                folder.setDerived(true);
            }
            catch (CoreException e) {
                ProjectwizardPlugin.tracer.error("Could not set '" + folderName + "' folder to derived", (Throwable)e);
            }
            monitor.setMonitorResource((IResource)folder, false, -1);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(TextPool.NEW_DICTIONATY_PROJECT_WIZARD);
    }

    public boolean completeProject(IProject project, Properties properties) {
        final IProject fProject = project;
        final Properties fProperties = properties;
        this.retValue = true;
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IClasspathEntry genDbTables;
                    String language = null;
                    language = ((Hashtable)fProperties).containsKey("DCLanguage") ? fProperties.getProperty("DCLanguage") : "en";
                    try {
                        if (fProject.getNature("org.eclipse.jdt.core.javanature") == null) {
                            IProjectDescription description = fProject.getDescription();
                            String[] natures = description.getNatureIds();
                            String[] newNatures = new String[natures.length + 1];
                            System.arraycopy(natures, 0, newNatures, 0, natures.length);
                            newNatures[natures.length] = "org.eclipse.jdt.core.javanature";
                            description.setNatureIds(newNatures);
                            fProject.setDescription(description, null);
                        }
                    }
                    catch (CoreException e) {
                        ProjectwizardPlugin.tracer.error("add java nature:", (Throwable)e);
                    }
                    IJavaProject jp = JavaCore.create((IProject)fProject);
                    if (jp != null) {
                        DictionaryProjectWizard.addSourcePaths(jp, false);
                    }
                    DictionaryNatureAction dictionaryNatureAction = new DictionaryNatureAction(jp.getProject());
                    dictionaryNatureAction.run();
                    if (!DictionaryProjectWizard.this.setDCProjectSpecific(fProject)) {
                        ProjectwizardPlugin.tracer.error("could not set dc specific stuff");
                        DictionaryProjectWizard.this.retValue = false;
                        return;
                    }
                    ArrayList list = new ArrayList();
                    if (((Hashtable)fProperties).containsKey("UsedDCsPaths")) {
                        list = (ArrayList)((Hashtable)fProperties).get("UsedDCsPaths");
                    }
                    list = DictionaryProjectWizard.getJARPathsFromReferencedDCs(list);
                    IJavaProject javaProject = ServicesEclipse.getJavaProject((String)fProject.getName());
                    list.add(0, JavaRuntime.getJREVariableEntry());
                    ArrayList sourceList = new ArrayList();
                    if (((Hashtable)fProperties).containsKey("DCPackageFolder")) {
                        sourceList = (ArrayList)((Hashtable)fProperties).get("DCPackageFolder");
                    }
                    String[] sourcePaths = new String[sourceList.size()];
                    sourcePaths = sourceList.toArray(sourcePaths);
                    int i = 0;
                    while (i < sourcePaths.length) {
                        IPath path = fProject.getFolder(sourcePaths[i]).getFullPath();
                        list.add(0, JavaCore.newSourceEntry((IPath)path));
                        ++i;
                    }
                    IClasspathEntry genDataTypes = DictionaryProjectWizard.getDictionaryGenDataTypesSourcePath(fProject);
                    if (!list.contains(genDataTypes)) {
                        list.add(1, genDataTypes);
                    }
                    if (!list.contains(genDbTables = DictionaryProjectWizard.getDictionaryGenDbTablesSourcePath(fProject))) {
                        list.add(1, genDbTables);
                    }
                    if (javaProject != null) {
                        IClasspathEntry[] classpathEntrys = new IClasspathEntry[list.size()];
                        classpathEntrys = list.toArray(classpathEntrys);
                        try {
                            javaProject.setRawClasspath(classpathEntrys, javaProject.getOutputLocation(), null);
                        }
                        catch (JavaModelException e) {
                            ProjectwizardPlugin.tracer.error("complete project", (Throwable)e);
                            DictionaryProjectWizard.this.retValue = false;
                            return;
                        }
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ProjectwizardPlugin.tracer.error("add dictionary nature", (Throwable)e);
        }
        return this.retValue;
    }

    private static void recursiveFileSearch(File file, Vector list) {
        File[] lFiles = file.listFiles();
        if (lFiles != null) {
            int i = 0;
            while (i < lFiles.length) {
                if (lFiles[i].isDirectory()) {
                    DictionaryProjectWizard.recursiveFileSearch(lFiles[i], list);
                } else {
                    list.add(lFiles[i]);
                }
                ++i;
            }
        }
    }

    public static ArrayList getJARPathsFromReferencedDCs(List dcList) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        String[] dcPaths = new String[dcList.size()];
        dcPaths = dcList.toArray(dcPaths);
        int i = 0;
        while (i < dcPaths.length) {
            Vector result = new Vector();
            DictionaryProjectWizard.recursiveFileSearch(new File(dcPaths[i]), result);
            int j = 0;
            while (j < result.size()) {
                File f = (File)result.get(j);
                String value = DevComponentService.getPublicPartManifestAttributeValue((String)f.getAbsolutePath(), (String)"DC-Type");
                if (value != null && value.length() > 0) {
                    list.add(JavaCore.newLibraryEntry((IPath)new Path(f.getAbsolutePath()), null, null));
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public void addPages() {
        super.addPages();
        if (this.mProjectName != null) {
            this.mMainPage = new DictionaryWizardProjectCreationPage("Project Properties", false);
            this.mMainPage.setProjectName(this.mProjectName);
            this.mMainPage.setLanguage(this.mLanguage);
        } else if (this.startWizard != null) {
            this.mMainPage = new DictionaryWizardProjectCreationPage("Project Properties", false);
            IProjectDescription descr = this.startWizard.getProjectDescription();
            this.mMainPage.setProjectName(descr.getName());
            this.mMainPage.setLocation(descr.getLocation());
        } else {
            this.mMainPage = new DictionaryWizardProjectCreationPage("Project Properties", true);
        }
        this.mMainPage.setTitle(TextPool.DICTIONARY_PROJECT);
        this.mMainPage.setDescription(TextPool.CREATE_NEW_DICTIONARY_PROJECT);
        this.addPage((IWizardPage)this.mMainPage);
    }

    public static boolean addSourcePaths(IJavaProject javaProject, boolean setCp) {
        IClasspathEntry[] classpathEntries = null;
        try {
            classpathEntries = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            ProjectwizardPlugin.tracer.error("get raw classpath", (Throwable)e);
            return false;
        }
        IProject project = javaProject.getProject();
        if (!DictionaryProjectWizard.getDictionaryGenSourcePath(project)) {
            return false;
        }
        IPath binPath = project.getLocation().append(OUTPUT_PATH_ENTRY);
        IContainer binContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(binPath);
        if (binContainer instanceof IFolder) {
            try {
                if (!binContainer.exists()) {
                    ((IFolder)binContainer).create(true, true, null);
                }
            }
            catch (CoreException e) {
                ProjectwizardPlugin.tracer.error("create bin folder", (Throwable)e);
                return false;
            }
        }
        ArrayList<IClasspathEntry> newClasspathEntries = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < classpathEntries.length) {
            if (classpathEntries[i].getEntryKind() != 3) {
                newClasspathEntries.add(classpathEntries[i]);
            }
            ++i;
        }
        IClasspathEntry srcEntry = DictionaryProjectWizard.getSourcePath(project);
        if (srcEntry == null) {
            return false;
        }
        newClasspathEntries.add(0, srcEntry);
        IClasspathEntry genSrcEntryDatatypes = DictionaryProjectWizard.getDictionaryGenDataTypesSourcePath(project);
        if (genSrcEntryDatatypes == null) {
            return false;
        }
        newClasspathEntries.add(1, genSrcEntryDatatypes);
        IClasspathEntry genSrcEntryDbTables = DictionaryProjectWizard.getDictionaryGenDbTablesSourcePath(project);
        if (genSrcEntryDbTables == null) {
            return false;
        }
        newClasspathEntries.add(2, genSrcEntryDbTables);
        IClasspathEntry[] newClasspathEntriesArray = new IClasspathEntry[newClasspathEntries.size()];
        newClasspathEntriesArray = newClasspathEntries.toArray(newClasspathEntriesArray);
        try {
            javaProject.setOutputLocation(binContainer.getFullPath(), null);
        }
        catch (JavaModelException e) {
            ProjectwizardPlugin.tracer.error("set output location", (Throwable)e);
            return false;
        }
        try {
            if (setCp) {
                javaProject.setRawClasspath(newClasspathEntriesArray, null);
            }
        }
        catch (JavaModelException e) {
            ProjectwizardPlugin.tracer.error("set raw classpath", (Throwable)e);
            return false;
        }
        return true;
    }

    public void init(IStartCreateProjectWizard wizard) {
        this.startWizard = wizard;
    }

    protected boolean setProjectProperties(IProject project, String projectLanguage) {
        ProjectInfo.setProperty((IProject)project, (String)"com.sap.ide.metamodel.project.masterlanguage", (String)projectLanguage);
        return true;
    }

    private boolean isPathForGeneratedSources(IJavaProject javaProject, IClasspathEntry classpathEntry) {
        if (classpathEntry.getEntryKind() != 3) {
            return false;
        }
        IClasspathEntry entry = DictionaryProjectWizard.getDictionaryGenDataTypesSourcePath(javaProject.getProject());
        if (entry.getPath().equals((Object)classpathEntry.getPath())) {
            return true;
        }
        entry = DictionaryProjectWizard.getDictionaryGenDbTablesSourcePath(javaProject.getProject());
        return entry.getPath().equals((Object)classpathEntry.getPath());
    }

    private static IClasspathEntry getDictionaryGenDbTablesSourcePath(IProject project) {
        IPath dictionaryGenSrcPathDbTables = project.getProject().getLocation().append(GenerationEclipse.getGenerationOutputPathInfix() + "/" + "dbtables");
        IContainer dictionaryGenSrcDbTablesContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(dictionaryGenSrcPathDbTables);
        if (dictionaryGenSrcDbTablesContainer instanceof IFolder) {
            try {
                if (!dictionaryGenSrcDbTablesContainer.exists()) {
                    ((IFolder)dictionaryGenSrcDbTablesContainer).create(true, true, null);
                }
            }
            catch (CoreException e) {
                ProjectwizardPlugin.tracer.error("create src dbtables folder", (Throwable)e);
                return null;
            }
        }
        return JavaCore.newSourceEntry((IPath)dictionaryGenSrcDbTablesContainer.getFullPath());
    }

    private static IClasspathEntry getSourcePath(IProject project) {
        IPath srcPath = project.getLocation().append(SOURCE_PATH_ENTRY);
        IContainer srcContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(srcPath);
        if (srcContainer instanceof IFolder) {
            try {
                if (!srcContainer.exists()) {
                    ((IFolder)srcContainer).create(true, true, null);
                }
            }
            catch (CoreException e) {
                ProjectwizardPlugin.tracer.error("create source folder", (Throwable)e);
                return null;
            }
        }
        IPath srcPathPackages = project.getLocation().append("src/packages");
        IContainer srcContainerPackages = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(srcPathPackages);
        if (srcContainerPackages instanceof IFolder) {
            try {
                if (!srcContainerPackages.exists()) {
                    ((IFolder)srcContainerPackages).create(true, true, null);
                }
            }
            catch (CoreException e) {
                ProjectwizardPlugin.tracer.error("create src folder", (Throwable)e);
                return null;
            }
        }
        return JavaCore.newSourceEntry((IPath)srcContainerPackages.getFullPath());
    }

    private static IClasspathEntry getDictionaryGenDataTypesSourcePath(IProject project) {
        IPath dictionaryGenSrcPathDatatypes = project.getLocation().append(GenerationEclipse.getGenerationOutputPathInfix() + "/" + "datatypes");
        IContainer dictionaryGenSrcDatatypesContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(dictionaryGenSrcPathDatatypes);
        if (dictionaryGenSrcDatatypesContainer instanceof IFolder) {
            try {
                if (!dictionaryGenSrcDatatypesContainer.exists()) {
                    ((IFolder)dictionaryGenSrcDatatypesContainer).create(true, true, null);
                }
            }
            catch (CoreException e) {
                ProjectwizardPlugin.tracer.error("get gen ddic source path", (Throwable)e);
                return null;
            }
        }
        return JavaCore.newSourceEntry((IPath)dictionaryGenSrcDatatypesContainer.getFullPath());
    }

    private static boolean getDictionaryGenSourcePath(IProject project) {
        IPath dictionaryGenSrcPath = project.getLocation().append(GenerationEclipse.getGenerationOutputPathInfix());
        IContainer dictionaryGenSrcContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(dictionaryGenSrcPath);
        if (dictionaryGenSrcContainer instanceof IFolder) {
            try {
                if (!dictionaryGenSrcContainer.exists()) {
                    ((IFolder)dictionaryGenSrcContainer).create(true, true, null);
                }
            }
            catch (CoreException e) {
                ProjectwizardPlugin.tracer.error("get ddic gen source path", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void finalProject() {
    }

    static /* synthetic */ DictionaryWizardProjectCreationPage access$100(DictionaryProjectWizard x0) {
        return x0.mMainPage;
    }
}

