/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.ExceptionManager;
import com.sap.tc.logging.LogController;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.LoggingManager;
import com.sap.tc.logging.MSGCollection;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Location
extends LogController {
    private static Location LOC = Location.getLocation("com.sap.tc.logging.Location");
    static final String MSG_ENTERING = "Entering method";
    static final String MSG_ENTERING_WITH_PARS = "Entering method with ({0})";
    static final String MSG_EXITING = "Exiting method";
    static final String MSG_EXITING_WITH_RES = "Exiting method with {0}";
    public static final String ROOT_NAME = "";
    public static final char SEPARATOR = '.';

    protected Location(String name) {
        super(name);
    }

    protected Location(String name, Location parent) {
        super(name, parent);
    }

    public static Location getRoot() {
        return Location.getLocation(ROOT_NAME);
    }

    public Location getParent() {
        return (Location)this.getParentInt();
    }

    public static Location getLocation(String name) {
        return LoggingManager.getLoggingManager().getLocation(name);
    }

    public static Location getLocation(Object instance) {
        if (instance != null) {
            return Location.getLocation(instance.getClass());
        }
        LOC.logIntByAPI(400, LOC, "[getLocation(Object instance)]", MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, MSGCollection.LOGGING_MSG_STR_OBJECT_IS_NULL, new String[]{"Object", "Location", ROOT_NAME});
        return null;
    }

    public static Location getLocation(Class forClass) {
        if (forClass != null) {
            return Location.getLocation(forClass.getName());
        }
        LOC.logIntByAPI(400, LOC, "[getLocation(Class forClass)]", MSGCollection.LOGGING_MSG_ID_OBJECT_IS_NULL, MSGCollection.LOGGING_MSG_STR_OBJECT_IS_NULL, new String[]{"Class", "Location", ROOT_NAME});
        return null;
    }

    public static Location getLocation(Location loc, String name) {
        if (loc != Location.getRoot()) {
            return Location.getLocation(loc.getName() + '.' + name);
        }
        return Location.getLocation(name);
    }

    public LogRecord logT(int severity, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityTInt(severity, this, categories, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, this, LogController.MSG_RELATIVES, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{category}, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityTInt(severity, this, categories, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityTInt(severity, this, categories, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logTInt(severity, this, LogController.MSG_RELATIVES, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{category}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord logT(int severity, Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityTInt(severity, this, categories, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, this, new LogController[]{category}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, this, categories, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, this, new LogController[]{category}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, this, categories, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, this, categories, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, this, new LogController[]{category}, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, this, categories, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, this, categories, null, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, category)) {
            writtenRec = this.logSeverityInt(severity, this, new LogController[]{category}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord log(int severity, Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, categories)) {
            writtenRec = this.logSeverityInt(severity, this, categories, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debugT(String msg) {
        LogRecord writtenRec = null;
        if (this.beDebug()) {
            writtenRec = this.logTInt(100, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityTInt(100, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityTInt(100, this, categories, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debugT(String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beDebug()) {
            writtenRec = this.logTInt(100, this, LogController.MSG_RELATIVES, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityTInt(100, this, new LogController[]{category}, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityTInt(100, this, categories, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debugT(String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug()) {
            writtenRec = this.logTInt(100, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityTInt(100, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityTInt(100, this, categories, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debugT(String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug()) {
            writtenRec = this.logTInt(100, this, LogController.MSG_RELATIVES, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityTInt(100, this, new LogController[]{category}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debugT(Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityTInt(100, this, categories, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, this, new LogController[]{category}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, this, categories, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, this, new LogController[]{category}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, this, categories, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, this, categories, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, this, new LogController[]{category}, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, this, categories, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, this, categories, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debug(Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(category)) {
            writtenRec = this.logSeverityInt(100, this, new LogController[]{category}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord debug(Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beDebug(categories)) {
            writtenRec = this.logSeverityInt(100, this, categories, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord pathT(String msg) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord pathT(String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord pathT(String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord pathT(String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord pathT(Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, this, new LogController[]{category}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, this, categories, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, this, new LogController[]{category}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, this, categories, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, this, categories, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, this, new LogController[]{category}, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, this, categories, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, this, categories, null, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord path(Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityInt(200, this, new LogController[]{category}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord path(Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityInt(200, this, categories, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord infoT(String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo()) {
            writtenRec = this.logTInt(300, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityTInt(300, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityTInt(300, this, categories, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord infoT(String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo()) {
            writtenRec = this.logTInt(300, this, LogController.MSG_RELATIVES, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityTInt(300, this, new LogController[]{category}, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityTInt(300, this, categories, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord infoT(String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo()) {
            writtenRec = this.logTInt(300, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityTInt(300, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityTInt(300, this, categories, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord infoT(String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo()) {
            writtenRec = this.logTInt(300, this, LogController.MSG_RELATIVES, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityTInt(300, this, new LogController[]{category}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord infoT(Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityTInt(300, this, categories, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, this, new LogController[]{category}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, this, categories, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, this, new LogController[]{category}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, this, categories, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, this, categories, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, this, new LogController[]{category}, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, this, categories, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, this, categories, null, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(category)) {
            writtenRec = this.logSeverityInt(300, this, new LogController[]{category}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord info(Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beInfo(categories)) {
            writtenRec = this.logSeverityInt(300, this, categories, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warningT(String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(400, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityTInt(400, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityTInt(400, this, categories, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warningT(String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(400, this, LogController.MSG_RELATIVES, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityTInt(400, this, new LogController[]{category}, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityTInt(400, this, categories, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warningT(String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(400, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityTInt(400, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityTInt(400, this, categories, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warningT(String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(400, this, LogController.MSG_RELATIVES, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityTInt(400, this, new LogController[]{category}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warningT(Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityTInt(400, this, categories, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, this, new LogController[]{category}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, this, categories, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, this, new LogController[]{category}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, this, categories, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, this, categories, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, this, new LogController[]{category}, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, this, categories, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, this, categories, null, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logSeverityInt(400, this, new LogController[]{category}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord warning(Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logSeverityInt(400, this, categories, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord errorT(String msg) {
        LogRecord writtenRec = null;
        if (this.beError()) {
            writtenRec = this.logTInt(500, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityTInt(500, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityTInt(500, this, categories, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord errorT(String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beError()) {
            writtenRec = this.logTInt(500, this, LogController.MSG_RELATIVES, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityTInt(500, this, new LogController[]{category}, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityTInt(500, this, categories, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord errorT(String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError()) {
            writtenRec = this.logTInt(500, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityTInt(500, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityTInt(500, this, categories, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord errorT(String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError()) {
            writtenRec = this.logTInt(500, this, LogController.MSG_RELATIVES, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityTInt(500, this, new LogController[]{category}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord errorT(Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityTInt(500, this, categories, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, this, new LogController[]{category}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, this, categories, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, this, new LogController[]{category}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, this, categories, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, this, categories, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, this, new LogController[]{category}, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, this, categories, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, this, categories, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(category)) {
            writtenRec = this.logSeverityInt(500, this, new LogController[]{category}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord error(Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beError(categories)) {
            writtenRec = this.logSeverityInt(500, this, categories, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatalT(String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal()) {
            writtenRec = this.logTInt(600, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category category, String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityTInt(600, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category[] categories, String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityTInt(600, this, categories, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatalT(String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal()) {
            writtenRec = this.logTInt(600, this, LogController.MSG_RELATIVES, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category category, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityTInt(600, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category[] categories, String subloc, String msg) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityTInt(600, this, categories, subloc, msg, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatalT(String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal()) {
            writtenRec = this.logTInt(600, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category category, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityTInt(600, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category[] categories, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityTInt(600, this, categories, LogController.MSG_SUB_LOC, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatalT(String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal()) {
            writtenRec = this.logTInt(600, this, LogController.MSG_RELATIVES, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category category, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityTInt(600, this, new LogController[]{category}, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatalT(Category[] categories, String subloc, String msg, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityTInt(600, this, categories, subloc, msg, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, this, new LogController[]{category}, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, String subloc, Object msgCode) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, this, categories, subloc, msgCode, null, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, this, categories, LogController.MSG_SUB_LOC, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, this, new LogController[]{category}, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, String subloc, Object msgCode, Object[] args) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, this, categories, subloc, msgCode, null, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, this, categories, LogController.MSG_SUB_LOC, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, this, new LogController[]{category}, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, String subloc, Object msgCode, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, this, categories, subloc, msgCode, msgClear, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, this, new LogController[]{category}, LogController.MSG_SUB_LOC, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, this, categories, null, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category category, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(category)) {
            writtenRec = this.logSeverityInt(600, this, new LogController[]{category}, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord fatal(Category[] categories, String subloc, Object msgCode, Object[] args, String msgClear) {
        LogRecord writtenRec = null;
        if (this.beFatal(categories)) {
            writtenRec = this.logSeverityInt(600, this, categories, subloc, msgCode, msgClear, 1, args);
        }
        return writtenRec;
    }

    public LogRecord entering() {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, MSG_ENTERING, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord entering(Category category) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, LogController.MSG_SUB_LOC, MSG_ENTERING, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord entering(Category[] categories) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, LogController.MSG_SUB_LOC, MSG_ENTERING, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord entering(String subloc) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, subloc, MSG_ENTERING, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord entering(Category category, String subloc) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, subloc, MSG_ENTERING, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public LogRecord entering(Category[] categories, String subloc) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logSeverityTInt(200, this, categories, subloc, MSG_ENTERING, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    private String argumentsPack(Object[] args) {
        String argList = null;
        if (args != null) {
            argList = ROOT_NAME;
            int i = 0;
            while (i < args.length) {
                if (i >= 1) {
                    argList = argList + ", ";
                }
                if (args[i] != null) {
                    try {
                        argList = argList + args[i].toString();
                    }
                    catch (Exception ex) {
                        argList = argList + "<null>";
                    }
                } else {
                    argList = argList + "<null>";
                }
                ++i;
            }
        }
        return argList;
    }

    public LogRecord entering(Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            String argList = this.argumentsPack(args);
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, MSG_ENTERING_WITH_PARS, 1, new Object[]{argList});
        }
        return writtenRec;
    }

    public LogRecord entering(Category category, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            String argList = this.argumentsPack(args);
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, LogController.MSG_SUB_LOC, MSG_ENTERING_WITH_PARS, 1, new Object[]{argList});
        }
        return writtenRec;
    }

    public LogRecord entering(Category[] categories, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            String argList = this.argumentsPack(args);
            writtenRec = this.logSeverityTInt(200, this, categories, LogController.MSG_SUB_LOC, MSG_ENTERING_WITH_PARS, 1, new Object[]{argList});
        }
        return writtenRec;
    }

    public LogRecord entering(String subloc, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            String argList = this.argumentsPack(args);
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, subloc, MSG_ENTERING_WITH_PARS, 1, new Object[]{argList});
        }
        return writtenRec;
    }

    public LogRecord entering(Category category, String subloc, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            String argList = this.argumentsPack(args);
            writtenRec = this.logSeverityTInt(200, this, new LogController[]{category}, subloc, MSG_ENTERING_WITH_PARS, 1, new Object[]{argList});
        }
        return writtenRec;
    }

    public LogRecord entering(Category[] categories, String subloc, Object[] args) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            String argList = this.argumentsPack(args);
            writtenRec = this.logSeverityTInt(200, this, categories, subloc, MSG_ENTERING_WITH_PARS, 1, new Object[]{argList});
        }
        return writtenRec;
    }

    public LogRecord exiting() {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, MSG_EXITING, 0, LogController.MSG_ARGS);
        }
        return writtenRec;
    }

    public void exiting(String subloc) {
        if (this.bePath()) {
            this.logTInt(200, this, LogController.MSG_RELATIVES, subloc, MSG_EXITING, 0, LogController.MSG_ARGS);
        }
    }

    public LogRecord exiting(Object res) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, MSG_EXITING_WITH_RES, 1, new Object[]{res});
        }
        return writtenRec;
    }

    public void exiting(String subloc, Object res) {
        if (this.bePath()) {
            this.logTInt(200, this, LogController.MSG_RELATIVES, subloc, MSG_EXITING_WITH_RES, 1, new Object[]{res});
        }
    }

    public LogRecord assertion(boolean assertion, String desc) {
        LogRecord writtenRec = null;
        if (!assertion && this.beError()) {
            writtenRec = this.logTInt(500, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, "Assertion failed: {0}", 1, new Object[]{desc});
        }
        return writtenRec;
    }

    public LogRecord assertion(Category category, boolean assertion, String desc) {
        LogRecord writtenRec = null;
        if (!assertion && this.beError(category)) {
            writtenRec = this.logTInt(500, this, new LogController[]{category}, LogController.MSG_SUB_LOC, "Assertion failed: {0}", 1, new Object[]{desc});
        }
        return writtenRec;
    }

    public LogRecord assertion(Category[] categories, boolean assertion, String desc) {
        LogRecord writtenRec = null;
        if (!assertion && this.beError(categories)) {
            writtenRec = this.logTInt(500, this, categories, LogController.MSG_SUB_LOC, "Assertion failed: {0}", 1, new Object[]{desc});
        }
        return writtenRec;
    }

    public LogRecord assertion(String subloc, boolean assertion, String desc) {
        LogRecord writtenRec = null;
        if (!assertion && this.beError()) {
            writtenRec = this.logTInt(500, this, LogController.MSG_RELATIVES, subloc, "Assertion failed: {0}", 1, new Object[]{desc});
        }
        return writtenRec;
    }

    public LogRecord assertion(Category category, String subloc, boolean assertion, String desc) {
        LogRecord writtenRec = null;
        if (!assertion && this.beError(category)) {
            writtenRec = this.logTInt(500, this, new LogController[]{category}, subloc, "Assertion failed: {0}", 1, new Object[]{desc});
        }
        return writtenRec;
    }

    public LogRecord assertion(Category[] categories, String subloc, boolean assertion, String desc) {
        LogRecord writtenRec = null;
        if (!assertion && this.beError(categories)) {
            writtenRec = this.logTInt(500, this, categories, subloc, "Assertion failed: {0}", 1, new Object[]{desc});
        }
        return writtenRec;
    }

    public LogRecord throwing(Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, "Throwing {0}", 1, new Object[]{exc});
        }
        return writtenRec;
    }

    public LogRecord throwing(Category category, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logTInt(200, this, new LogController[]{category}, LogController.MSG_SUB_LOC, "Throwing {0}", 1, new Object[]{exc});
        }
        return writtenRec;
    }

    public LogRecord throwing(Category[] categories, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logTInt(200, this, categories, LogController.MSG_SUB_LOC, "Throwing {0}", 1, new Object[]{exc});
        }
        return writtenRec;
    }

    public LogRecord throwing(String subloc, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath()) {
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, subloc, "Throwing {0}", 1, new Object[]{exc});
        }
        return writtenRec;
    }

    public LogRecord throwing(Category category, String subloc, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath(category)) {
            writtenRec = this.logTInt(200, this, new LogController[]{category}, subloc, "Throwing {0}", 1, new Object[]{exc});
        }
        return writtenRec;
    }

    public LogRecord throwing(Category[] categories, String subloc, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.bePath(categories)) {
            writtenRec = this.logTInt(200, this, categories, subloc, "Throwing {0}", 1, new Object[]{exc});
        }
        return writtenRec;
    }

    private String getStackTrace(Throwable exc) {
        StringWriter stack = new StringWriter();
        PrintWriter writer = new PrintWriter(stack);
        exc.printStackTrace(writer);
        return ((Object)stack).toString();
    }

    public LogRecord catching(Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, "Caught {0}", 1, new Object[]{this.getStackTrace(exc)});
        }
        return writtenRec;
    }

    public LogRecord catching(Category category, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logTInt(200, this, new LogController[]{category}, LogController.MSG_SUB_LOC, "Caught {0}", 1, new Object[]{this.getStackTrace(exc)});
        }
        return writtenRec;
    }

    public LogRecord catching(Category[] categories, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logTInt(200, this, categories, LogController.MSG_SUB_LOC, "Caught {0}", 1, new Object[]{this.getStackTrace(exc)});
        }
        return writtenRec;
    }

    public LogRecord catching(String subloc, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beWarning()) {
            writtenRec = this.logTInt(200, this, LogController.MSG_RELATIVES, subloc, "Caught {0}", 1, new Object[]{this.getStackTrace(exc)});
        }
        return writtenRec;
    }

    public LogRecord catching(Category category, String subloc, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beWarning(category)) {
            writtenRec = this.logTInt(200, this, new LogController[]{category}, subloc, "Caught {0}", 1, new Object[]{this.getStackTrace(exc)});
        }
        return writtenRec;
    }

    public LogRecord catching(Category[] categories, String subloc, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beWarning(categories)) {
            writtenRec = this.logTInt(200, this, categories, subloc, "Caught {0}", 1, new Object[]{this.getStackTrace(exc)});
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, String msg, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logSeverityTInt(severity, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, this.getNewMsg(msg, 0), 1, new Object[]{ExceptionManager.getStackTrace(exc)}, exc);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, String subloc, String msg, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            writtenRec = this.logSeverityTInt(severity, this, LogController.MSG_RELATIVES, subloc, this.getNewMsg(msg, 0), 1, new Object[]{ExceptionManager.getStackTrace(exc)}, exc);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, String msg, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            if (args != null) {
                msg = this.getNewMsg(msg, args.length);
                args = this.getNewArgs(args, exc);
            }
            writtenRec = this.logSeverityTInt(severity, this, LogController.MSG_RELATIVES, LogController.MSG_SUB_LOC, msg, 1, args, exc);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, String subloc, String msg, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity)) {
            if (args != null) {
                msg = this.getNewMsg(msg, args.length);
                args = this.getNewArgs(args, exc);
            }
            writtenRec = this.logSeverityTInt(severity, this, LogController.MSG_RELATIVES, subloc, msg, 1, args, exc);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, Category cat, String msg, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, cat)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{cat}, LogController.MSG_SUB_LOC, this.getNewMsg(msg, 0), 1, new Object[]{ExceptionManager.getStackTrace(exc)}, exc);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, Category cat, String subloc, String msg, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, cat)) {
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{cat}, subloc, this.getNewMsg(msg, 0), 1, new Object[]{ExceptionManager.getStackTrace(exc)}, exc);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, Category cat, String msg, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, cat)) {
            if (args != null) {
                msg = this.getNewMsg(msg, args.length);
                args = this.getNewArgs(args, exc);
            }
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{cat}, LogController.MSG_SUB_LOC, msg, 1, args, exc);
        }
        return writtenRec;
    }

    public LogRecord traceThrowableT(int severity, Category cat, String subloc, String msg, Object[] args, Throwable exc) {
        LogRecord writtenRec = null;
        if (this.beLogged(severity, cat)) {
            if (args != null) {
                msg = this.getNewMsg(msg, args.length);
                args = this.getNewArgs(args, exc);
            }
            writtenRec = this.logSeverityTInt(severity, this, new LogController[]{cat}, subloc, msg, 1, args, exc);
        }
        return writtenRec;
    }

    public void openGroup(int severity) {
        this.openGroupInt(LogController.MSG_GRP_NAME, LogController.MSG_GRP_DESC, severity, LogController.MSG_SUB_LOC);
    }

    public void openGroup(int severity, String subloc) {
        this.openGroupInt(LogController.MSG_GRP_NAME, LogController.MSG_GRP_DESC, severity, subloc);
    }

    public void openGroup(int severity, Category category) {
        this.openGroupInt(LogController.MSG_GRP_NAME, LogController.MSG_GRP_DESC, severity, LogController.MSG_SUB_LOC, category);
    }

    public void openGroup(int severity, Category category, String subloc) {
        this.openGroupInt(LogController.MSG_GRP_NAME, LogController.MSG_GRP_DESC, severity, subloc, category);
    }

    public void openGroup(int severity, Category[] categories) {
        this.openGroupInt(LogController.MSG_GRP_NAME, LogController.MSG_GRP_DESC, severity, LogController.MSG_SUB_LOC, categories);
    }

    public void openGroup(int severity, Category[] categories, String subloc) {
        this.openGroupInt(LogController.MSG_GRP_NAME, LogController.MSG_GRP_DESC, severity, subloc, categories);
    }

    public void setMinimumSeverity(Category relative, int severity) {
        super.setMinimumSeverity(relative, severity);
    }

    public void setMinimumSeverity(Category relative) {
        super.setMinimumSeverity(relative);
    }

    public void setEffectiveSeverity(Category relative, int severity) {
        super.setEffectiveSeverity(relative, severity);
    }

    public void setEffectiveSeverity(Category relative) {
        super.setEffectiveSeverity(relative);
    }

    public void setMaximumSeverity(Category relative, int severity) {
        super.setMaximumSeverity(relative, severity);
    }

    public void setMaximumSeverity(Category relative) {
        super.setMaximumSeverity(relative);
    }

    protected String[] convertRelatives(LogController[] relatives) {
        return super.convertRelatives(relatives);
    }
}

