/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.CommandlineProperties;
import com.tssap.dtr.client.commandline.DisplayHelper;
import com.tssap.dtr.client.commandline.Field;
import com.tssap.dtr.client.commandline.FieldDescriptor;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsRemoteLocator;
import com.tssap.dtr.client.lib.vfs.IVfsRepository;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;

class WorkspacesCommand
extends Command {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$WorkspacesCommand == null ? (class$com$tssap$dtr$client$commandline$WorkspacesCommand = WorkspacesCommand.class$("com.tssap.dtr.client.commandline.WorkspacesCommand")) : class$com$tssap$dtr$client$commandline$WorkspacesCommand));
    private static final FieldDescriptor DISPLAY_NAME = new FieldDescriptor(WorkspacesCommand.getFieldLength("DisplayName", 20), "DisplayName", "DN");
    private static final FieldDescriptor LOCAL_PATH = new FieldDescriptor(WorkspacesCommand.getFieldLength("LocalPath", 50), "LocalPath", "LP");
    private static final FieldDescriptor REMOTE_PATH = new FieldDescriptor(WorkspacesCommand.getFieldLength("RemotePath", 50), "RemotePath", "RP");
    private static final FieldDescriptor BROWSE_PATH = new FieldDescriptor(WorkspacesCommand.getFieldLength("BrowsePath", 59), "BrowsePath", "BP");
    private static final FieldDescriptor DESCRIPTION = new FieldDescriptor(WorkspacesCommand.getFieldLength("Description", 30), "Description", "Des");
    private static final String ALL = "All";
    private boolean _fieldsSpecifiedInArgs;
    private boolean _listWSFoders;
    private ArrayList _displayFiledsOrdered;
    private boolean _sortSpecified;
    private Field _sortField;
    private int _sortKeyType;
    private boolean _descendingOrder;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$WorkspacesCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new WorkspacesCommand(arguments);
    }

    WorkspacesCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.FIELD);
        this.addSupportedOption(OptionName.SORT);
        this.addSupportedOption(OptionName.UNFORMATTED);
        this.addSupportedOption(OptionName.DESCENDING);
        this.addSupportedOption(OptionName.FOLDER);
        this._displayFiledsOrdered = new ArrayList();
        this._displayFiledsOrdered.add(new Field(DISPLAY_NAME, WorkspacesCommand.DISPLAY_NAME.fieldName));
        this._displayFiledsOrdered.add(new Field(BROWSE_PATH, WorkspacesCommand.BROWSE_PATH.fieldName));
        this._listWSFoders = false;
        this._fieldsSpecifiedInArgs = false;
        this._sortField = null;
        this._sortSpecified = false;
        this._descendingOrder = false;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "lists all known workspaces";
    }

    public CommandName getCommandName() {
        return CommandName.WORKSPACES;
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            String descShort = NameConfig.getOption(OptionName.DESCENDING, true);
            String descLong = NameConfig.getOption(OptionName.DESCENDING, false);
            String fShort = NameConfig.getOption(OptionName.FIELD, true);
            String fLong = NameConfig.getOption(OptionName.FIELD, false);
            String sShort = NameConfig.getOption(OptionName.SORT, true);
            String sLong = NameConfig.getOption(OptionName.SORT, false);
            String unShort = NameConfig.getOption(OptionName.UNFORMATTED, true);
            String unLong = NameConfig.getOption(OptionName.UNFORMATTED, false);
            String flShort = NameConfig.getOption(OptionName.FOLDER, true);
            String flLong = NameConfig.getOption(OptionName.FOLDER, false);
            if (currArg != null) {
                String fieldName;
                String lowerCaseArg = currArg.toLowerCase();
                if (currArg.startsWith(fShort) || lowerCaseArg.startsWith(fLong)) {
                    fieldName = Command.getActualArgument(currArg, fShort, fLong).toLowerCase();
                    if ("".equals(fieldName) && i + 1 < arguments.size()) {
                        fieldName = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    if (!"".equals(fieldName) && !this._fieldsSpecifiedInArgs) {
                        this._displayFiledsOrdered = null;
                        this._displayFiledsOrdered = new ArrayList();
                        this._fieldsSpecifiedInArgs = true;
                    }
                    if (LOCAL_PATH.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(LOCAL_PATH, fieldName));
                    } else if (REMOTE_PATH.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(REMOTE_PATH, fieldName));
                    } else if (BROWSE_PATH.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(BROWSE_PATH, fieldName));
                    } else if (DISPLAY_NAME.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(DISPLAY_NAME, fieldName));
                    } else if (DESCRIPTION.matches(fieldName)) {
                        this._displayFiledsOrdered.add(new Field(DESCRIPTION, fieldName));
                    } else if (fieldName.startsWith(ALL.toLowerCase())) {
                        this._displayFiledsOrdered.add(new Field(DISPLAY_NAME, fieldName));
                        this._displayFiledsOrdered.add(new Field(BROWSE_PATH, fieldName));
                        this._displayFiledsOrdered.add(new Field(LOCAL_PATH, fieldName));
                        this._displayFiledsOrdered.add(new Field(REMOTE_PATH, fieldName));
                        this._displayFiledsOrdered.add(new Field(DESCRIPTION, fieldName));
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (currArg.startsWith(sShort) || lowerCaseArg.startsWith(sLong)) {
                    fieldName = Command.getActualArgument(currArg, sShort, sLong).toLowerCase();
                    if (!this._sortSpecified) {
                        if (LOCAL_PATH.matches(fieldName)) {
                            this._sortField = new Field(LOCAL_PATH, fieldName);
                            this._sortKeyType = 1;
                        } else if (REMOTE_PATH.matches(fieldName)) {
                            this._sortField = new Field(REMOTE_PATH, fieldName);
                            this._sortKeyType = 1;
                        } else if (BROWSE_PATH.matches(fieldName)) {
                            this._sortField = new Field(BROWSE_PATH, fieldName);
                            this._sortKeyType = 1;
                        } else if (DISPLAY_NAME.matches(fieldName)) {
                            this._sortField = new Field(DISPLAY_NAME, fieldName);
                            this._sortKeyType = 1;
                        } else if (DESCRIPTION.matches(fieldName)) {
                            this._sortField = new Field(DESCRIPTION, fieldName);
                            this._sortKeyType = 1;
                        }
                        if (this._sortField != null) {
                            this._sortSpecified = true;
                        }
                    }
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (flShort.equals(currArg) || flLong.equals(lowerCaseArg)) {
                    this._listWSFoders = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (descShort.equals(lowerCaseArg) || descLong.equals(lowerCaseArg)) {
                    this._descendingOrder = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (unShort.equals(currArg) || unLong.equals(lowerCaseArg)) {
                    this._unformattedOutput = true;
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
        if (this._displayFiledsOrdered.size() == 0) {
            this._displayFiledsOrdered.add(new Field(DISPLAY_NAME, WorkspacesCommand.DISPLAY_NAME.fieldName));
            this._displayFiledsOrdered.add(new Field(BROWSE_PATH, WorkspacesCommand.BROWSE_PATH.fieldName));
        }
        if (this._sortSpecified) {
            boolean sortFieldAdded = false;
            int i = 0;
            while (i < this._displayFiledsOrdered.size()) {
                if (this._sortField.isIt(((Field)this._displayFiledsOrdered.get((int)i)).fieldName)) {
                    sortFieldAdded = true;
                    break;
                }
                ++i;
            }
            if (!sortFieldAdded) {
                this._displayFiledsOrdered.add(this._sortField);
            }
        } else {
            this._sortField = (Field)this._displayFiledsOrdered.get(0);
            this._sortKeyType = 1;
        }
    }

    public boolean execute() {
        IVersionedFileSystemManager fileSystemManager = this.getFileSystemManager();
        if (fileSystemManager == null) {
            Command.getOut().println("Could not get the file system manager. Please ensure that the server is running and try again.");
            this._exitCode = 3;
            return false;
        }
        this.displayHeader(this._displayFiledsOrdered);
        DisplayHelper displayHelper = new DisplayHelper(this._unformattedOutput);
        displayHelper.startDisplay();
        displayHelper.setKeyField(this._sortField, this._sortKeyType);
        if (this._listWSFoders) {
            IVfsRemoteLocator[] remoteLocators = this.getActiveContext().getBrowseRootRemoteLocators();
            int i = 0;
            while (i < remoteLocators.length) {
                IVfsFolderItem folderItem = null;
                try {
                    folderItem = fileSystemManager.getFolderItemByBrowsePath(this.getActiveContext().getBrowsePath(remoteLocators[i]));
                }
                catch (VfsException x) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)x), "VfsException occurred while getting folder item " + this.getActiveContext().getBrowsePath(remoteLocators[i]));
                    Command.getOut().println("Could not get a list of workspaces. " + x.getMessage());
                    return false;
                }
                if (folderItem == null) {
                    Command.getOut().println("Could not get a list of workspaces.");
                    return false;
                }
                IVfsGenericFolder genericFolder = folderItem.asGenericFolder();
                this.displayWSFolder(genericFolder, false, displayHelper);
                ++i;
            }
        } else {
            IVfsRepository[] repositories = fileSystemManager.getRepositories();
            int i = 0;
            while (i < repositories.length) {
                IVfsWorkspace[] workspaces = repositories[i].getWorkspaces();
                int j = 0;
                while (j < workspaces.length) {
                    IVfsWorkspace workspace = workspaces[j];
                    this.displayWSItem((IVfsFolderItem)workspace, displayHelper);
                    ++j;
                }
                ++i;
            }
        }
        displayHelper.endDisplay(this._descendingOrder);
        return true;
    }

    public boolean validateArguments() {
        return true;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr workspaces [ " + NameConfig.getOption(OptionName.FIELD, true) + " " + NameConfig.getOption(OptionName.FOLDER, true) + " ] ");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Lists the available workspaces(workspace folders)", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FOLDER, 1, "To be specified if workspace folders have to be listed", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "Using this option you can specify the properties of the workspace( folder) that have to be displayed", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "Example:", false);
        this.printOptionHelp(OptionName.FIELD, 1, NameConfig.getCommandName(CommandName.WORKSPACES, false) + " " + NameConfig.getOption(OptionName.FIELD, true) + "Localpath  <Path>", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "The fields that can be specified are:", false);
        Command.getOut().println();
        this.printOptionHelpEx(OptionName.FIELD, 1, "DisplayName/DN", "Gives display name of the workspace", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "LocalPath/LP", "Absolute local path of the workspace", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "RemotePath/RP", "Absolute remote path of the workspace", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "BrowsePath/BP", "Browse path of the workspace", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, "Description/Des", "Description associated with the workspace", true);
        this.printOptionHelpEx(OptionName.FIELD, 1, ALL, "Prints all the above fields", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FIELD, 1, "For more information on the use of " + NameConfig.getOption(OptionName.FIELD, true) + " option see usage", false);
        this.printOptionHelp(OptionName.FIELD, 1, "dtr " + NameConfig.getCommandName(CommandName.HELP, false) + " Usage", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.SORT, 1, "Using this option you can specify the field based on which sorting of the output has to be done. The fields that can be specified are the ones listed above. Sorting is in ascending order by default", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.DESCENDING, 1, "Specify this option along with sort to sort output in descending order.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.UNFORMATTED, 1, "If this is specified then the field values will not be truncated to fit into a given space. But it might lead to output that is not easy to read.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.UNFORMATTED, 1, "It is recommended that this be used only for scripting.", false);
        Command.getOut().println();
    }

    private void displayWSItem(IVfsFolderItem folderItem, DisplayHelper displayHelper) {
        DisplayHelper.Row row = displayHelper.newRow();
        int k = 0;
        while (k < this._displayFiledsOrdered.size()) {
            Field field = (Field)this._displayFiledsOrdered.get(k);
            try {
                if (field.isIt(WorkspacesCommand.DISPLAY_NAME.fieldName)) {
                    String displayName = folderItem.getDisplayName();
                    if (displayName == null) {
                        displayName = "";
                    }
                    row.addField(field, displayName);
                } else if (field.isIt(WorkspacesCommand.LOCAL_PATH.fieldName)) {
                    String localPath = folderItem.getLocalPath();
                    if (localPath == null) {
                        localPath = "NOT_MOUNTED";
                    }
                    row.addField(field, localPath);
                } else if (field.isIt(WorkspacesCommand.REMOTE_PATH.fieldName)) {
                    row.addField(field, folderItem.getAbsoluteRemotePath());
                } else if (field.isIt(WorkspacesCommand.BROWSE_PATH.fieldName)) {
                    row.addField(field, "/" + folderItem.getBrowsePath());
                } else if (field.isIt(WorkspacesCommand.DESCRIPTION.fieldName)) {
                    IVfsWorkspace workspace = folderItem.asWorkspace();
                    String description = "";
                    if (workspace != null) {
                        description = workspace.getDescription();
                    }
                    if (description == null) {
                        description = "";
                    }
                    row.addField(field, description);
                }
            }
            catch (VfsException exp) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting field " + field.fieldName);
                row.addField(field, "<could not get " + field.fieldName + ">");
            }
            ++k;
        }
        row.end();
    }

    private void displayWSFolder(IVfsGenericFolder genericFolder, boolean displaySelf, DisplayHelper displayHelper) {
        IVfsFolderItem[] folderItems;
        if (displaySelf) {
            this.displayWSItem((IVfsFolderItem)genericFolder, displayHelper);
        }
        try {
            folderItems = genericFolder.getFolderItems();
        }
        catch (VfsException exp) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)exp), "VfsException occurred while getting children for workspace folder " + genericFolder.getLocalPath());
            folderItems = new IVfsFolderItem[]{};
        }
        DisplayHelper unformattedDisplayHelper = new DisplayHelper(this._unformattedOutput);
        unformattedDisplayHelper.startDisplay();
        unformattedDisplayHelper.setKeyField(this._sortField, this._sortKeyType);
        int i = 0;
        while (i < folderItems.length) {
            if (folderItems[i].asWorkspaceFolder() != null) {
                this.displayWSFolder(folderItems[i].asGenericFolder(), true, unformattedDisplayHelper);
            }
            ++i;
        }
        unformattedDisplayHelper.endDisplay(this._descendingOrder);
    }

    private static int getFieldLength(String field, int defVal) {
        return CommandlineProperties.getIntProperty("com.tssap.dtr.client.commandline.field.workspace." + field.toLowerCase(), defVal);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

