/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.Utilities;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspaceFolder;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;

class WorkspaceCommand
extends Command {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$WorkspaceCommand == null ? (class$com$tssap$dtr$client$commandline$WorkspaceCommand = WorkspaceCommand.class$("com.tssap.dtr.client.commandline.WorkspaceCommand")) : class$com$tssap$dtr$client$commandline$WorkspaceCommand));
    private String _workspacePath;
    private boolean _createWSFolder;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$WorkspaceCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new WorkspaceCommand(arguments);
    }

    WorkspaceCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.FOLDER);
        this.addSupportedOption(OptionName.WORKSPACE);
        this._workspacePath = null;
        this._createWSFolder = false;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "creates a workspace";
    }

    public CommandName getCommandName() {
        return CommandName.WORKSPACE;
    }

    public boolean execute() {
        if (this._workspacePath != null) {
            if (this._workspacePath.length() - 1 == this._workspacePath.lastIndexOf("/")) {
                this._workspacePath = this._workspacePath.substring(0, this._workspacePath.length() - 1);
            }
            if (!this._workspacePath.startsWith("//")) {
                this.getFileSystemManager();
                String currDir = Utilities.getCurrentDirectory();
                if (currDir == null || currDir.length() == 0) {
                    currDir = "//";
                }
                this._workspacePath = currDir + this._workspacePath;
            }
            String workspaceName = this._workspacePath.substring(this._workspacePath.lastIndexOf("/") + 1);
            String workspaceFolderPath = this._workspacePath.substring(0, this._workspacePath.lastIndexOf("/") + 1);
            IVfsFolderItem folderItem = this.getResource(workspaceFolderPath);
            IVfsWorkspaceFolder workspaceFolder = null;
            if (folderItem != null) {
                workspaceFolder = folderItem.asWorkspaceFolder();
            }
            IVfsWorkspace workspace = null;
            IVfsWorkspaceFolder newWorkspaceFolder = null;
            String message = "";
            if (workspaceFolder != null) {
                if (this._createWSFolder) {
                    try {
                        newWorkspaceFolder = workspaceFolder.createSubfolder(workspaceName);
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while creating workspace folder " + workspaceName + " under " + workspaceFolderPath);
                        message = e.getMessage();
                    }
                } else {
                    try {
                        workspace = workspaceFolder.createWorkspace(workspaceName);
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while creating workspace " + workspaceName + " under " + workspaceFolderPath);
                        message = e.getMessage();
                    }
                }
            } else {
                if (this._createWSFolder) {
                    Command.getOut().println(" The workspace folder path given for creation is not valid.");
                    this._exitCode = 81;
                } else {
                    Command.getOut().println(" The workspace path given for creation is not valid.");
                    this._exitCode = 80;
                }
                return false;
            }
            if (this._createWSFolder) {
                if (newWorkspaceFolder != null) {
                    Command.getOut().println(" The workspace folder has been created.");
                } else {
                    Command.getOut().println(" The workspace folder could not be created. " + message);
                    this._exitCode = 79;
                }
            } else if (workspace != null) {
                Command.getOut().println(" The workspace has been created.");
            } else {
                Command.getOut().println(" The workspace could not be created. " + message);
                this._exitCode = 78;
            }
        }
        return true;
    }

    public boolean validateArguments() {
        return this._workspacePath != null;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.WORKSPACE, false) + " [ " + NameConfig.getOption(OptionName.FOLDER, true) + " ] " + NameConfig.getOption(OptionName.WORKSPACE, true) + " WorkspacePath");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Creates a workspace", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.WORKSPACE, 1, "Path to specify the workspace (WS folder) to be created", true);
        this.printOptionHelp(OptionName.WORKSPACE, 1, "The path has to be the browse path of the workspace and not the local path. The parent of the workspace or the workspacefolder being created should already exist.", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FOLDER, 1, "To be specified if a workspace folder has to be created", true);
        Command.getOut().println();
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String wShort = NameConfig.getOption(OptionName.WORKSPACE, true);
            String wLong = NameConfig.getOption(OptionName.WORKSPACE, false);
            String fShort = NameConfig.getOption(OptionName.FOLDER, true);
            String fLong = NameConfig.getOption(OptionName.FOLDER, false);
            String currArg = (String)arguments.get(i);
            if (currArg != null) {
                String lowerCaseArg = currArg.toLowerCase();
                if (lowerCaseArg.startsWith(wShort) || lowerCaseArg.startsWith(wLong)) {
                    if (this._workspacePath == null) {
                        String wsName = Command.getActualArgument(currArg, wShort, wLong);
                        if ("".equals(wsName) && i + 1 < arguments.size()) {
                            wsName = (String)arguments.get(i + 1);
                            arguments.remove(i + 1);
                        }
                        arguments.remove(i);
                        --indexOfArgs;
                        this._workspacePath = wsName;
                    }
                } else if (currArg.startsWith(fShort) || lowerCaseArg.startsWith(fLong)) {
                    this._createWSFolder = true;
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

