/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.PropagationCommand;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationException;
import com.tssap.dtr.client.lib.propagation.clientapi.PropagationPreconditionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;

public class ValidateExportBlobCommand
extends PropagationCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$ValidateExportBlobCommand == null ? (class$com$tssap$dtr$client$commandline$ValidateExportBlobCommand = ValidateExportBlobCommand.class$("com.tssap.dtr.client.commandline.ValidateExportBlobCommand")) : class$com$tssap$dtr$client$commandline$ValidateExportBlobCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$ValidateExportBlobCommand;

    public ValidateExportBlobCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.IMPORTFILE);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "Validates the completeness of the propagatable blob (obtained by performing an export)";
    }

    public boolean execute() {
        boolean retVal = false;
        if (!this.pingServer()) {
            return retVal;
        }
        File file = new File(this._fileName);
        Object propagatable = null;
        try {
            if (!this.initializePropagationManager()) {
                Command.getOut().println("Could not get the propagation manager. Please ensure that the server is running and try again.");
                return false;
            }
            FileInputStream stream = new FileInputStream(file);
            this._propManager.validatePropagatableBlob((InputStream)stream);
            this.writeMessage("The propagatable blob '" + file.getAbsolutePath() + "' is complete");
            retVal = true;
        }
        catch (FileNotFoundException ex) {
            Logger.traceUserError(LOCATION, ex, "FileNotFoundException occurred. File \"" + this._fileName + "\" not found or cannot be accessed");
            this.writeMessage("File \"" + this._fileName + "\" not found or cannot be accessed");
        }
        catch (PropagationPreconditionException ex) {
            Logger.traceUserError(LOCATION, (Exception)((Object)ex), "Validate blob failed.");
            this.writeMessage("Validate blob failed. " + ex.getMessage());
        }
        catch (PropagationException ex) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)ex), "Validate blob failed.");
            this.writeMessage("Validate blob failed. " + ex.getMessage());
        }
        return retVal;
    }

    public boolean validateArguments() {
        boolean isValidateArguments = true;
        if (this._fileName == null) {
            this.writeMessage("Must specify file name.");
            isValidateArguments = false;
        } else {
            File file = new File(this._fileName);
            if (!file.exists() || file.isDirectory()) {
                this.writeMessage("File '" + file.getAbsolutePath() + "' does not exist.");
                isValidateArguments = false;
            }
        }
        if (!isValidateArguments) {
            this.writeMessage("Try help for more information.");
        }
        return isValidateArguments;
    }

    public void printHelpDescription() {
        this.writeMessage("");
        this.writeMessage("dtr " + NameConfig.getCommandName(CommandName.VALIDATEBLOB, false) + " " + NameConfig.getOption(OptionName.IMPORTFILE, true) + " \"file name\" ");
        this.writeMessage("");
        this.printOptionHelp(null, 1, "Validates the completeness of the contents of a blob.", false);
        this.writeMessage("");
        this.printOptionHelp(OptionName.IMPORTFILE, 1, "Name of the file which has the blob contents. Must be a valid blob file that was created with the EXPORT command.", true);
    }

    public CommandName getCommandName() {
        return CommandName.VALIDATEBLOB;
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new ValidateExportBlobCommand(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

