/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Cache;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.lib.util.PathUtilities;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.fileservice.IFileService;
import com.tssap.dtr.client.lib.vfs.fileservice.LocalFileService;
import java.io.File;

class Utilities {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$Utilities == null ? (class$com$tssap$dtr$client$commandline$Utilities = Utilities.class$("com.tssap.dtr.client.commandline.Utilities")) : class$com$tssap$dtr$client$commandline$Utilities));
    public static final char WILDCARDCHAR = '*';
    public static final String WILDCARD = "*";
    private static String _currDir = "";
    private static String _currBrowsePath = "";
    private static boolean _inShell = false;
    private static final IFileService _localFileService = new LocalFileService();
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$Utilities;

    Utilities() {
    }

    public static String getCurrentDirectory() {
        if ("".equals(_currBrowsePath)) {
            if (Utilities.isInShell()) {
                Utilities.setCurrentDirectory("//");
            } else {
                String currDir = System.getProperty("user.dir");
                IVersionedFileSystemManager fileSystemMgr = Cache.getCache().getFileSystemManager();
                IVfsFolderItem folderItem = null;
                try {
                    folderItem = fileSystemMgr.getFolderItem(currDir);
                    if (folderItem != null) {
                        Utilities.setCurrentDirectory("/" + folderItem.getBrowsePath());
                    }
                }
                catch (VfsException e) {
                    Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while trying to set shell current directoty to current directory : " + currDir);
                    Utilities.setCurrentDirectory("//");
                }
                if (folderItem == null) {
                    Utilities.setCurrentDirectory("//");
                }
            }
        }
        return _currBrowsePath;
    }

    public static String getCurrentLocalPath() {
        return _currDir;
    }

    public static boolean setCurrentDirectory(String cdir) {
        IVersionedFileSystemManager fileSystemMgr;
        Logger.traceDebug(LOCATION, "SET DIRECTORY : TO " + cdir);
        if (cdir.startsWith("//")) {
            cdir = cdir.substring(1);
        }
        if (!cdir.startsWith("/")) {
            cdir = "/" + cdir;
        }
        if (!cdir.endsWith("/")) {
            cdir = cdir + "/";
        }
        if ((fileSystemMgr = Cache.getCache().getFileSystemManager()) == null) {
            return false;
        }
        IVfsFolderItem folderItem = null;
        try {
            folderItem = fileSystemMgr.getFolderItemByBrowsePath(cdir);
        }
        catch (VfsException e) {
            Logger.traceExceptionWithStackDebug(LOCATION, (Exception)((Object)e), "VfsException occurred while trying to get folder item assuming path " + cdir + " to be browse path. Will try further.");
        }
        if (folderItem != null) {
            if (folderItem.asGenericFolder() == null) {
                Logger.traceDebug(LOCATION, "SET DIRECTORY : FAILS : " + cdir + " is not a folder.");
                return false;
            }
            try {
                _currBrowsePath = "/" + folderItem.getBrowsePath();
            }
            catch (VfsException e) {
                _currBrowsePath = "/" + cdir;
            }
            _currDir = folderItem.getLocalPath() != null && folderItem.getLocalPath().length() > 0 ? folderItem.getLocalPath() : "";
            System.setProperty("user.dir", _currDir);
            Logger.traceDebug(LOCATION, "SET DIRECTORY : DONE : " + cdir);
            return true;
        }
        try {
            folderItem = Utilities.getLocalMountedFolderItemForBrowsePath(cdir);
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while getting folder item for path" + cdir);
            Logger.traceDebug(LOCATION, "SET DIRECTORY : FAILS : " + cdir);
            return false;
        }
        if (folderItem == null || folderItem.asGenericFolder() == null) {
            Logger.traceDebug(LOCATION, "SET DIRECTORY : FAILS : " + cdir + " is not a folder.");
            return false;
        }
        try {
            _currBrowsePath = "/" + folderItem.getBrowsePath();
        }
        catch (VfsException e) {
            _currBrowsePath = "/" + cdir;
        }
        PathUtilities.assureTrailingSeparator((String)_currBrowsePath, (IFileService)PathUtilities.REMOTE_FILESERVICE);
        _currDir = folderItem.getLocalPath();
        System.setProperty("user.dir", _currDir);
        return true;
    }

    public static void setIsInShell(boolean bVal) {
        _inShell = bVal;
    }

    public static boolean isInShell() {
        return _inShell;
    }

    public static IVfsFolderItem getLocalMountedFolderItemForBrowsePath(String browsePath) throws VfsException {
        IVersionedFileSystemManager fileSystemManager = Cache.getCache().getFileSystemManager();
        String tempBrowsePath = browsePath;
        IVfsFolderItem folderItem = Utilities.getAvailableFolderItemInPath(tempBrowsePath);
        if (folderItem == null) {
            return folderItem;
        }
        tempBrowsePath = folderItem.getBrowsePath();
        tempBrowsePath = PathUtilities.preventTrailingSeparator((String)tempBrowsePath, (IFileService)PathUtilities.REMOTE_FILESERVICE);
        String localPath = folderItem.getLocalPath();
        if (localPath == null) {
            return null;
        }
        localPath = PathUtilities.assureTrailingSeparator((String)localPath, (IFileService)_localFileService);
        String relativePathFromMP = browsePath.substring(tempBrowsePath.length());
        if ((relativePathFromMP = PathUtilities.preventTrailingSeparator((String)relativePathFromMP, (IFileService)PathUtilities.REMOTE_FILESERVICE)).startsWith("/")) {
            relativePathFromMP = relativePathFromMP.substring(1);
        }
        relativePathFromMP = relativePathFromMP.replace('/', File.separatorChar);
        String localPofGivenDir = localPath + relativePathFromMP;
        folderItem = null;
        File file = new File(localPofGivenDir);
        if (!file.exists()) {
            return null;
        }
        folderItem = fileSystemManager.getFolderItem(localPofGivenDir);
        return folderItem;
    }

    public static IVfsFolderItem getAvailableFolderItemInPath(String browsePath) throws VfsException {
        IVersionedFileSystemManager fileSystemManager = Cache.getCache().getFileSystemManager();
        String tempBrowsePath = browsePath;
        tempBrowsePath = PathUtilities.assureTrailingSeparator((String)tempBrowsePath, (IFileService)PathUtilities.REMOTE_FILESERVICE);
        IVfsFolderItem folderItem = null;
        while (tempBrowsePath.length() > 0 && folderItem == null) {
            if ((tempBrowsePath = PathUtilities.getParentPath((String)tempBrowsePath, (IFileService)PathUtilities.REMOTE_FILESERVICE, (boolean)false)).length() == 0) {
                tempBrowsePath = "/";
            }
            try {
                folderItem = fileSystemManager.getFolderItemByBrowsePath(tempBrowsePath);
            }
            catch (VfsException e) {
                if (tempBrowsePath.equals("/")) {
                    tempBrowsePath = "";
                    throw e;
                }
                Logger.traceDebug(LOCATION, "Failed to get folder while looking for the available folder item in path. Path : " + tempBrowsePath + ". " + e.getMessage());
            }
        }
        return folderItem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

