/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.vfs.IVfsFile;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import java.util.Arrays;

class UploadCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$UploadCommand == null ? (class$com$tssap$dtr$client$commandline$UploadCommand = UploadCommand.class$("com.tssap.dtr.client.commandline.UploadCommand")) : class$com$tssap$dtr$client$commandline$UploadCommand));
    private boolean _forceUpload;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$UploadCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new UploadCommand(arguments);
    }

    UploadCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.FORCE);
        this._forceUpload = false;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "uploads the content of a checked out file to the server (without checking in)";
    }

    public CommandName getCommandName() {
        return CommandName.UPLOAD;
    }

    public boolean execute() {
        int i = 0;
        while (i < this._resourcePaths.length) {
            block11: {
                if (this._resourcePaths[i] != null) {
                    IVfsFolderItem folderItem = this.getResource(this._resourcePaths[i]);
                    IVfsFile vfsfile = null;
                    if (folderItem != null) {
                        vfsfile = folderItem.asFile();
                    }
                    if (vfsfile != null) {
                        VfsActionOnFolderItem[] actionsPoss = vfsfile.getActionsForCurrentState();
                        try {
                            if (this._forceUpload) {
                                if (Arrays.asList(actionsPoss).contains(VfsActionOnFolderItem.FORCE_UPLOAD)) {
                                    vfsfile.forceUpload();
                                } else {
                                    this._exitCode = 20;
                                }
                                break block11;
                            }
                            if (Arrays.asList(actionsPoss).contains(VfsActionOnFolderItem.UPLOAD)) {
                                vfsfile.upload();
                                break block11;
                            }
                            this._exitCode = 20;
                        }
                        catch (VfsException e) {
                            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while uploading folder item " + this._resourcePaths[i]);
                            Command.getOut().println("Could not upload folder item " + this._resourcePaths[i]);
                            this._exitCode = 21;
                        }
                    } else {
                        Command.getOut().println("Could not retrive folder item " + this._resourcePaths[i]);
                    }
                }
            }
            ++i;
        }
        return true;
    }

    public boolean validateArguments() {
        return this._resourcePaths != null && this._resourcePaths.length != 0;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.UPLOAD, false) + " [" + NameConfig.getOption(OptionName.FORCE, true) + "] FolderPath(s)");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Uploads the file to the server", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FORCE, 1, "If this option is specified the file is uploaded even if there was no change in the file from the time it was last uploaded.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FORCE, 1, "If the option is not specified the file will be uploaded only if it has changed since it was last uploaded.", true);
        Command.getOut().println();
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            String lowerCaseArg;
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            String fShort = NameConfig.getOption(OptionName.FORCE, true);
            String fLong = NameConfig.getOption(OptionName.FORCE, false);
            if (currArg != null && (fShort.equals(lowerCaseArg = currArg.toLowerCase()) || fLong.equals(lowerCaseArg))) {
                this._forceUpload = true;
                arguments.remove(i);
                --indexOfArgs;
            }
            ++indexOfArgs;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

