/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.VfsActionOnActivity;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import java.util.Arrays;

class UploadActCommand
extends ActivityCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$UploadActCommand == null ? (class$com$tssap$dtr$client$commandline$UploadActCommand = UploadActCommand.class$("com.tssap.dtr.client.commandline.UploadActCommand")) : class$com$tssap$dtr$client$commandline$UploadActCommand));
    private boolean _forceUpload;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$UploadActCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new UploadActCommand(arguments);
    }

    UploadActCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.FORCE);
        this._forceUpload = false;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return null;
    }

    public String getName() {
        return null;
    }

    public boolean execute() {
        IVfsActivity activity = this.getActivity(false, true);
        if (activity == null) {
            return false;
        }
        try {
            VfsActionOnActivity[] allowedActions = activity.getActionsForCurrentState();
            if (this._forceUpload) {
                if (Arrays.asList(allowedActions).contains(VfsActionOnActivity.FORCE_UPLOAD)) {
                    activity.forceUpload();
                } else {
                    this._exitCode = 41;
                }
            } else if (Arrays.asList(allowedActions).contains(VfsActionOnActivity.UPLOAD)) {
                activity.upload();
            } else {
                this._exitCode = 41;
            }
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while uploading activity.");
            Command.getOut().println("Uploading activity failed. " + e.getMessage());
            this._exitCode = 42;
            return false;
        }
        return true;
    }

    public boolean validateArguments() {
        return true;
    }

    public void printHelpDescription() {
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            String lowerCaseArg;
            int i = indexOfArgs;
            String fShort = NameConfig.getOption(OptionName.FORCE, true);
            String fLong = NameConfig.getOption(OptionName.FORCE, false);
            String currArg = (String)arguments.get(i);
            if (currArg != null && (fShort.equals(lowerCaseArg = currArg.toLowerCase()) || fLong.equals(lowerCaseArg))) {
                this._forceUpload = true;
                arguments.remove(i);
                --indexOfArgs;
            }
            ++indexOfArgs;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

