/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.ActivityCommand;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.VfsActionOnActivity;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;
import java.util.Arrays;

class UncheckoutActCommand
extends ActivityCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$UncheckoutActCommand == null ? (class$com$tssap$dtr$client$commandline$UncheckoutActCommand = UncheckoutActCommand.class$("com.tssap.dtr.client.commandline.UncheckoutActCommand")) : class$com$tssap$dtr$client$commandline$UncheckoutActCommand));
    private boolean _unchangedItemsOnly = false;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$UncheckoutActCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new UncheckoutActCommand(arguments);
    }

    UncheckoutActCommand(ArrayList arguments) {
        super(arguments);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return null;
    }

    public String getName() {
        return null;
    }

    public boolean execute() {
        IVfsActivity activity = this.getActivity(false, true);
        if (activity == null) {
            return false;
        }
        try {
            VfsActionOnActivity[] actionsPoss = activity.getActionsForCurrentState();
            if (this._unchangedItemsOnly) {
                if (Arrays.asList(actionsPoss).contains(VfsActionOnActivity.UNCHECKOUT_UNCHANGED_ITEMS)) {
                    activity.uncheckoutUnchangedActivityElements();
                } else {
                    Command.getOut().println("Uncheckout of unchaged items in activity is not allowed.");
                    this._exitCode = 99;
                }
            } else if (Arrays.asList(actionsPoss).contains(VfsActionOnActivity.UNCHECKOUT)) {
                activity.uncheckout();
            } else {
                Command.getOut().println("Uncheckout of activity is not allowed.");
                this._exitCode = 99;
            }
        }
        catch (VfsException e) {
            Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while unchecking out activity items.");
            Command.getOut().println("Uncheckout of activity falied. " + e.getMessage());
            this._exitCode = 43;
            return false;
        }
        return true;
    }

    public boolean validateArguments() {
        return true;
    }

    public void printHelpDescription() {
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            String lowerCaseArg;
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            String xShort = NameConfig.getOption(OptionName.ACT_UNCO_UNCHANGED_ONLY, true);
            String xLong = NameConfig.getOption(OptionName.ACT_UNCO_UNCHANGED_ONLY, false);
            if (currArg != null && (xShort.equals(lowerCaseArg = currArg.toLowerCase()) || xLong.equals(lowerCaseArg))) {
                this._unchangedItemsOnly = true;
                arguments.remove(i);
                --indexOfArgs;
            }
            ++indexOfArgs;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

