/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.lib.vfs.config.IClient;
import com.tssap.dtr.client.lib.vfs.config.ILogicalSystem;
import java.util.ArrayList;
import java.util.Iterator;

class SystemTemplatesCommand
extends Command {
    public ICommand createCommand(String name, ArrayList arguments) {
        return new SystemTemplatesCommand(arguments);
    }

    SystemTemplatesCommand(ArrayList arguments) {
        super(arguments);
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "displays all the available logical systems";
    }

    public CommandName getCommandName() {
        return CommandName.SYSTEMS;
    }

    public boolean execute() {
        Iterator clients = this.getCacheConfiguration().clients();
        if (!clients.hasNext()) {
            return true;
        }
        Command.getOut().println();
        while (clients.hasNext()) {
            IClient client = (IClient)clients.next();
            ILogicalSystem system = client.getLogicalSystem();
            Command.getOut().println(system.getName());
        }
        return true;
    }

    public boolean validateArguments() {
        return true;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.SYSTEMS, false));
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Lists the available logical systems which can then be viewed or editedusing the '" + NameConfig.getCommandName(CommandName.CONFIG, false) + "' command", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "dtr " + NameConfig.getCommandName(CommandName.CONFIG, false) + " " + NameConfig.getOption(OptionName.SYSTEM, true) + " <system name>", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "For more information on the use of '" + NameConfig.getCommandName(CommandName.CONFIG, false) + "' command give", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "dtr " + NameConfig.getCommandName(CommandName.HELP, false) + " " + NameConfig.getCommandName(CommandName.CONFIG, false), false);
        Command.getOut().println();
    }

    public boolean requiresLogon() {
        return false;
    }
}

