/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.OptionName;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.lib.vfs.VfsActionOnFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemActivityState;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.dtr.client.lib.vfs.actions.SyncAction;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;

class SyncCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$SyncCommand == null ? (class$com$tssap$dtr$client$commandline$SyncCommand = SyncCommand.class$("com.tssap.dtr.client.commandline.SyncCommand")) : class$com$tssap$dtr$client$commandline$SyncCommand));
    private Calendar _syncToDate;
    private boolean _forceSync;
    private boolean _previewSync;
    private boolean _actVersToCurrentState;
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$SyncCommand;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new SyncCommand(arguments);
    }

    SyncCommand(ArrayList arguments) {
        super(arguments);
        this.addSupportedOption(OptionName.FORCE);
        this.addSupportedOption(OptionName.PREVIEW);
        this.addSupportedOption(OptionName.TIMESTAMP);
        this._syncToDate = null;
        this._forceSync = false;
        this._previewSync = false;
        this._actVersToCurrentState = false;
        this.setArguments(arguments);
    }

    public String getDescription() {
        return "synchronizes the local file system to the view on server";
    }

    public CommandName getCommandName() {
        return CommandName.SYNC;
    }

    /*
     * Unable to fully structure code
     */
    public boolean execute() {
        block62: {
            if (this._resourcePaths == null && (this._activityNames == null || this._activityNames.length == 0)) {
                return true;
            }
            if (this._activityNames != null && this._activityNames.length > 0) {
                workspace = this.getWorkspace();
                if (workspace == null) {
                    Command.getOut().println("Workspace cannot be resolved. Activity contents of the specified activities cannot be synced");
                    this._exitCode = 30;
                    return false;
                }
                resPaths = new ArrayList<String>();
                i = 0;
                while (i < this._activityNames.length) {
                    this._activityName = this._activityNames[i];
                    activity = this.getActivity(true, false);
                    if (activity == null) {
                        Command.getOut().println("Activity " + this._activityName + " could not be retrieved.");
                    } else if (this._actVersToCurrentState) {
                        versions = null;
                        try {
                            versions = activity.getElementsFromClosedActivity();
                        }
                        catch (VfsException e) {
                            Logger.traceInternalError(SyncCommand.LOCATION, (Exception)e, "VfsException occurred while getting versions for activity " + this._activityName);
                            Command.getOut().println("Could not sync the files in activity " + this._activityName + ". " + e.getMessage());
                            this._exitCode = 45;
                        }
                        if (versions != null) {
                            j = 0;
                            while (j < versions.length) {
                                try {
                                    if (versions[j].isFile()) {
                                        resPaths.add("/" + versions[j].getRepresentingFile(workspace).getBrowsePath());
                                    }
                                }
                                catch (VfsException e) {
                                    Logger.traceInternalError(SyncCommand.LOCATION, (Exception)e, "VfsException occurred while getting file for version " + versions[j].getDisplayName());
                                    Command.getOut().println("Sync will not be attempted for version " + versions[j].getDisplayName() + " as the corresponding file could not be retrieved.");
                                }
                                ++j;
                            }
                        }
                    } else {
                        try {
                            activity.syncContent(workspace);
                        }
                        catch (VfsException e) {
                            Logger.traceInternalError(SyncCommand.LOCATION, (Exception)e, "VfsException occurred while syncing to activity " + this._activityName);
                            Command.getOut().println("Could not sync the activity " + this._activityName + ". " + e.getMessage());
                            this._exitCode = 44;
                        }
                    }
                    ++i;
                }
                if (resPaths.size() > 0) {
                    if (this._resourcePaths != null) {
                        resPaths.addAll(Arrays.asList(this._resourcePaths));
                        this._resourcePaths = null;
                    }
                    this._resourcePaths = new String[resPaths.size()];
                    this._resourcePaths = resPaths.toArray(this._resourcePaths);
                    if (this._resourceBranchSeqNums != null) {
                        tempRevArr = this._resourceBranchSeqNums;
                        this._resourceBranchSeqNums = null;
                        this._resourceBranchSeqNums = new Integer[resPaths.size()];
                        Arrays.fill((Object[])this._resourceBranchSeqNums, new Integer(-1));
                        i = resPaths.size() - tempRevArr.length;
                        while (i < this._resourceBranchSeqNums.length) {
                            this._resourceBranchSeqNums[i] = tempRevArr[i - (resPaths.size() - tempRevArr.length)];
                            ++i;
                        }
                    } else {
                        this._resourceBranchSeqNums = new Integer[resPaths.size()];
                        Arrays.fill((Object[])this._resourceBranchSeqNums, new Integer(-1));
                    }
                    if (this._resourceRevisions != null) {
                        tempRevArr = this._resourceRevisions;
                        this._resourceRevisions = null;
                        this._resourceRevisions = new Integer[resPaths.size()];
                        Arrays.fill((Object[])this._resourceRevisions, new Integer(-1));
                        i = resPaths.size() - tempRevArr.length;
                        while (i < this._resourceRevisions.length) {
                            this._resourceRevisions[i] = tempRevArr[i - (resPaths.size() - tempRevArr.length)];
                            ++i;
                        }
                    } else {
                        this._resourceRevisions = new Integer[resPaths.size()];
                        Arrays.fill((Object[])this._resourceRevisions, new Integer(-1));
                    }
                }
            }
            if (this._resourcePaths == null) break block62;
            i = 0;
            while (i < this._resourcePaths.length) {
                block61: {
                    block64: {
                        block63: {
                            if (this._resourcePaths[i] == null) break block61;
                            folderItem = this.getResource(this._resourcePaths[i]);
                            if (folderItem != null) break block63;
                            Command.getOut().println("Could not retrive folder item " + this._resourcePaths[i]);
                            break block61;
                        }
                        activityRecordedFolderItem = folderItem.asActivityRecordedFolderItem();
                        if (folderItem == null) ** GOTO lbl-1000
                        allowedActions = folderItem.getActionsForCurrentState();
                        if (this._syncToDate != null || this._forceSync || this._previewSync) ** GOTO lbl-1000
                        if (-1 != this._resourceBranchSeqNums[i] || -1 != this._resourceRevisions[i]) break block64;
                        if (Arrays.asList(allowedActions).contains(VfsActionOnFolderItem.SYNC_TO_LATEST)) ** GOTO lbl-1000
                        mes = "";
                        this._exitCode = 8;
                        if (activityRecordedFolderItem != null && activityRecordedFolderItem.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                            mes = "Folder item is checked out. ";
                            this._exitCode = 26;
                        } else if (folderItem.getLocationState() == VfsFolderItemLocationState.SYNCED_TO_LATEST) {
                            mes = "Folder item is in sync. ";
                            this._exitCode = 27;
                        } else if (folderItem.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED) {
                            mes = "Folder item is not mounted. ";
                            this._exitCode = 67;
                        } else if (folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
                            mes = "Folder item is local only. ";
                            this._exitCode = 25;
                        }
                        Command.getOut().println(mes + "Cannot sync folder item " + this._resourcePaths[i]);
                        break block61;
                    }
                    if (!Arrays.asList(allowedActions).contains(VfsActionOnFolderItem.SYNC_TO_PREVIOUS)) {
                        mes = "";
                        this._exitCode = 8;
                        if (activityRecordedFolderItem != null && activityRecordedFolderItem.getActivityState() != VfsFolderItemActivityState.NOT_CHECKED_OUT) {
                            mes = "Folder item is checked out. ";
                            this._exitCode = 26;
                        } else if (folderItem.getLocationState() == VfsFolderItemLocationState.NOT_MOUNTED) {
                            mes = "Folder item is not mounted. ";
                            this._exitCode = 67;
                        } else if (folderItem.getLocationState() == VfsFolderItemLocationState.LOCAL_ONLY) {
                            mes = "Folder item is local only. ";
                            this._exitCode = 25;
                        }
                        Command.getOut().println(mes + "Cannot sync folder item " + this._resourcePaths[i]);
                    } else if (this._syncToDate == null) {
                        if (-1 == this._resourceBranchSeqNums[i] && -1 == this._resourceRevisions[i]) {
                            newSyncAction = new SyncAction(folderItem, this._forceSync, this._previewSync);
                            newSyncAction.execute();
                        } else if (-1 != this._resourceBranchSeqNums[i]) {
                            if (this._resourceBranchSeqNums[i] == 0) {
                                Command.getOut().println("Invalid Branch sequence number. They should start from 1. Cannot sync folder item " + this._resourcePaths[i]);
                            } else {
                                file = folderItem.asFile();
                                if (file == null) {
                                    Command.getOut().println("Not a file. Cannot sync folder item " + this._resourcePaths[i]);
                                } else {
                                    try {
                                        file.syncToBranchSequenceNumber(this._resourceBranchSeqNums[i].intValue());
                                    }
                                    catch (VfsException e) {
                                        Logger.traceInternalError(SyncCommand.LOCATION, (Exception)e, "VfsException occurred while trying to sync folder item " + this._resourcePaths[i] + " to branch sequence number " + this._resourceRevisions[i]);
                                        Command.getOut().println(e.getMessage() + ". Cannot sync folder item " + this._resourcePaths[i]);
                                        this._exitCode = 28;
                                    }
                                }
                            }
                        } else if (this._resourceRevisions[i] == 0) {
                            Command.getOut().println("Invalid Revision number. They should start from 1. Cannot sync folder item " + this._resourcePaths[i]);
                        } else {
                            file = folderItem.asFile();
                            if (file == null) {
                                Command.getOut().println("Not a file. Cannot sync folder item " + this._resourcePaths[i]);
                            } else {
                                try {
                                    revisions = file.refreshAndGetVersion().getVersionHistory().getRevisionsInWorkspace(file.getWorkspace().getAbsoluteRemotePath());
                                    if (revisions.length < this._resourceRevisions[i]) {
                                        Command.getOut().println("Given revision does not exist. They should start from 1. Cannot sync folder item " + this._resourcePaths[i]);
                                        break block61;
                                    }
                                    rev = revisions[revisions.length - this._resourceRevisions[i]];
                                    rev.getVersion().syncToVersion(file.getWorkspace());
                                }
                                catch (VfsException e) {
                                    Logger.traceInternalError(SyncCommand.LOCATION, (Exception)e, "VfsException occurred while trying to sync folder item " + this._resourcePaths[i] + " to revsion number " + this._resourceRevisions[i]);
                                    Command.getOut().println(e.getMessage() + ". Cannot sync folder item " + this._resourcePaths[i]);
                                    this._exitCode = 28;
                                }
                            }
                        }
                    } else {
                        try {
                            folderItem.syncToDate(this._syncToDate);
                        }
                        catch (VfsException e) {
                            Logger.traceInternalError(SyncCommand.LOCATION, (Exception)e, "VfsException occurred while syncing folder " + folderItem.getLocalPath() + " to date.");
                            this._exitCode = 28;
                        }
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public boolean validateArguments() {
        if (this._forceSync && this._previewSync) {
            Command.getOut().println("Cannot have both force and preview set at the same time");
            return false;
        }
        return this._resourcePaths != null || this._activityNames != null && this._activityNames.length != 0;
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.SYNC, false) + " [FolderItempath[@BranchSeqNum][#RevNum]]... [" + NameConfig.getOption(OptionName.ACTIVITY, true) + " [ " + NameConfig.getOption(OptionName.WORKSPACE, true) + " ] " + NameConfig.getOption(OptionName.TIMESTAMP, true) + " yyyy-mm-dd hh:mm:ss " + NameConfig.getOption(OptionName.FORCE, true) + " " + NameConfig.getOption(OptionName.PREVIEW, true) + "]");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Synchronizes the folder item on the local file system with the view on the server.", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Takes the path(local/remote) as an argument. Wild characters are accepted", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "The revision with branch sequience number to be synced can be specified by suffixing the path by a '@' character followed by the branch sequience number required.", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "The revision with revision number to be synced can be specified by suffixing the path by a '#' character followed by the revision number required.", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If no branch sequence number or revisin number is specified then the contents of the latest version of this file on the server are synced.", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.FORCE, 1, "If specified the given folder item is synced to the latest even if it has already been synced or is writable ", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.PREVIEW, 1, "If specified the given folder item is not synced but only a preview of what will be synced is shown", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.ACTIVITY, 1, "If specified the versions which are present in the given activity will be synced.", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.WORKSPACE, 1, "workspace path to specify the workspace under which the activity exists. To be given if activity name is specified. If not given current directory will be used to resolve the workspace.", true);
        this.printOptionHelp(OptionName.WORKSPACE, 1, "Versions will be synced to this workspace.", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.TIMESTAMP, 1, "If specified the given folder item is synced to the state at the given timestamp", true);
        Command.getOut().println();
        this.printOptionHelp(OptionName.TIMESTAMP, 1, "The format of the timestamp is:", false);
        this.printOptionHelp(OptionName.TIMESTAMP, 1, "yyyy-mm-dd hh:mm:ss", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.TIMESTAMP, 1, "Example specification", false);
        this.printOptionHelp(OptionName.TIMESTAMP, 1, NameConfig.getCommandName(CommandName.SYNC, false) + " xyz " + NameConfig.getOption(OptionName.TIMESTAMP, true) + " \"2002-06-01 18:32:77\"", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.TIMESTAMP, 1, "Another use of " + NameConfig.getOption(OptionName.TIMESTAMP, true) + " is in conjugation with " + NameConfig.getOption(OptionName.ACTIVITY, true) + "/" + NameConfig.getOption(OptionName.WORKSPACE, true) + " options", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.TIMESTAMP, 1, "Specification", false);
        this.printOptionHelp(OptionName.TIMESTAMP, 1, NameConfig.getCommandName(CommandName.SYNC, false) + " " + NameConfig.getOption(OptionName.ACTIVITY, true) + " <Act name> " + NameConfig.getOption(OptionName.WORKSPACE, true) + " <ws path> " + NameConfig.getOption(OptionName.TIMESTAMP, true) + " NOW", false);
        Command.getOut().println();
        this.printOptionHelp(OptionName.TIMESTAMP, 1, "Here the latest versions of the files who have versions present in this activity will be synced to client in given workspace", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Note that all the parameters can't be specified together", false);
        this.printOptionHelp(null, 1, "i.e. you can specify either one of", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "1. timestamp", false);
        this.printOptionHelp(null, 1, "2. branch sequence number", false);
        this.printOptionHelp(null, 1, "3. revision number", false);
        this.printOptionHelp(null, 1, "4. force/preview", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If force and preview are specified together then the command is not executed.", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If the others are specified together then the order of priority will be the order in which the options have been listed", false);
        Command.getOut().println();
    }

    public void setArguments(ArrayList arguments) {
        int indexOfArgs = 0;
        while (indexOfArgs < arguments.size()) {
            int i = indexOfArgs;
            String currArg = (String)arguments.get(i);
            String tsShort = NameConfig.getOption(OptionName.TIMESTAMP, true);
            String tsLong = NameConfig.getOption(OptionName.TIMESTAMP, false);
            String fShort = NameConfig.getOption(OptionName.FORCE, true);
            String fLong = NameConfig.getOption(OptionName.FORCE, false);
            String pShort = NameConfig.getOption(OptionName.PREVIEW, true);
            String pLong = NameConfig.getOption(OptionName.PREVIEW, false);
            String wsShort = NameConfig.getOption(OptionName.WORKSPACE, true);
            String wsLong = NameConfig.getOption(OptionName.WORKSPACE, false);
            if (currArg != null) {
                String lowerCaseArg = currArg.toLowerCase();
                if (tsShort.equalsIgnoreCase(lowerCaseArg) || tsLong.equalsIgnoreCase(lowerCaseArg)) {
                    if (i + 1 < arguments.size()) {
                        String timeStamp = (String)arguments.get(i + 1);
                        if ("NOW".equals(timeStamp)) {
                            this._actVersToCurrentState = true;
                        } else {
                            Timestamp timestamp;
                            try {
                                timestamp = Timestamp.valueOf(timeStamp);
                            }
                            catch (IllegalArgumentException exp) {
                                Logger.traceUserError(LOCATION, exp, "IllegalArgumentException occurred while getting timestamp from " + timeStamp);
                                Command.getOut().println("The given date is in an incorrect format.please see help for the correct format.");
                                break;
                            }
                            this._syncToDate = Calendar.getInstance();
                            this._syncToDate.setTime(timestamp);
                        }
                        arguments.remove(i + 1);
                        arguments.remove(i);
                        --indexOfArgs;
                    }
                } else if (lowerCaseArg.startsWith(wsShort) || lowerCaseArg.startsWith(wsLong)) {
                    String wsName = Command.getActualArgument(currArg, wsShort, wsLong);
                    if ("".equals(wsName) && i + 1 < arguments.size()) {
                        wsName = (String)arguments.get(i + 1);
                        arguments.remove(i + 1);
                    }
                    this._workspacePaths = null;
                    this._workspacePaths = new String[1];
                    this._workspacePaths[0] = wsName;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (fShort.equalsIgnoreCase(lowerCaseArg) || fLong.equalsIgnoreCase(lowerCaseArg)) {
                    this._forceSync = true;
                    arguments.remove(i);
                    --indexOfArgs;
                } else if (pShort.equalsIgnoreCase(lowerCaseArg) || pLong.equalsIgnoreCase(lowerCaseArg)) {
                    this._previewSync = true;
                    arguments.remove(i);
                    --indexOfArgs;
                }
            }
            ++indexOfArgs;
        }
        super.setArguments(arguments);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

