/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.ResourceCommand;
import com.tssap.dtr.client.commandline.Utilities;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.VfsException;
import java.util.ArrayList;

class SomethingCheckedOutCommand
extends ResourceCommand {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$SomethingCheckedOutCommand == null ? (class$com$tssap$dtr$client$commandline$SomethingCheckedOutCommand = SomethingCheckedOutCommand.class$("com.tssap.dtr.client.commandline.SomethingCheckedOutCommand")) : class$com$tssap$dtr$client$commandline$SomethingCheckedOutCommand));
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$SomethingCheckedOutCommand;

    public SomethingCheckedOutCommand(ArrayList arguments) {
        super(arguments);
        this.setArguments(arguments);
    }

    public ICommand createCommand(String name, ArrayList arguments) {
        return new SomethingCheckedOutCommand(arguments);
    }

    public boolean execute() {
        if (this._resourcePaths != null && this._resourcePaths.length > 0) {
            int i = 0;
            while (i < this._resourcePaths.length) {
                IVfsFolderItem folderItem = this.getResource(this._resourcePaths[i]);
                if (folderItem != null && folderItem.asFolder() != null) {
                    try {
                        this.printField(70, "/" + folderItem.getBrowsePath());
                        String result = this.getFileSystemManager().isSomethingCheckedOutUnderFolder(folderItem.asFolder()) ? "True" : "False";
                        this._exitCode = result.equals("True") ? 89 : 90;
                        this.printField(15, result);
                        Command.getOut().println();
                    }
                    catch (VfsException e) {
                        Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while checking for checkouts under folder " + folderItem.getLocalPath());
                        this._exitCode = 77;
                        this.printField(70, folderItem.getLocalPath());
                        this.printField(15, "Check Failed");
                        Command.getOut().println();
                    }
                }
                ++i;
            }
            return true;
        }
        if (this.getFileSystemManager() == null) {
            return false;
        }
        IVfsFolderItem folderItem = null;
        folderItem = this.getResource(Utilities.getCurrentDirectory());
        if (folderItem != null && folderItem.asFolder() != null) {
            try {
                this.printField(70, "/" + folderItem.getBrowsePath());
                String result = this.getFileSystemManager().isSomethingCheckedOutUnderFolder(folderItem.asFolder()) ? "True" : "False";
                this._exitCode = result.equals("True") ? 89 : 90;
                this.printField(15, result);
                Command.getOut().println();
            }
            catch (VfsException e) {
                Logger.traceInternalError(LOCATION, (Exception)((Object)e), "VfsException occurred while checking for checkouts under folder " + folderItem.getLocalPath());
                this._exitCode = 77;
                this.printField(70, folderItem.getLocalPath());
                this.printField(15, "Check Failed");
                Command.getOut().println();
            }
        }
        return true;
    }

    public CommandName getCommandName() {
        return CommandName.ISCOUF;
    }

    public String getDescription() {
        return "Indicates whether there are any files/folders under this folder which are checkedout";
    }

    public void printHelpDescription() {
        Command.getOut().println();
        Command.getOut().println("dtr " + NameConfig.getCommandName(CommandName.ISCOUF, true) + " Folderpath...");
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Indicates if the specified folder has items that are checkedout", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "Takes the path(local/remote) as an argument. Wild characters are accepted", false);
        Command.getOut().println();
        this.printOptionHelp(null, 1, "If in shell mode and no folder is specified then the current directory is used if possible.", false);
        Command.getOut().println();
    }

    public boolean validateArguments() {
        return true;
    }

    public boolean isHidden() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

