/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.commandline;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.commandline.Command;
import com.tssap.dtr.client.commandline.CommandName;
import com.tssap.dtr.client.commandline.ICommand;
import com.tssap.dtr.client.commandline.Logger;
import com.tssap.dtr.client.commandline.NameConfig;
import com.tssap.dtr.client.commandline.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

class ShellCommands
extends Command {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$tssap$dtr$client$commandline$ShellCommands == null ? (class$com$tssap$dtr$client$commandline$ShellCommands = ShellCommands.class$("com.tssap.dtr.client.commandline.ShellCommands")) : class$com$tssap$dtr$client$commandline$ShellCommands));
    private String _commandName;
    private String _shellCommandArgument;
    static final String CD = NameConfig.getCommandName(CommandName.CD, false);
    static final String REFRESH = NameConfig.getCommandName(CommandName.REFRESH, false);
    static final String DIR = NameConfig.getCommandName(CommandName.DIR, false);
    static final String LDIR = NameConfig.getCommandName(CommandName.LDIR, false);
    static final String RDIR = NameConfig.getCommandName(CommandName.RDIR, false);
    static /* synthetic */ Class class$com$tssap$dtr$client$commandline$ShellCommands;

    public ICommand createCommand(String name, ArrayList arguments) {
        return new ShellCommands(arguments, name);
    }

    ShellCommands(ArrayList arguments, String cmdName) {
        super(arguments);
        this._commandName = cmdName;
        this._shellCommandArgument = null;
        this.setArguments(arguments);
    }

    public String getDescription() {
        if (CD.equals(this._commandName)) {
            return "changes/prints current folder when in shell";
        }
        if (REFRESH.equals(this._commandName)) {
            return "refreshes the shell";
        }
        if (DIR.equals(this._commandName)) {
            return "lists the local and remote files/folders in the current folder";
        }
        if (LDIR.equals(this._commandName)) {
            return "lists the local files/folders in the current folder";
        }
        if (RDIR.equals(this._commandName)) {
            return "lists the remote files/folders in the current folder";
        }
        return "";
    }

    public CommandName getCommandName() {
        if (CD.equals(this._commandName)) {
            return CommandName.CD;
        }
        if (REFRESH.equals(this._commandName)) {
            return CommandName.REFRESH;
        }
        if (DIR.equals(this._commandName)) {
            return CommandName.DIR;
        }
        if (LDIR.equals(this._commandName)) {
            return CommandName.LDIR;
        }
        if (RDIR.equals(this._commandName)) {
            return CommandName.RDIR;
        }
        return null;
    }

    public boolean execute() {
        if (CD.equals(this._commandName)) {
            this.getFileSystemManager();
            this._shellCommandArgument = this._shellCommandArgument.replace(File.separatorChar, '/');
            if ("..".equals(this._shellCommandArgument)) {
                int index;
                this._shellCommandArgument = Utilities.getCurrentDirectory();
                if (this._shellCommandArgument.endsWith("/")) {
                    this._shellCommandArgument = this._shellCommandArgument.substring(0, this._shellCommandArgument.length() - 1);
                }
                if (-1 == (index = this._shellCommandArgument.lastIndexOf("/"))) {
                    return true;
                }
                this._shellCommandArgument = this._shellCommandArgument.substring(0, index + 1);
                Utilities.setCurrentDirectory(this._shellCommandArgument);
                return true;
            }
            if ("//".equals(this._shellCommandArgument) || "/".equals(this._shellCommandArgument)) {
                Utilities.setCurrentDirectory("//");
                return true;
            }
            if (-1 != this._shellCommandArgument.indexOf(42)) {
                String[] paths = this.getResourcePathsUsingFilter(Utilities.getCurrentDirectory(), this._shellCommandArgument, true, true);
                if (paths.length == 1) {
                    this._shellCommandArgument = paths[0];
                } else if (paths.length > 1) {
                    return true;
                }
            }
            String addSeparatorChar = "/";
            String curDirPath = Utilities.getCurrentDirectory();
            if (curDirPath.endsWith("/")) {
                curDirPath = curDirPath.substring(0, curDirPath.length() - 1);
            }
            if (this._shellCommandArgument.startsWith("//")) {
                if (!this._shellCommandArgument.substring(2).startsWith("/")) {
                    if (!Utilities.setCurrentDirectory(this._shellCommandArgument)) {
                        Command.getOut().println("Cannot find the specified path");
                    }
                } else {
                    Command.getOut().println("Cannot find the specified path");
                }
            } else if (!this._shellCommandArgument.startsWith("/")) {
                if (!Utilities.setCurrentDirectory(curDirPath + addSeparatorChar + this._shellCommandArgument)) {
                    Command.getOut().println("Cannot find the specified path");
                }
            } else {
                Command.getOut().println("Cannot find the specified path");
            }
        } else if ("pwd".equals(this._commandName)) {
            this.getFileSystemManager();
            Command.getOut().println(Utilities.getCurrentDirectory());
            Command.getOut().println(Utilities.getCurrentLocalPath());
        } else if (REFRESH.equals(this._commandName)) {
            if (this._shellCommandArgument == null) {
                this._shellCommandArgument = "";
            }
            try {
                Command.refresh(this._shellCommandArgument);
            }
            catch (IllegalStateException exp) {
                Logger.traceUserError(LOCATION, exp, "Refresh failed.");
                Command.getOut().println(exp.getMessage());
            }
        } else if (DIR.equals(this._commandName) || LDIR.equals(this._commandName) || RDIR.equals(this._commandName)) {
            String currentDirectory;
            this.getFileSystemManager();
            boolean listLocal = false;
            boolean listRemote = false;
            if (DIR.equals(this._commandName)) {
                listRemote = true;
                listLocal = true;
            } else if (LDIR.equals(this._commandName)) {
                listLocal = true;
            } else if (RDIR.equals(this._commandName)) {
                listRemote = true;
            }
            if (this._shellCommandArgument == null || this._shellCommandArgument.length() == 0) {
                currentDirectory = Utilities.getCurrentDirectory();
                this._shellCommandArgument = "*";
            } else {
                int indexOfSeparator = this._shellCommandArgument.lastIndexOf("/");
                if (-1 != indexOfSeparator) {
                    String path = this._shellCommandArgument.substring(0, indexOfSeparator);
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    String tempCurDir = Utilities.getCurrentDirectory();
                    currentDirectory = Utilities.getCurrentDirectory();
                    if (currentDirectory.endsWith("/")) {
                        currentDirectory = currentDirectory.substring(0, currentDirectory.length() - 1);
                    }
                    String filterStr = !Utilities.setCurrentDirectory(currentDirectory + path) ? (Utilities.setCurrentDirectory(path) ? this._shellCommandArgument.substring(indexOfSeparator + 1) : this._shellCommandArgument) : this._shellCommandArgument.substring(indexOfSeparator + 1);
                    currentDirectory = Utilities.getCurrentDirectory();
                    Utilities.setCurrentDirectory(tempCurDir);
                    this._shellCommandArgument = filterStr;
                } else {
                    currentDirectory = Utilities.getCurrentDirectory();
                }
            }
            String[] files = this.getResourcePathsUsingFilter(currentDirectory, this._shellCommandArgument, listLocal, listRemote);
            ArrayList<String> pureFiles = new ArrayList<String>();
            ArrayList<String> pureFolders = new ArrayList<String>();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith("/")) {
                    pureFolders.add(files[i]);
                } else {
                    pureFiles.add(files[i]);
                }
                ++i;
            }
            TreeSet<String> ss = new TreeSet<String>();
            ss.addAll(pureFolders);
            Iterator it = ss.iterator();
            while (it.hasNext()) {
                Command.getOut().println(((String)it.next()).substring(currentDirectory.length()));
            }
            ss.clear();
            ss.addAll(pureFiles);
            it = ss.iterator();
            while (it.hasNext()) {
                Command.getOut().println(((String)it.next()).substring(currentDirectory.length()));
            }
            Command.getOut().println();
        }
        return true;
    }

    public boolean validateArguments() {
        if (CD.equals(this._commandName) && (this._shellCommandArgument == null || this._shellCommandArgument.length() == 0)) {
            this._commandName = "pwd";
        }
        return true;
    }

    public void printHelpDescription() {
        if (CD.equals(this._commandName)) {
            Command.getOut().println();
            Command.getOut().println(CD + " directory");
            Command.getOut().println();
            this.printOptionHelp(null, 1, "Command to change directory when in shell", false);
            Command.getOut().println();
            this.printOptionHelp(null, 1, "The command works with browse paths.", false);
            this.printOptionHelp(null, 1, "The browse path can either be the full browse path or relative browse path.", false);
            Command.getOut().println();
            this.printOptionHelp(null, 1, "Goes to the parent folder if invoked with ..", false);
            this.printOptionHelp(null, 1, CD + " ..", false);
            Command.getOut().println();
            this.printOptionHelp(null, 1, "Display current working directory if invoked without parameters", false);
            Command.getOut().println();
            this.printOptionHelp(null, 1, "The current working directory when the shell starts is the browse root", false);
            Command.getOut().println();
        } else if (REFRESH.equals(this._commandName)) {
            Command.getOut().println();
            Command.getOut().println(REFRESH + " [<client name>]");
            Command.getOut().println();
            this.printOptionHelp(null, 1, "Command to refresh the shell", false);
            Command.getOut().println();
            this.printOptionHelp(null, 1, "Optionally a client def name can be specified. The shell will then get refreshed using the specified client def.", false);
            Command.getOut().println();
            this.printOptionHelp(null, 1, "If a client def with the given name does not exist then the default client def will be used", false);
            Command.getOut().println();
            this.printOptionHelp(null, 1, "If the client def that was active before the refresh call is different from that specified, the current directory will be changed to the the browse root", false);
            Command.getOut().println();
        } else if (DIR.equals(this._commandName)) {
            Command.getOut().println();
            Command.getOut().println(DIR + " filter");
            Command.getOut().println();
            this.printOptionHelp(null, 1, "Command to get directory listing when in shell", false);
            Command.getOut().println();
            this.printOptionHelp(null, 1, "The command lists all the files/folders.", false);
            this.printOptionHelpEx(null, 1, "Includes", ": The files/folders which exist on the server", true);
            this.printOptionHelpEx(null, 1, "Includes", ": The files/folders which exist locally", false);
            Command.getOut().println();
        } else if (RDIR.equals(this._commandName)) {
            Command.getOut().println();
            Command.getOut().println(RDIR + " filter");
            Command.getOut().println();
            this.printOptionHelp(null, 1, "Command to get directory listing when in shell", false);
            Command.getOut().println();
            this.printOptionHelp(null, 1, "The command lists only the files/folders which exist on the server", false);
            Command.getOut().println();
        } else if (LDIR.equals(this._commandName)) {
            Command.getOut().println();
            Command.getOut().println(LDIR + " filter");
            Command.getOut().println();
            this.printOptionHelp(null, 1, "Command to get directory listing when in shell", false);
            Command.getOut().println();
            this.printOptionHelp(null, 1, "The command lists only the files/folders which exist on the local directory. This would include files/folders which are synced and and files/folders which exist locally but are not on the server", false);
            Command.getOut().println();
        }
    }

    public void setArguments(ArrayList arguments) {
        super.setArguments(arguments);
        if (arguments.size() != 1) {
            return;
        }
        this._shellCommandArgument = (String)arguments.get(0);
        arguments.remove(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

